#!/usr/bin/perl
# This file is part of the Savane project
# <http://gna.org/projects/savane/>
#
# $Id: sv_checkhistory.pl,v 1.3 2004/01/31 00:56:17 yeupou Exp $
#
#
#
# Copyright (C) 2002 Loic Dachary <loic@gnu.org>
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#
#
# Check that CVSROOT/history files have the expected permissions
#
use strict;

my($dir);

opendir(DIR, "/cvsroot") or die "cannot opendir /cvsroot : $!";
while($dir = readdir(DIR)) {
    my($history_file) = "/cvsroot/$dir/CVSROOT/history";
    if(-f $history_file) {
	my($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,
	   $atime,$mtime,$ctime,$blksize,$blocks)
	    = stat($history_file);

	if($mode != 0100666) {
	    printf "chmod 666 $history_file # was %lo\n", $mode;
	}
    }
}
closedir(DIR);
