#!/usr/bin/env ruby
#
# Samizdat front page
#
#   Copyright (c) 2002-2004  Dmitry Borodaenko <angdraug@debian.org>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU General Public License version 2 or later.
#

require 'samizdat'

request do |session|
    t = session.template
    skip, skip_focus = session.params %w[skip skip_focus]
    skip = skip.to_i
    skip_focus = skip_focus.to_i

    if 0 == skip then
        focuses_title = '<th>' + _('Main Focuses') + (skip_focus > 0 ?
            sprintf(_(', page %s'), skip_focus + 1) : '') + '</th>'
        focuses = rdf.select_all( %{
SELECT ?focus
WHERE (rdf::predicate ?stmt dc::relation)
      (rdf::subject ?stmt ?resource)
      (rdf::object ?stmt ?focus)
      (s::rating ?stmt ?rating)
LITERAL ?rating > 0
GROUP BY ?focus
ORDER BY count(?resource) DESC
USING PRESET NS},
        config['limit']['focuses'], config['limit']['focuses'] * skip_focus
        ).collect {|focus, usage| Resource.new(session, focus).render_related }
        focuses = '<td' + ((skip_focus > 0)? '' : ' class="focuses">') +
            focuses.join + %{<div class="foot">} +
            t.nav(focuses.size < config['limit']['focuses'],
            skip_focus + 1, 'index.rb?', 'skip_focus') + "</div></td>\n"
    end

    if 0 == skip_focus then
        updates_title = '<th>' + _('Recent Updates') +
            (skip > 0? sprintf(_(', page %s'), skip + 1) : '') + '</th>'
        updates = rdf.select_all( %{
SELECT ?msg
WHERE (dc::date ?msg ?date)
      (s::inReplyTo ?msg ?parent)
      (dct::isVersionOf ?msg ?current)
LITERAL ?parent IS NULL AND ?current IS NULL
ORDER BY ?date DESC
USING PRESET NS}, limit_page, limit_page * skip
        ).collect {|msg,| Resource.new(session, msg).render }
        updates = '<td' + ((skip > 0)? '' : ' class="updates"') + '>' +
            t.list(updates, t.nav(updates.size, skip + 1)) + '</td>'
    end

    page = %{<table><thead><tr>#{focuses_title}#{updates_title}</tr></thead>
<tr>#{focuses}#{updates}</tr></table>}

    t.page(_('Front Page'), page, {:no_box => true})
end
