# Samizdat common service functions
# 
#   Copyright (c) 2002-2003 Dmitry Borodaenko <angdraug@debian.org>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU General Public License version 2 or later.
#

SAMIZDAT_VERSION = '0.5.0'

# :main:samizdat.rb

require 'cgi'

require 'stringio'   # fix a conflict between Ruby 1.6 cgi.rb and yaml.rb
require 'tempfile'

# raised for syntax errors in Squish statements
#
class ProgrammingError < RuntimeError
end

# raised when non-existent resource is requested
#
class ResourceNotFoundError < RuntimeError
end

# raised on incorrect user action
#
class UserError < RuntimeError
end

# raised on action that requires login
#
class AuthError < UserError
end

# debug output
#
def log(msg)
    $stderr << 'Samizdat: ' << msg << "\n"
end

# expire timeout for permanent cookie
#
def forever
    60 * 60 * 24 * 365 * 5   # 5 years
end

require 'singleton'

# load and cache site configuration from config.yaml
#
class Config
    include Singleton

    def initialize
        require 'yaml'
        @config = YAML::load(File::open('config.yaml'))
    end

    attr_reader :config
end

# configuration access shortcut
#
def config
    Config.instance.config
end

# shortcut for page length limit config option
#
def limit_page
    config['limit']['page']
end

# shortcut for configured namespaces
#
def ns
    config['ns']
end

require 'samizdat/storage'
require 'samizdat/template'
require 'samizdat/session'
require 'samizdat/resource'
require 'samizdat/focus'
