#!/usr/bin/env ruby
#
# Samizdat resource display
# 
#   Copyright (c) 2002-2003 Dmitry Borodaenko <angdraug@debian.org>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU General Public License version 2 or later.
#

require 'samizdat'

session = Session.new

set_focus, = session.params %w[set_focus]

if set_focus.to_i > 0 then   # set current focus
    session.options['cookie'] << CGI::Cookie.new({
        'name' => config['session']['focus_cookie'],
        'value' => set_focus,
        'expires' => Time.now + forever
    })
    session.out({'status' => 'REDIRECT', 'location' => session.referer})
end

session.out() do |t|

    # RewriteRule ^(/samizdat-base)/([0-9]+)$ $1/resource.rb?id=$2 [PT]
    #
    id, rating = session.params %w[id rating]
    id.nil? and raise ResourceNotFoundError, "Incorrect resource id '#{id}'"
    resource = Resource.new(session, id)

    # render resource
    type, head, description = resource.render(:full)
    page = [ [ type + ' / ' + head, description ] ]

    # focus management
    skip, = session.params %w[skip_focus]
    skip = skip.to_i
    related = session.rdf.select_all( %{
SELECT ?msg
WHERE (rdf::subject ?stmt ?msg)
      (rdf::predicate ?stmt dc::relation)
      (rdf::object ?stmt #{session.base}#{id})
      (s::thread ?msg ?msg)
      (s::rating ?stmt ?rating)
      (dc::date ?msg ?date)
LITERAL ?rating > 0
ORDER BY ?date DESC
USING PRESET NS}, limit_page, limit_page * skip
    ).collect {|msg,| Resource.new(session, msg).render }
    page.unshift [
        'Focus / ' + head,
        t.list(related,
            t.nav(skip + 1, "resource.rb?id=#{id}&amp;", 'skip_focus'))
    ] if related.size > 0

    focus = Focus.new(resource)
    page << [ 'Your Current Focus',
        t.box(nil, focus.render) + t.box(nil,
%{<p><a href="resource.rb?set_focus=#{id}">Focus on this resource (#{head})</a></p>}) ]

    # related focuses
    focuses = {focus.id => focus}
    (
        session.rdf.select_all( %{
SELECT ?focus
WHERE (rdf::subject ?stmt #{session.base}#{id})
      (rdf::predicate ?stmt dc::relation)
      (rdf::object ?stmt ?focus)
      (s::rating ?stmt ?rating)
ORDER BY ?rating DESC
USING PRESET NS}, limit_page
        ).collect {|f,| f } + config['focus']   # add standard focuses
    ).each {|focus|
        f = Focus.new(resource, focus)
        focuses[f.id] = f
    }

    # vote on focus rating
    if session.has_key? 'related' then
        session.id.nil? and raise AuthError, "You should be logged in to vote"

        focus = Focus.new(resource, session['related'])
        focus.uriref == resource.uriref and
            raise UserError, "You can't relate resource to itself"

        if rating then   # commit vote
            focus.rating = rating
            session.out({'status' => 'REDIRECT', 'location' => session.referer})
        else   # display vote form
            vote = t.vote_box(focus)
        end
    end

    session.options['x-pingback'] = session.base + 'pingback.rb' if
        config['pingback']['login']

    t.page(nil, page, t.focus_box(id, focuses.values) + vote.to_s)
end
