#!/usr/bin/env ruby
#
# Samizdat Pingback server
# 
#   Copyright (c) 2002-2003 Dmitry Borodaenko <angdraug@debian.org>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU General Public License version 2 or later.
#

require 'xmlrpc/server'
require 'net/http'
require 'uri'
require 'samizdat'

include XMLRPC

server = defined?(MOD_RUBY) ? ModRubyServer.new : CGIServer.new

server.add_handler('pingback.ping') do |source, target|
    raise FaultException.new(0, "Source is not a valid URI") unless
        source =~ URI::URI_REF
    pingback = config['pingback']
    raise FaultException.new(0x0021, "Pingback is disabled") if
        pingback.nil? or pingback['login'].nil?

    # check if target exists and is properly pingback-enabled
    base = 'http://' + ENV['HTTP_HOST'] + config['site']['base'] + '/'
    rdf = SamizdatRDF.new(base)
    title, thread = rdf.select_one %{
SELECT ?title, ?thread
WHERE (dc::title #{target} ?title)
      (s::thread #{target} ?thread)
USING PRESET NS}
    raise FaultException.new(0x0021, "Target doesn't support pingback") if
        title.nil?
    member, = rdf.select_one %{
SELECT ?member
WHERE (s::login ?member '#{pingback['login']}')
USING PRESET NS}
    raise FaultException.new(0x0031, "Can't authorize Pingback") if
        member.nil?

    # verify that the source does indeed link to the target
    response = Net::HTTP.get_response(URI.parse(source))
    raise FaultException.new(0x0010, "Failed to fetch source URI") unless
        response.kind_of? Net::HTTPSuccess
    raise FaultException.new(
        0x0011, "Source does not contain a link to target"
    ) unless response.body.include? target

    # check if pingback has not already been registered
    pattern = %{(s::inReplyTo ?pingback #{target})
      (s::thread ?pingback #{base}#{thread})
      (dc::creator ?pingback #{base}#{member})
      (dc::format ?pingback 'text/uri-list')
      (dc::title ?pingback ?title)
      (s::content ?pingback ?content)
USING PRESET NS}
    rdf.select_all(%{SELECT ?content WHERE #{pattern}}) do |content,|
        raise FaultException.new(0x0030, "Pingback is already registered") if
            content =~ /^#{source}$/
    end

    # record the pingback
    rdf.merge %{INSERT ?pingback
UPDATE ?content = '#{source}', ?title = '#{title}'
WHERE #{pattern}}
    "OK"
end

server.serve
