#!/usr/bin/env ruby
#
# Samizdat material item exchange
# 
#   Copyright (c) 2002-2003 Dmitry Borodaenko <angdraug@debian.org>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU General Public License version 2 or later.
#

require 'samizdat'

s = Session.new

# todo: implement material items exchange
s.out() { s.template.page('Not Implemented',
'<p>Material item exchange is not implemented yet.</p>') }

title = 'Share Item'

if s.id.nil? then
    s.out() { s.template.page('Please Login',
"<p>You should be logged in to share items, please use the form in the sidebar.
If you don't yet have an account, <a href=member.rb>create</a> it now.</p>") }
end

item, instance = cgi_check %w[item instance]

if instance then   # fixme: validate
    if cgi.has_key?('confirm') then
        db.transaction do |db|
            db.do 'INSERT INTO ItemLog (instance, taken_from, given_to)
                VALUES (?, (SELECT possessor FROM Instance WHERE id = ?), ?)',
                instance, instance, s.id
            db.do 'UPDATE Instance SET possessor = ? WHERE id = ?',
                s.id, instance
        end
        page = template.page(s, 'Possession Recorded',
%'Item instance <a href="#{instance}">##{instance}</a> was transferred to you')
    else
        page = template.page( s, 'Confirm Possession',
"<p>You are about to record your possession of the item instance.</p>" +
            template.form('item.rb', [
                ['hidden', 'instance', nil, instance],
                ['hidden', 'confirm', nil]
            ], 'Confirm') +
"<p>Press 'Back' button to return to the item instance description.</p>"
        )
    end
elsif item then
    # new item
else   # browse items
end

s.out() { page }
