#!/usr/bin/env ruby
#
# Samizdat front page
# 
#   Copyright (c) 2002-2003 Dmitry Borodaenko <angdraug@debian.org>
#
#   This program is free software.
#   You can distribute/modify this program under the terms of
#   the GNU General Public License version 2 or later.
#

require 'samizdat'

session = Session.new

session.out do |t|
    skip, skip_focus = session.params %w[skip skip_focus]
    skip = skip.to_i
    skip_focus = skip_focus.to_i

    messages = session.rdf.select_all( %{
SELECT ?msg
WHERE (dc::date ?msg ?date)
      (s::thread ?msg ?msg)
ORDER BY ?date DESC
USING PRESET NS}, limit_page, limit_page * skip
    ).collect {|msg,| Resource.new(session, msg).render }

    page = [ [ 'Recent Threads', t.list(messages, t.nav(skip + 1)) ] ]

    usage = {}
    session.rdf.select_all( %{
SELECT ?focus, ?resource, ?rating
WHERE (rdf::predicate ?stmt dc::relation)
      (rdf::subject ?stmt ?resource)
      (rdf::object ?stmt ?focus)
      (s::rating ?stmt ?rating)
ORDER BY ?resource DESC
USING PRESET NS}
    ).each {|focus, resource, rating|
        if rating.to_f > 0 then
            usage[focus] = (usage[focus])? usage[focus].succ : 1
        elsif usage[focus].nil?
            usage[focus] = 0
        end
    }

    table = usage.sort {|a, b|
        b[1] <=> a[1]
    }[limit_page * skip_focus, limit_page].collect {|focus, usage|
        [ Resource.new(session, focus).render, usage ]
    }

    page << [ 'Important Focuses',
        t.table([['Focus', 'Related Resources']] + table,
            t.nav(skip_focus + 1, 'index.rb?', 'skip_focus')) ]

    t.page('Front Page', page)
end
