-- Samizdat Database Creation
-- 
--   Copyright (c) 2002-2003 Dmitry Borodaenko <angdraug@debian.org>
--
--   This program is free software.
--   You can distribute/modify this program under the terms of
--   the GNU General Public License version 2 or later.
--

-- RDF Data Model
CREATE TABLE Resource (
	id SERIAL PRIMARY KEY,
	published_date TIMESTAMP DEFAULT 'now', -- received date with creator tz
	literal BOOLEAN DEFAULT false,
	uriref BOOLEAN DEFAULT false,
	label TEXT); -- literal value | external uriref | internal class name
	-- optimize: store external uriref hash in numeric field

CREATE TABLE Statement (
	id INT PRIMARY KEY REFERENCES Resource,
	subject INT REFERENCES Resource,
	predicate INT REFERENCES Resource,
	object INT REFERENCES Resource);

-- Members and Sessions
CREATE TABLE Member (
	id INT PRIMARY KEY REFERENCES Resource,
	login TEXT UNIQUE NOT NULL,
	full_name TEXT NOT NULL,
	email TEXT,
	passwd TEXT,
	session TEXT UNIQUE,
	login_time TIMESTAMP,
	last_time TIMESTAMP);

-- Messages and Threads
CREATE TABLE Message (
	id INT PRIMARY KEY REFERENCES Resource,
	msg_id TEXT,   -- for email/news threading only
	parent INT REFERENCES Message, -- In-Reply-To:
	thread INT NOT NULL,
	title TEXT NOT NULL,   -- Subject:
	creator INT NOT NULL REFERENCES Member,   -- From:
	format TEXT,   -- MIME type
	content TEXT);

-- Voting Data
CREATE TABLE Proposition (
	id INT PRIMARY KEY REFERENCES Statement,
	rating NUMERIC(4,2)); -- computed from Vote

CREATE TABLE Vote (
	id INT PRIMARY KEY REFERENCES Resource,
	proposition INT REFERENCES Proposition,
	member INT REFERENCES Member,
	UNIQUE (proposition, member),
	rating NUMERIC(2));

-- Material Items Sharing
CREATE TABLE Item (
	id INT PRIMARY KEY REFERENCES Resource,
	description INT REFERENCES Message,
	contributor INT REFERENCES Member,
	possessor INT REFERENCES Member);

CREATE TABLE Possession (
	id INT PRIMARY KEY REFERENCES Resource,
	item INT REFERENCES Item,
	taken_from INT REFERENCES Member,
	given_to INT REFERENCES Member);

-- grant access in case we run this under another user
GRANT ALL ON Resource, Resource_id_seq, Statement, Proposition, Vote,
	Member, Message, Item, Possession
TO samizdat;
