CREATE TABLE resource (
	id SERIAL PRIMARY KEY,

	rdfs_label TEXT,
	comment TEXT,
	publisher INTEGER,
	publishDate DATE,

	literal BOOLEAN DEFAULT false,
	uriref BOOLEAN DEFAULT false,
	label TEXT);
);

CREATE INDEX resource_uriref_idx ON Resource (uriref);
CREATE INDEX resource_label_idx ON Resource (label);
CREATE INDEX resource_rdfs_label_ts_idx ON resource USING gin(to_tsvector('simple', rdfs_label));

CREATE TABLE productfeature (
	id INTEGER REFERENCES resource,
);

CREATE TABLE producttype (
	id INTEGER REFERENCES resource,
	parent INTEGER
);

CREATE TABLE producer (
	id INTEGER REFERENCES resource,
	homepage TEXT,
	country CHAR(2)
);

CREATE TABLE product (
	id INTEGER REFERENCES resource,
	producer INTEGER,
	propertyNum1 INTEGER,
	propertyNum2 INTEGER,
	propertyNum3 INTEGER,
	propertyNum4 INTEGER,
	propertyNum5 INTEGER,
	propertyNum6 INTEGER,
	propertyTex1 TEXT,
	propertyTex2 TEXT,
	propertyTex3 TEXT,
	propertyTex4 TEXT,
	propertyTex5 TEXT,
	propertyTex6 TEXT
);

CREATE INDEX product_producer_idx ON product (producer);
CREATE INDEX product_properties_index ON product (
	propertynum1, propertynum2, propertynum3,
	propertynum4, propertynum5, propertynum6);

CREATE TABLE producttypeproduct (
	id INTEGER,
	productType INTEGER,
	PRIMARY KEY (product, productType)
);

CREATE INDEX producttypeproduct_producttype_id_idx
	ON producttypeproduct (productType, id);

CREATE TABLE productfeatureproduct (
	id INTEGER,
	productFeature INTEGER,
	PRIMARY KEY (product, productFeature)
);

CREATE INDEX productfeatureproduct_productfeature_id_idx
	ON productfeatureproduct (productFeature, id);

CREATE TABLE vendor (
	id INTEGER REFERENCES resource,
	homepage TEXT,
	country CHAR(2)
);

CREATE TABLE offer (
	id INTEGER REFERENCES resource,
	product INTEGER,
	producer INTEGER,
	vendor INTEGER,
	price DOUBLE PRECISION,
	validFrom TIMESTAMP,
	validTo TIMESTAMP,
	deliveryDays INTEGER,
	offerWebpage TEXT
);

CREATE INDEX offer_product_idx ON offer (product);
CREATE INDEX offer_vendor_idx ON offer (vendor);
CREATE INDEX offer_product_validto_idx ON offer (product, validto);
CREATE INDEX offer_product_deliverydays_validto_idx
	ON offer (product, deliveryDays, validTo);

CREATE TABLE person (
	id INTEGER REFERENCES resource,
	name TEXT,
	mbox_sha1sum TEXT,
	country CHAR(2)
);

CREATE TABLE review (
	id INTEGER REFERENCES resource,
	product INTEGER,
	producer INTEGER,
	person INTEGER,
	reviewDate TIMESTAMP,
	title TEXT,
	text TEXT,
	language CHAR(2),
	rating1 INTEGER,
	rating2 INTEGER,
	rating3 INTEGER,
	rating4 INTEGER
);

CREATE INDEX review_product_idx ON review (product);
CREATE INDEX review_person_idx ON review (person);
CREATE INDEX review_product_person_idx ON review (product, person);
