CREATE TABLE productfeature (
	nr INTEGER PRIMARY KEY,
	label TEXT,
	comment TEXT,
	publisher INTEGER,
	publishDate DATE
);

CREATE TABLE producttype (
	nr INTEGER PRIMARY KEY,
	label TEXT,
	comment TEXT,
	parent INTEGER,
	publisher INTEGER,
	publishDate DATE
);

CREATE TABLE producer (
	nr INTEGER PRIMARY KEY,
	label TEXT,
	comment TEXT,
	homepage TEXT,
	country CHAR(2),
	publisher INTEGER,
	publishDate DATE
);

CREATE TABLE product (
	nr INTEGER PRIMARY KEY,
	label TEXT,
	comment TEXT,
	producer INTEGER,
	propertyNum1 INTEGER,
	propertyNum2 INTEGER,
	propertyNum3 INTEGER,
	propertyNum4 INTEGER,
	propertyNum5 INTEGER,
	propertyNum6 INTEGER,
	propertyTex1 TEXT,
	propertyTex2 TEXT,
	propertyTex3 TEXT,
	propertyTex4 TEXT,
	propertyTex5 TEXT,
	propertyTex6 TEXT,
	publisher INTEGER,
	publishDate DATE
);

CREATE INDEX product_producer_idx ON product (producer);

CREATE TABLE producttypeproduct (
	product INTEGER,
	productType INTEGER,
	PRIMARY KEY (product, productType)
);

CREATE TABLE productfeatureproduct (
	product INTEGER,
	productFeature INTEGER,
	PRIMARY KEY (product, productFeature)
);

CREATE TABLE vendor (
	nr INTEGER PRIMARY KEY,
	label TEXT,
	comment TEXT,
	homepage TEXT,
	country CHAR(2),
	publisher INTEGER,
	publishDate DATE
);

CREATE TABLE offer (
	nr INTEGER PRIMARY KEY,
	product INTEGER,
	producer INTEGER,
	vendor INTEGER,
	price DOUBLE PRECISION,
	validFrom TIMESTAMP,
	validTo TIMESTAMP,
	deliveryDays INTEGER,
	offerWebpage TEXT,
	publisher INTEGER,
	publishDate DATE
);

CREATE INDEX offer_product_idx ON offer (product);
CREATE INDEX offer_vendor_idx ON offer (vendor);

CREATE TABLE person (
	nr INTEGER PRIMARY KEY,
	name TEXT,
	mbox_sha1sum TEXT,
	country CHAR(2),
	publisher INTEGER,
	publishDate DATE
);

CREATE TABLE review (
	nr INTEGER PRIMARY KEY,
	product INTEGER,
	producer INTEGER,
	person INTEGER,
	reviewDate TIMESTAMP,
	title TEXT,
	text TEXT,
	language CHAR(2),
	rating1 INTEGER,
	rating2 INTEGER,
	rating3 INTEGER,
	rating4 INTEGER,
	publisher INTEGER,
	publishDate DATE
);

CREATE INDEX review_product_idx ON review (product);
CREATE INDEX review_person_idx ON review (person);
