
package ruli.sample;

import java.util.Map;

import ruli.RuliSync;

public class RuliSyncSmtpSearch {
    
    private static void usage() {
	System.err.println("usage:   RuliSyncSmtpSearch domain [options]");
	System.err.println("example: RuliSyncSmtpSearch mail-domain.tld");
	System.exit(1);
    }

    public static void main(String[] args) {

	if ((args.length < 1) || (args.length > 2))
	    usage();

	String domain = args[0];
	int options = (args.length > 1) ? Integer.parseInt(args[1]) : 0;

	Map[] srvList = RuliSync.smtpQuery(domain, options);

	System.out.println(domain);

	for (int i = 0; i < srvList.length; ++i) {
	    Map m = srvList[i];
	    String target = (String) m.get("target");
	    int priority = ((Integer) m.get("priority")).intValue();
	    int weight = ((Integer) m.get("weight")).intValue();
	    int port = ((Integer) m.get("port")).intValue();

	    System.out.print("  target=" + target + " priority=" + priority + " weight=" + weight + " port=" + port + " addresses=");
	    
	    String[] addrList = (String[]) m.get("addresses");
	    for (int j = 0; j < addrList.length; ++j) {
		System.out.print(addrList[j] + " ");
	    }
	    
	    System.out.println();
	}

    }

}
