#!/bin/bash

. ./VERSION

source ./DefConf.inc

DOCFILES="COPYING ChangeLog README TODO sample_monthly sample_rc"

echo "install script for Rot[t]Log v.$VERSION"
echo
echo "Updating bash codes..."

esc_MAINPATH=${MAINPATH//\//\\/}
sed -e 's/^MAINPATH=.*/MAINPATH=\"$esc_MAINPATH\"/' rottlog >newrottlog
if [ ! -s newrottlog ]; then
  echo "Error using sed to modify rottlog!!"
  echo "Please send to stefko5@inwind.it an e-mail with as much as possible"
  echo "detailed information about error messages and you environnement."
  echo "I'll try to solve this problem as soon as possible. Thanks."
  exit 3
else
  mv newrottlog rottlog
fi
sed -e 's/^MAINPATH=.*/MAINPATH=\"$esc_MAINPATH\"/' virottrc >newvirottrc
if [ ! -s newvirottrc ]; then
  echo "Error using sed to modify virottrc!!"
  echo "Please send to stefko5@inwind.it an e-mail with as much as possible"
  echo "detailed information about error messages and you environnement."
  echo "I'll try to solve this problem as soon as possible. Thanks."
  exit 3
else
  mv newvirottrc virottrc
fi


mkdir -p $BINDIR
rm -f $BINDIR/rottlog
rm -f $BINDIR/virott[rc,month,day,week]*

install -o $LOG_OWN -g $LOG_GROUP -m $LOG_MODE rottlog $BINDIR
install -o $LOG_OWN -g $LOG_GROUP -m $LOG_MODE virottrc $BINDIR
ln -sf $BINDIR/virottrc $BINDIR/virottday
ln -sf $BINDIR/virottrc $BINDIR/virottweek
ln -sf $BINDIR/virottrc $BINDIR/virottmonth

mkdir -p $DOCDIR/rottlog-$VERSION
for D in $DOCFILES; do
  install -o $LOG_OWN -g $LOG_GROUP -m 0644 $D $DOCDIR/rottlog-$VERSION
done

mkdir -p $ROTT_ETCDIR
chmod 0300 ROTT_ETCDIR

