; Copyright (c) 2004, Jonah Nathaniel Beckford
; All rights reserved.
;
; Redistribution and use in source and binary forms, with or without
; modification, are permitted provided that the following conditions
; are met:
;
;   Redistributions of source code must retain the above copyright
;   notice, this list of conditions and the following disclaimer.
;
;   Redistributions in binary form must reproduce the above copyright
;   notice, this list of conditions and the following disclaimer in
;   the documentation and/or other materials provided with the
;   distribution.
;
;   Neither the name of the author nor the names of its contributors
;   may be used to endorse or promote products derived from this
;   software without specific prior written permission.
;
; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
; "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
; LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
; FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
; COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
; INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
; (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
; SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
; HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
; STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
; ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
; OF THE POSSIBILITY OF SUCH DAMAGE.
;
; jonah@usermail.com

(lambda (GTYPE VARGS streamed? bidirectional? vertex-properties get-vl)
  (define (pad . args)
    (string->symbol
      (apply string-append
        (map (lambda (a)
               (cond
                 [(string? a) a]
                 [(symbol? a) (symbol->string a)]
                 [else "UNKNOWN_PAD_SYMBOL"]))
          args))))
  (define plus (if streamed? "*" ""))
  (define prefix-plus (if streamed? "stream-" ""))
  (define (when-bi . in-args)
    (if bidirectional? in-args '()))
  (define (unless-bi . in-args)
    (if bidirectional? '() in-args))
  (let* (
	 [for-each+ (pad prefix-plus "for-each")]
	 [map+ (pad prefix-plus "map")]

         [NP (length vertex-properties)]
         [vl (pad GTYPE "-vertex-list")]
         [vl? (gensym)]
         [make-vl (gensym)]
         [vl-table (gensym)]
         [set-vl-table! (gensym)]
         [vl-max-index (gensym)]
         [set-vl-max-index! (gensym)]
         [rec (pad GTYPE "-vertex")]
         [rec? (gensym)]
         [make-rec (gensym)]
         [rec-index (gensym)]
         [set-rec-index! (gensym)]
         [rec-out-edge-l (gensym)]
         [set-rec-out-edge-l! (gensym)]
         [rec-in-edge-l (gensym)]
         [set-rec-in-edge-l! (gensym)]
         [rec-props (gensym)]
         [set-rec-props! (gensym)]
         
         [vertex-set? (pad GTYPE "-vertex-set?")]
         [constructor (pad "##carp#make-" GTYPE "-vl")]
         [check-valid (gensym)]
         [vertex-index (pad GTYPE "-vertex-index")]
         [add-vertex! (pad GTYPE "-add-vertex!")]
         [remove-vertex! (pad GTYPE "-remove-vertex!")]
         [vertex (pad GTYPE "-vertex")]
         [vertex-eq? (pad GTYPE "-vertex-eq?")]
         [out-edge-list (pad "##carp#" GTYPE "-out-edge-list")]
         [in-edge-list (pad "##carp#" GTYPE "-in-edge-list")]
         [num-vertices (pad GTYPE "-num-vertices")]
         [vertices (pad GTYPE "-vertices")]
         [vertices* (pad GTYPE "-vertices*")]
         [clear! (pad GTYPE "-clear!")]
         
         ;; imports
         [el-constructor (pad "##carp#make-" GTYPE "-el")]
         [edge (pad GTYPE "-edge")]
         [in-edges+ (pad GTYPE "-in-edges" plus)]
         [out-edges+ (pad GTYPE "-out-edges" plus)]
         [remove-edge! (pad GTYPE "-remove-edge!")]
         [transform-vertices! (pad "##carp#" GTYPE "-transform-vertices!")]
         )
    `(begin
       (define-macro ,vertex-set? (lambda () `#t))
       (define-record-type ,vl
         (,make-vl table max-index)
         ,vl?
         (table ,vl-table ,set-vl-table!)
         (max-index ,vl-max-index ,set-vl-max-index!))
       (define-record-printer ,vl
         (lambda (x p)
           (fprintf p "Vertex List vl-hash~%")
           (fprintf p "size\t~S" (hash-table-count (,vl-table x)))))
       (define-record-type ,rec
         (,make-rec index out-edge-l ,@(when-bi 'in-edge-l) props)
         ,rec?
         (index ,rec-index ,set-rec-index!)
         (out-edge-l ,rec-out-edge-l ,set-rec-out-edge-l!)
         ,@(when-bi `(in-edge-l ,rec-in-edge-l ,set-rec-in-edge-l!))
         (props ,rec-props ,set-rec-props!))
       (define-record-printer ,rec
         (lambda (x p)
           (fprintf p "Vertex ~S" x)))
       (define ,constructor
         (lambda (g)
           (,make-vl (make-hash-table ,@VARGS) 0)))
       (define-macro ,check-valid
         (lambda (u) #t))
       (define ,vertex-index
         (lambda (g v)
           (let* ([vl (,get-vl g)]
                  [table (,vl-table vl)]
                  [rec (hash-table-ref table v)])
             (,rec-index rec))
           v))
       ,@(let ([index -1])
           (map
             (lambda (prop)
               (let ([getter (pad GTYPE "-" prop)]
                     [setter! (pad "set-" GTYPE "-" prop "!")]
		     [pmap (pad GTYPE "-" prop "-map")])
                 (set! index (add1 index))
                 `(begin
                    (define ,getter
                      (lambda (g v)
                        (,check-valid v)
                        (vector-ref (,rec-props (hash-table-ref (,vl-table (,get-vl g)) v)) ,index)))
                    (define ,setter!
                      (lambda (g v p)
                        (,check-valid v)
                        (vector-set! (,rec-props (hash-table-ref (,vl-table (,get-vl g)) v)) ,index p)))
                    (define ,pmap (cons ,getter ,setter!)))))
             vertex-properties))
       (define ,add-vertex!
         (lambda (g key . ignored)
           (let* ([vl (,get-vl g)]
                  [table (,vl-table vl)]
                  [rec (hash-table-ref table key)])
             (unless rec
               (let ([index (,vl-max-index vl)])
                 (hash-table-set! table key
                   (,make-rec
                     index
                     (,el-constructor g)
                     ,@(when-bi `(,el-constructor g))
                     (make-vector ,NP #f)))
                 (,set-vl-max-index! vl (add1 index))))
             ;; leave, with key as vertex_descriptor
             key)))
       (define ,remove-vertex!
         (lambda (g u)           
           (let* ([vl (,get-vl g)]
                  [table (,vl-table vl)])
             (,check-valid u)

	     ;; Remove all out-edges of u
	     (,for-each+
	      (lambda (u^v) (,remove-edge! g u^v))
	      (,out-edges+ g u))
             ;; Remove all in-edges of u
	     ,@(when-bi
		`(,for-each+
		  (lambda (v^u) (,remove-edge! g v^u))
		  (,in-edges+ g u)))
	     ,@(unless-bi
		`(do ([v 0 (add1 v)])
		     ((>= v num))
		   (let ([v^u (,edge g v u)])
		     (when v^u 		   
		       (,remove-edge! g v^u)))))
             ;; Remove the vertex
             (hash-table-remove! table u))))
       (define ,vertex-eq?
         (lambda (g u v)
           (let* ([vl (,get-vl g)]
                  [table (,vl-table vl)])
             (,check-valid u)
             (,check-valid v)
             (,(if (pair? VARGS) (car VARGS) 'eq?) u v))))
       (define ,out-edge-list
         (lambda (g u)
           (let* ([vl (,get-vl g)]
                  [table (,vl-table vl)])
             (,check-valid u)
             (,rec-out-edge-l (hash-table-ref table u)))))
       ,@(when-bi
           `(define ,in-edge-list
              (lambda (g u)
                (let* ([vl (,get-vl g)]
                       [table (,vl-table vl)])
                  (,check-valid u)
                  (,rec-in-edge-l (hash-table-ref table u))))))
       (define ,vertices
         (lambda (g)
           (let* ([vl (,get-vl g)]
                  [table (,vl-table vl)])
             (hash-table-map
               (lambda (k v) k)
               table))))
       (define ,vertices*
         (lambda (g)
           (let* ([vl (,get-vl g)]
                  [table (,vl-table vl)])
             (stream-map             
               (lambda (kv) (car kv))
               (hash-table->stream table)))))
       (define ,num-vertices
         (lambda (g)
           (let* ([vl (,get-vl g)]
                  [table (,vl-table vl)])
             (hash-table-count table))))
       (define ,clear!
         (lambda (g)
           (let* ([vl (,get-vl g)]
                  [table (,vl-table vl)])
             (clear-hash-table! table))))
              
       )))