; Copyright (c) 2004, Jonah Nathaniel Beckford
; All rights reserved.
;
; Redistribution and use in source and binary forms, with or without
; modification, are permitted provided that the following conditions
; are met:
;
;   Redistributions of source code must retain the above copyright
;   notice, this list of conditions and the following disclaimer.
;
;   Redistributions in binary form must reproduce the above copyright
;   notice, this list of conditions and the following disclaimer in
;   the documentation and/or other materials provided with the
;   distribution.
;
;   Neither the name of the author nor the names of its contributors
;   may be used to endorse or promote products derived from this
;   software without specific prior written permission.
;
; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
; "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
; LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
; FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
; COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
; INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
; (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
; SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
; HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
; STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
; ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
; OF THE POSSIBILITY OF SUCH DAMAGE.
;
; jonah@usermail.com

(require-extension srfi-40)
(cond-expand
  [srfi-40
    (print "Using rgraph stream functions; found 'srfi-40 extension")]
  [else
    (print "Not using rgraph stream functions because no 'srfi-40 extension")])
(newline)

(require-for-syntax 'rgraph)
(require 'rgraph-base)


(print "define-adjacency-list ...")
(define-adjacency-list myg1
  ()
  (vl-hash) (vertex-name vertex-color)
  (el-hash) (edge-weight)
  #t #t)
(newline)


(print "make ...")
(define g1 (make-myg1))
(print g1)
(newline)


(print "add-vertex! add-edge! ...")
(define v1 (myg1-add-vertex! g1 'v1))
(define v2 (myg1-add-vertex! g1 'v2))
(define v3 (myg1-add-vertex! g1 'v3))
(define e1 (myg1-add-edge! g1 v1 v2))
(define e2 (myg1-add-edge! g1 v1 v3))
(define e3 (myg1-add-edge! g1 v2 v3))
(print e1)
(newline)


(print "vertices ...")
(print (myg1-vertices g1))
(cond-expand
  [srfi-40
    (stream-for-each print (myg1-vertices* g1))]
  [else])


(print "edge ...")
(let-rgraph myg1
  (print (edge g1 v1 v2))
  (newline))


(print "out-edges ...")
(print (myg1-out-edges g1 v2))
(cond-expand
  [srfi-40
    (stream-for-each print (myg1-out-edges* g1 v1))]
  [else
    (print (myg1-out-edges g1 v1))])
(newline)

(print "in-edges ...")
(print (myg1-in-edges g1 v2))
(cond-expand
  [srfi-40
    (stream-for-each print (myg1-in-edges* g1 v3))]
  [else
    (print (myg1-in-edges g1 v3))])
(newline)


(print "internal properties ...")
(set-myg1-vertex-name! g1 v1 "first vertex name")
(print (myg1-vertex-name g1 v1))
(print (myg1-vertex-name g1 v2))
(set-myg1-edge-weight! g1 e1 "first edge weight")
(print (myg1-edge-weight g1 e1))
(print (myg1-edge-weight g1 e2))
(newline)


(print "num-vertices / num-edges ...")
;; when remove a vertex, all edges it belongs too must be deleted as
;; well.  so number of edges should decrement by one for this example.
(define t1 (myg1-num-vertices g1))
(define t2 (myg1-out-degree g1 v1))
(define s2 (myg1-in-degree g1 v3))
(printf "out ~S / ~S~%" t1 t2)
(printf "in  ~S / ~S~%" t1 s2)
(myg1-remove-vertex! g1 v2)
(when (and (integer? v3) (not (myg1-vertex-set?)))
  ;; this should work, because the old vertex 3 is now vertex 2.
  ;; ONLY for vl-vector
  (set! v3 (myg1-vertex g1 1)))
(define t3 (myg1-num-vertices g1))
(define t4 (myg1-out-degree g1 v1))
(define s4 (myg1-in-degree g1 v3))
(unless (= (sub1 t1) t3)
  (error "The number of vertices did not decrease by one"))
(unless (= (sub1 t2) t4 (length (myg1-out-edges g1 v1)))
  (error "The number of out-edges did not decrease by one"))
(unless (= (sub1 s2) s4 (length (myg1-in-edges g1 v3)))
  (error "The number of in-edges did not decrease by one"))
(printf "out ~S / ~S~%" t3 t4)
(printf "in  ~S / ~S~%" t3 s4)
(cond-expand
  [srfi-40
    (stream-for-each print (myg1-out-edges* g1 v1))]
  [else
    (print (myg1-out-edges g1 v1))])
(unless (myg1-edge g1 v1 v3)
  (error "The vertex descriptor in the edges were not recalculated upon removal of a vertex"))
(newline)
