; Copyright (c) 2004, Jonah Nathaniel Beckford
; All rights reserved.
;
; Redistribution and use in source and binary forms, with or without
; modification, are permitted provided that the following conditions
; are met:
;
;   Redistributions of source code must retain the above copyright
;   notice, this list of conditions and the following disclaimer.
;
;   Redistributions in binary form must reproduce the above copyright
;   notice, this list of conditions and the following disclaimer in
;   the documentation and/or other materials provided with the
;   distribution.
;
;   Neither the name of the author nor the names of its contributors
;   may be used to endorse or promote products derived from this
;   software without specific prior written permission.
;
; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
; "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
; LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
; FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
; COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
; INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
; (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
; SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
; HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
; STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
; ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
; OF THE POSSIBILITY OF SUCH DAMAGE.
;
; jonah@usermail.com

(lambda (GTYPE VARGS streamed? bidirectional? vertex-properties get-vl)
  (define (pad . args)
    (string->symbol
      (apply string-append
        (map (lambda (a)
               (cond
                 [(string? a) a]
                 [(symbol? a) (symbol->string a)]
                 [else "UNKNOWN_PAD_SYMBOL"]))
          args))))
  (define plus (if streamed? "*" ""))
  (define prefix-plus (if streamed? "stream-" ""))
  (define (when-bi . in-args)
    (if bidirectional? in-args '()))
  (define (unless-bi . in-args)
    (if bidirectional? '() in-args))
  (let* (
	 [for-each+ (pad prefix-plus "for-each")]
	 [map+ (pad prefix-plus "map")]

         [NP (length vertex-properties)]
         [vl (pad GTYPE "-vertex-list")]
         [vl? (gensym)]
         [make-vl (gensym)]
         [vl-num (gensym)]
         [set-vl-num! (gensym)]
         [vl-vec (gensym)]
         [set-vl-vec! (gensym)]
         [rec (pad GTYPE "-vertex")]
         [rec? (gensym)]
         [make-rec (gensym)]
         [rec-out-edge-l (gensym)]
         [set-rec-out-edge-l! (gensym)]
         [rec-in-edge-l (gensym)]
         [set-rec-in-edge-l! (gensym)]
         [rec-props (gensym)]
         [set-rec-props! (gensym)]
         
         [vertex-set? (pad GTYPE "-vertex-set?")]
         [constructor (pad "##carp#make-" GTYPE "-vl")]
         [check-valid (gensym)]
         [vertex-index (pad GTYPE "-vertex-index")]
         [add-vertex! (pad GTYPE "-add-vertex!")]
         [remove-vertex! (pad GTYPE "-remove-vertex!")]
         [vertex (pad GTYPE "-vertex")]
         [vertex-eq? (pad GTYPE "-vertex-eq?")]
         [out-edge-list (pad "##carp#" GTYPE "-out-edge-list")]
         [in-edge-list (pad "##carp#" GTYPE "-in-edge-list")]
         [num-vertices (pad GTYPE "-num-vertices")]
         [vertices (pad GTYPE "-vertices")]
         [vertices* (pad GTYPE "-vertices*")]
         [clear! (pad GTYPE "-clear!")]
         
         ;; imports
         [el-constructor (pad "##carp#make-" GTYPE "-el")]
         [edge (pad GTYPE "-edge")]
         [in-edges+ (pad GTYPE "-in-edges" plus)]
         [out-edges+ (pad GTYPE "-out-edges" plus)]
         [remove-edge! (pad GTYPE "-remove-edge!")]
         [transform-vertices! (pad "##carp#" GTYPE "-transform-vertices!")]
         )
    `(begin
       (define-macro ,vertex-set? (lambda () `#f))
       (define-record-type ,vl
         (,make-vl num vec)
         ,vl?
         (num ,vl-num ,set-vl-num!)
         (vec ,vl-vec ,set-vl-vec!))
       (define-record-printer ,vl
         (lambda (x p)
           (fprintf p "Vertex List vl-vector~%")
           (fprintf p "size\t~S" (,vl-num x))))
       (define-record-type ,rec
         (,make-rec out-edge-l ,@(when-bi 'in-edge-l) props)
         ,rec?
         (out-edge-l ,rec-out-edge-l ,set-rec-out-edge-l!)
         ,@(when-bi `(in-edge-l ,rec-in-edge-l ,set-rec-in-edge-l!))
         (props ,rec-props ,set-rec-props!))
       (define-record-printer ,rec
         (lambda (x p)
           (fprintf p "Vertex ~S" x)))
       (define ,constructor
         (lambda (g)
           (,make-vl 0 (make-vector 0))))
       (define-macro ,check-valid
         (lambda (u num)
           `(rgraph-debug
              (when (or (not (integer? ,u)) (< ,u 0) (>= ,u ,num))
                (error "Invalid vl-vector vertex descriptor")))))
       (define ,vertex-index
         (lambda (g v)
           (,check-valid v (,vl-num (,get-vl g)))
           v))
       ,@(let ([index -1])
           (map
             (lambda (prop)
               (let ([getter (pad GTYPE "-" prop)]
                     [setter! (pad "set-" GTYPE "-" prop "!")]
		     [pmap (pad GTYPE "-" prop "-map")])
                 (set! index (add1 index))
                 `(begin
                    (define ,getter
                      (lambda (g v)
                        (,check-valid v (,vl-num (,get-vl g)))
                        (vector-ref (,rec-props (vector-ref (,vl-vec (,get-vl g)) v)) ,index)))
                    (define ,setter!
                      (lambda (g v p)
                        (,check-valid v (,vl-num (,get-vl g)))
                        (vector-set! (,rec-props (vector-ref (,vl-vec (,get-vl g)) v)) ,index p)))
                    (define ,pmap (cons ,getter ,setter!)))))
             vertex-properties))
       (define ,add-vertex!
         (lambda (g . ignored)
           (let* ([vl (,get-vl g)]                  
                  [num (,vl-num vl)]
                  [vec (,vl-vec vl)]
                  [length (vector-length vec)]
                  [rec (,make-rec
                         (,el-constructor g)
                         ,@(when-bi `(,el-constructor g))
                         (make-vector ,NP #f))])
             ;; resize upwards as necessary
             (cond 
               [(< num length)]
               [(zero? length)
                (set! vec (make-vector 1 #f))]
               [else
		(set! vec (vector-resize vec (max 2 (quotient (* 17 length) 10)) #f))])
             (vector-set! vec num rec)
             ;; update
             (,set-vl-vec! vl vec)
             (,set-vl-num! vl (add1 num))
             ;; leave, with vertex_descriptor as integer index
             num)))
       (define ,remove-vertex!
         (lambda (g u)           
           (let* ([vl (,get-vl g)]
                  [num (,vl-num vl)]
                  [num-- (sub1 num)]
                  [vec (,vl-vec vl)]
                  [length (vector-length vec)]
                  [down (quotient (* 10 length) 17)])
             (,check-valid u num)

	     ;; Remove all out-edges of u
	     (,for-each+
	      (lambda (u^v) (,remove-edge! g u^v))
	      (,out-edges+ g u))
             ;; Remove all in-edges of u
	     ,@(when-bi
		`(,for-each+
		  (lambda (v^u) (,remove-edge! g v^u))
		  (,in-edges+ g u)))
	     ,@(unless-bi
		`(do ([v 0 (add1 v)])
		     ((>= v num))
		   (let ([v^u (,edge g v u)])
		     (when v^u 		   
		       (,remove-edge! g v^u)))))
             ;; Remove the vertex
             ;; resize downwards as necessary
             (cond 
               [(< num down)
                (set! vec (vector-resize vec down))
                (,set-vl-vec! vl vec)])
             ;; perform a shift at the removed vertex
             (let loop ([n u])
               (cond 
                 [(> n num--)]
                 [(= n num--)
                  (vector-set! vec n #f)]
                 [else 
                   (vector-set! vec n (vector-ref vec (add1 n)))
                   (loop (add1 n))]))
             ;; update number
             (,set-vl-num! vl (sub1 num))
             ;; Readjust vertex numbers in all edges
             (do ([i 0 (add1 i)])
                 ((>= i num--))               
               (,transform-vertices!
                 (lambda (v) (if (> v u) (sub1 v) v))
                 g i)))))
       (define ,vertex
         (lambda (g n)
           (let* ([vl (,get-vl g)]
                  [num (,vl-num vl)])
             (,check-valid n num)
             n)))
       (define ,vertex-eq?
         (lambda (g u v)
           (,check-valid u (,vl-num (,get-vl g)))
           (,check-valid v (,vl-num (,get-vl g)))
           (= u v)))
       (define ,out-edge-list
         (lambda (g u)
           (let* ([vl (,get-vl g)]
                  [num (,vl-num vl)]
                  [vec (,vl-vec vl)])
             (,check-valid u num)
             (,rec-out-edge-l (vector-ref vec u)))))
       ,@(when-bi
           `(define ,in-edge-list
              (lambda (g u)
                (let* ([vl (,get-vl g)]
                       [num (,vl-num vl)]
                       [vec (,vl-vec vl)])
                  (,check-valid u num)
                  (,rec-in-edge-l (vector-ref vec u))))))                   
       (define ,vertices
         (lambda (g)
           (let* ([vl (,get-vl g)]
                  [num (,vl-num vl)])
             (let iter ([i 0])
               (cond
                 [(= i num) '()]
                 [else (cons i (iter (add1 i)))])))))
       (define ,vertices*
         (lambda (g)
           (let* ([vl (,get-vl g)]
                  [num (,vl-num vl)])
             (let iter ([i 0])
               (stream-delay
                 (cond
                   [(= i num) stream-null]
                   [else (stream-cons i (iter (add1 i)))]))))))       
       (define ,num-vertices
         (lambda (g)
           (let* ([vl (,get-vl g)]
                  [num (,vl-num vl)])
             num)))
       (define ,clear!
         (lambda (g)
           (let ([vl (,get-vl g)])
             (,set-vl-num! vl 0)
             (,set-vl-vec! vl (make-vector 0)))))
              
       )))