; Copyright (c) 2004, Jonah Nathaniel Beckford
; All rights reserved.
;
; Redistribution and use in source and binary forms, with or without
; modification, are permitted provided that the following conditions
; are met:
;
;   Redistributions of source code must retain the above copyright
;   notice, this list of conditions and the following disclaimer.
;
;   Redistributions in binary form must reproduce the above copyright
;   notice, this list of conditions and the following disclaimer in
;   the documentation and/or other materials provided with the
;   distribution.
;
;   Neither the name of the author nor the names of its contributors
;   may be used to endorse or promote products derived from this
;   software without specific prior written permission.
;
; THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
; "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
; LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
; FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
; COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
; INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
; (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
; SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
; HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
; STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
; ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
; OF THE POSSIBILITY OF SUCH DAMAGE.
;
; jonah@usermail.com

(lambda (GTYPE VARGS streamed? bidirectional? edge-properties)
  (define (pad . args)
    (string->symbol
      (apply string-append
        (map (lambda (a)
               (cond
                 [(string? a) a]
                 [(symbol? a) (symbol->string a)]
                 [else "UNKNOWN_PAD_SYMBOL"]))
          args))))
  (define (when-bi . in-args)
    (if bidirectional? in-args '()))
  (let* (
         [NP (length edge-properties)]
         [el (pad GTYPE "-edge-list")]
         [el? (gensym)]
         [make-el (gensym)]
         [el-thash (gensym)]
         [set-el-thash! (gensym)]         
         [rec (pad GTYPE "-edge")]
         [rec? (gensym)]
         [make-rec (gensym)]
         [rec-target (gensym)]
         [set-rec-target! (gensym)]
         [rec-props (gensym)]
         [set-rec-props! (gensym)]
         
         [pre-constructor (pad "##carp#make-" GTYPE "-pre-el")]
         [edge-set? (pad GTYPE "-edge-set?")]
         [constructor (pad "##carp#make-" GTYPE "-el")]
         [add-directed-edge! (pad "##carp#" GTYPE "-add-directed-edge!")]
         [remove-directed-edge! (pad "##carp#" GTYPE "-remove-directed-edge!")]
         [edge (pad GTYPE "-edge")]
         [source (pad GTYPE "-source")]
         [target (pad GTYPE "-target")]
         [edges (pad "##carp#" GTYPE "-edges")]
         [edges* (pad "##carp#" GTYPE "-edges*")]
         [degree (pad "##carp#" GTYPE "-degree")]
         [transform-vertices! (pad "##carp#" GTYPE "-transform-vertices!")]
         
         ;; imports
         [out-edge-list (pad "##carp#" GTYPE "-out-edge-list")]
         [in-edge-list (pad "##carp#" GTYPE "-in-edge-list")]
         [vertex-eq? (pad GTYPE "-vertex-eq?")]
         )
    `(begin
       (define-macro ,edge-set? (lambda () `#t))
       (define-record-type ,el
         (,make-el thash)
         ,el?
         (thash ,el-thash ,set-el-thash!))
       (define-record-printer ,el
         (lambda (x p)
           (fprintf p "Edge List el-hash~%")
           (fprintf p "degree\t~S" (hash-table-count (,el-thash x)))))
       (define-record-type ,rec
         (,make-rec target props)
         ,rec?
         (target ,rec-target ,set-rec-target!)
         (props ,rec-props ,set-rec-props!))
       (define-record-printer ,rec
         (lambda (x p)
           (fprintf p "Edge | target vertex\t~S" (,rec-target x))))
       (define ,pre-constructor
         (lambda (g)
           (make-hash-table (lambda (a b) (,vertex-eq? g a b)))))
       (define ,constructor
         (lambda (g)
           (,make-el (,pre-constructor g))))
       ,@(let ([index -1])
           (map
             (lambda (prop)
               (let ([getter (pad GTYPE "-" prop)]
                     [setter! (pad "set-" GTYPE "-" prop "!")]
		     [pmap (pad GTYPE "-" prop "-map")])
                 (set! index (add1 index))
                 `(begin
                    (define ,getter
                      (lambda (g e)
                        (vector-ref (,rec-props (cdr e)) ,index)))
                    (define ,setter!
                      (lambda (g e p)
                        (vector-set! (,rec-props (cdr e)) ,index p)))
                    (define ,pmap (cons ,getter ,setter!)))))
             edge-properties))       
       (define ,add-directed-edge!
         (lambda (g u u-el v)
           (let* ([u-thash (,el-thash u-el)]
                  [v-rec (hash-table-ref u-thash v)])
             ;; don't overwrite preexisting edge
             (unless v-rec
               (set! v-rec (,make-rec v (make-vector ,NP #f)))
               (hash-table-set! u-thash v v-rec))
             (cons u v-rec))))
       (define ,remove-directed-edge!
         (lambda (g u u-el v)
           (let* ([u-thash (,el-thash u-el)])
             (unless (hash-table-remove! u-thash v)
	       (error "Could not remove directed edge" g u u-el v)))))
       (define ,edge
         (lambda (g u v)
           (let* ([u-el (,out-edge-list g u)]
                  [u-thash (,el-thash u-el)]
                  [v-rec (hash-table-ref u-thash v)])
             (and v-rec (cons u v-rec)))))
       (define ,source
         (lambda (g e)
           (car e)))
       (define ,target
         (lambda (g e)
           (,rec-target (cdr e))))
       (define ,edges
         (lambda (g u u-el out?)
           (hash-table-map
             (lambda (v v-rec) (if out? (cons u v-rec) (,edge g v u)))
             (,el-thash u-el))))
       (define ,edges*
         (lambda (g u u-el out?)
	   (stream-map
	    (lambda (v.v-rec)
	      (if out? (cons u (cdr v.v-rec)) (,edge g (car v.v-rec) u)))
	    (hash-table->stream (,el-thash u-el)))))
       (define ,degree
         (lambda (g u u-el)
           (hash-table-count (,el-thash u-el))))
       (define ,transform-vertices!
         (lambda (proc g u)
	   ;; need to change keys and target in -rec, so make from
	   ;; scratch
	   (define new-out-thash (,pre-constructor g))
	   ,@(when-bi `(define new-in-thash (,pre-constructor g)))
           (define (x! new-thash v v-rec)
             (,set-rec-target! v-rec (proc (,rec-target v-rec)))
	     (hash-table-set! new-thash (proc v) v-rec))
           (hash-table-for-each
	    (lambda (v v-rec) (x! new-out-thash v v-rec))
	    (,el-thash (,out-edge-list g u)))
	   (,set-el-thash! (,out-edge-list g u) new-out-thash)
           ,@(when-bi
	      `(hash-table-for-each
		(lambda (v v-rec) (x! new-in-thash v v-rec))
		(,el-thash (,in-edge-list g u)))
	      `(,set-el-thash! (,in-edge-list g u) new-in-thash))))
       )))