/*
 * Copyright (C) 2003 INRIA
 *
 *	INRIA
 *	Domaine de Voluceau
 *	Rocquencourt - B.P. 105
 *	78153 Le Chesnay Cedex - France
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Author: Loic Dachary <loic@gnu.org>
 * 
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <string.h>

#include <rfid_error.h>

#define INFORMATIVE(s) s " (consider increasing the verbosity level if this message is not self explanatory)"

static char* error_strings[] = {
/* RFID_ERROR_UNKNOWN_ERROR */
/* 00 */ INFORMATIVE("the error cannot be explained"),
/* RFID_ERROR_NOT_SUPPORTED */
/* 01 */ INFORMATIVE("the RFID reader/transponder does not support the command"),
/* RFID_ERROR_READER_OPTION_NOT_SUPPORTED */
/* 02 */ INFORMATIVE("the RFID reader/transponder does not support the command option"),
/* RFID_ERROR_NO_BLOCK */
/* 03 */ INFORMATIVE("the RFID transponder block number is out of range"),
/* RFID_ERROR_BLOCK_READ_ONLY */
/* 04 */ INFORMATIVE("the RFID transponder block is read-only"),
/* RFID_ERROR_BLOCK_ALREADY_LOCKED */
/* 05 */ INFORMATIVE("the RFID transponder block is already locked"),
/* RFID_ERROR_BLOCK_WRITE_FAILURE */
/* 07 */ INFORMATIVE("a write to a RFID transponder block did not complete"),
/* RFID_ERROR_BLOCK_LOCK_FAILURE */
/* 07 */ INFORMATIVE("a lock on a RFID transponder block did not complete"),
/* RFID_ERROR_TRANSPONDER_NOT_FOUND */
/* 08 */ INFORMATIVE("failed to find any RFID transponder matching the request"),
/* RFID_ERROR_INVALID_FLAGS */
/* 09 */ INFORMATIVE("the command/request flags are invalid"),
/* RFID_ERROR_ISO15693_COLLISION */
/* 10 */ INFORMATIVE("ISO-15693: a collision was detected"),
/* RFID_ERROR_CHECKSUM */
/* 11 */ INFORMATIVE("the checksum is invalid"),
/* RFID_ERROR_ISO15693_MASK_TOO_LARGE */
/* 12 */ INFORMATIVE("ISO-15693: the mask length is larger than 64 (bits)"),
/* RFID_ERROR_SHORT_READ */
/* 13 */ INFORMATIVE("the response does not contain enough byte to be analysed"),
/* RFID_ERROR_TRANSPONDER_NULL */
/* 14 */ INFORMATIVE("ISO-15693: the transponder pointer is null"),
/* RFID_ERROR_COMMAND_INVALID */
/* 15 */ INFORMATIVE("the specified command code is invalid"),
/* RFID_ERROR_ISO15693_MISSING_DRIVER */
/* 16 */ INFORMATIVE("ISO-15693: driver must be iso15693/something where something is the name of the low level driver"),
/* RFID_ERROR_TRY_AGAIN */
/* 17 */ INFORMATIVE("non fatal error, try again"),
/* RFID_ERROR_TOO_SMALL */
/* 18 */ INFORMATIVE("the object provided by the caller is not big enough for the needs of the function"),
/* RFID_ERROR_PARSE */
/* 19 */ INFORMATIVE("an ascii string could not be parsed"),
/* RFID_ERROR_M2XXH_P3_INCORRECT */
/* 20 */ INFORMATIVE("M2XXH: the P3 parameter is incorrect"),
/* RFID_ERROR_M2XXH_P1_P2_INCORRECT */
/* 21 */ INFORMATIVE("M2XXH: the P1 or P2 parameters are incorrect"),
/* RFID_ERROR_EEPROM */
/* 22 */ INFORMATIVE("failed to access the EEPROM"),
/* RFID_ERROR_SUCCESS */
/* 23 */ INFORMATIVE("error code that must be interpreted as a success"),
/* RFID_ERROR_SPEED */
/* 24 */ INFORMATIVE("communication speed is invalid"),
/* RFID_ERROR_PROTOCOL_UNKNOWN */
/* 25 */ INFORMATIVE("the protocol is invalid, not supported or not implemented"),
/* RFID_ERROR_TOO_BIG */
/* 26 */ INFORMATIVE("the object provided by the caller cannot be handled by the function because it is too big"),
/* RFID_ERROR_READER_NOT_FOUND */
/* 27 */ INFORMATIVE("could not find a RFID reader"),
/* RFID_ERROR_DRIVER_NOT_FOUND */
/* 28 */ INFORMATIVE("could not find any RFID driver"),
/* RFID_ERROR_READER_BUSY */
/* 29 */ INFORMATIVE("the RFID reader is already used by another program"),
/* RFID_ERROR_DYNLOAD_NO_DRIVER_STACK */
/* 30 */ INFORMATIVE("driver load: driver_stack argument is a null pointer"),
/* RFID_ERROR_DYNLOAD_DLINIT */
/* 31 */ INFORMATIVE("driver load: lt_dlinit failed (use lt_dlerror() for more information)"),
/* RFID_ERROR_DYNLOAD_DLADDSEARCHDIR */
/* 32 */ INFORMATIVE("driver load: lt_dladdsearchdir failed (use lt_dlerror() for more information)"),
/* RFID_ERROR_DYNLOAD_DLOPEN */
/* 33 */ INFORMATIVE("driver load: lt_dlopen failed (use lt_dlerror() for more information)"),
/* RFID_ERROR_DYNLOAD_ENTRY_POINT */
/* 34 */ INFORMATIVE("driver load: the entry point (*_reader_alloc) symbol was not found"),
/* RFID_ERROR_DYNLOAD_ALLOC */
/* 35 */ INFORMATIVE("driver load: the entry point function returned a null pointer")
/* RFID_ERROR_ISO15693_CHECKSUM */
/* 36 */ INFORMATIVE("ISO-15693: the checksum is invalid"),
};

const char* rfid_internal_strerror(int error)
{
  if(error >= RFID_ERROR_LAST) {
    return "error number out of range";
  } else if(error >= 1000000) {
    return error_strings[error - 1000000];
  } else
    return strerror(error);
}
