/*
 * Copyright (C) 2003 INRIA
 *
 *	INRIA
 *	Domaine de Voluceau
 *	Rocquencourt - B.P. 105
 *	78153 Le Chesnay Cedex - France
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Author: Loic Dachary <loic@gnu.org>
 * 
 */

#ifndef _RFID_ERROR_H_
#define _RFID_ERROR_H_

#if defined(__cplusplus)
extern "C" {
#endif


#define RFID_ERROR_UNKNOWN_ERROR		1000000
#define RFID_ERROR_NOT_SUPPORTED		1000001
#define RFID_ERROR_READER_OPTION_NOT_SUPPORTED	1000002
#define RFID_ERROR_NO_BLOCK			1000003
#define RFID_ERROR_BLOCK_READ_ONLY		1000004
#define RFID_ERROR_BLOCK_ALREADY_LOCKED		1000005
#define RFID_ERROR_BLOCK_WRITE_FAILURE		1000006
#define RFID_ERROR_BLOCK_LOCK_FAILURE		1000007
#define RFID_ERROR_TRANSPONDER_NOT_FOUND	1000008
#define RFID_ERROR_INVALID_FLAGS		1000009
#define RFID_ERROR_ISO15693_COLLISION		1000010
#define RFID_ERROR_CHECKSUM			1000011
#define RFID_ERROR_ISO15693_MASK_TOO_LARGE	1000012
#define RFID_ERROR_SHORT_READ			1000013
#define RFID_ERROR_TRANSPONDER_NULL		1000014
#define RFID_ERROR_COMMAND_INVALID		1000015
#define RFID_ERROR_ISO15693_MISSING_DRIVER	1000016
#define RFID_ERROR_TRY_AGAIN			1000017
#define RFID_ERROR_TOO_SMALL			1000018
#define RFID_ERROR_PARSE			1000019
#define RFID_ERROR_M2XXH_P3_INCORRECT		1000020
#define RFID_ERROR_M2XXH_P1_P2_INCORRECT	1000021
#define RFID_ERROR_EEPROM			1000022
#define RFID_ERROR_SUCCESS			1000023
#define RFID_ERROR_SPEED			1000024
#define RFID_ERROR_PROTOCOL_UNKNOWN		1000025
#define RFID_ERROR_TOO_BIG			1000026
#define RFID_ERROR_READER_NOT_FOUND		1000027
#define RFID_ERROR_DRIVER_NOT_FOUND		1000028
#define RFID_ERROR_READER_BUSY			1000029
#define RFID_ERROR_DYNLOAD_NO_DRIVER_STACK	1000030
#define RFID_ERROR_DYNLOAD_DLINIT		1000031
#define RFID_ERROR_DYNLOAD_DLADDSEARCHDIR	1000032
#define RFID_ERROR_DYNLOAD_DLOPEN		1000033
#define RFID_ERROR_DYNLOAD_ENTRY_POINT		1000034
#define RFID_ERROR_DYNLOAD_ALLOC		1000035
#define RFID_ERROR_ISO15693_CHECKSUM		1000036

#define RFID_ERROR_LAST				1000037

#define RFID_ERROR_STACK(condition) if(condition) fprintf(stderr, "returned -1 at %s:%d\n", __FILE__, __LINE__)

const char* rfid_internal_strerror(int error);

#if defined(__cplusplus)
}
#endif

#endif /* _RFID_ERROR_H_ */
