/*  Copyright (C) 2011 Ben Asselstine

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
  02110-1301, USA.
*/
#ifndef REDDIT_STORY_H
#define REDDIT_STORY_H 1

#include <argp.h>
#include "reddit_priv.h"
#include <glib.h>
struct reddit_story_t
{
  int story_number;
  char *id;
  char *link;
  char *title;
  int score;
  char *provider;
  char *submitter;
  char *subreddit;
  char *ago;
  int num_comments;
  char *votehash;
};

struct reddit_state_t;
struct reddit_story_t reddit_load_story_from_chunk (struct reddit_state_t *state, gchar *chunk, int *err, int *skip);
void reddit_show_story (struct reddit_state_t *state, struct reddit_story_t *story);
int argp_parse_story_id (struct argp_state *, char *, struct reddit_state_t *);

char * argp_parse_story_help_filter (int key, const char *text, struct reddit_state_t *s);

void reddit_free_story (struct reddit_story_t *story, int free_ptr_too);
#endif
