/*  Copyright (C) 2011 Ben Asselstine

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
  02110-1301, USA.
*/
#ifndef REDDIT_WHATS_H
#define REDDIT_WHATS_H 1

#include <config.h>
#include <stdio.h>
#include <argp.h>
#include "reddit_priv.h"

enum reddit_whats_enum_t
{
  REDDIT_WHATS_HOT = 0,
  REDDIT_WHATS_NEW,
  REDDIT_WHATS_CONTROVERSIAL,
  REDDIT_WHATS_TOP,
  REDDIT_WHATS_SAVED,
  REDDIT_WHATS_A_BATTLE
};
struct reddit_whats_options_t
{
  int whats;
  struct reddit_state_t *state;
  int parsing_errors;
};

int reddit_whats_parse_argp (struct reddit_state_t *, int argc, char **argv, struct argp *);
int reddit_whats (struct reddit_state_t *, struct reddit_whats_options_t *);
extern struct argp reddit_whats_argp;
char* reddit_whats_to_string (int w);
#endif
