/*  Copyright (C) 2011 Ben Asselstine

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
  02110-1301, USA.
*/
#include <config.h>
#include <stdio.h>
#include <stdlib.h>
#include "xvasprintf.h"
#include "submit.h"
#include "story.h"
#include "gettext-more.h"

static struct argp_option options[] = 
{
    {0}
};

static error_t 
parse_opt (int key, char *arg, struct argp_state *state)
{
  struct reddit_submit_options_t *opt = NULL;
  if (state)
    opt = (struct reddit_submit_options_t*) state->input;
  switch (key)
    {
    case ARGP_KEY_ARG:
        {
          if (opt->url == NULL && !opt->parsing_errors)
            opt->url = arg;
          else if (!opt->parsing_errors)
            {
              argp_failure (state, 0, 0, 
                            _("That doesn't look like a link."));
              opt->parsing_errors = 1;
            }
        }
      break;
    case ARGP_KEY_NO_ARGS:
      if (state->next <= 1)
        {
          argp_failure (state, 0, 0, 
                        _("You must specify a link to submit."));
          argp_state_help (state, state->err_stream, ARGP_HELP_SEE);
          opt->parsing_errors = 1;
        }
      break;
    case ARGP_KEY_INIT:
      opt->url = NULL;
      opt->parsing_errors = 0;
      break;
    default:
      return ARGP_ERR_UNKNOWN;
    }
  return 0;
}

struct argp reddit_submit_argp = { options, parse_opt, "LINK",N_("Submit a link.") };

int 
reddit_submit_parse_argp (struct reddit_state_t *state, int argc, char **argv, struct argp *argp)
{
  int err = 0;
  struct reddit_submit_options_t submit_options;
  submit_options.state = state;

  err = argp_parse (argp, argc, argv, ARGP_NO_EXIT,  0, &submit_options);
  if (!err && submit_options.url != NULL && !submit_options.parsing_errors)
    return reddit_submit (state, &submit_options);
  else
    return 0;
}

int 
reddit_submit (struct reddit_state_t *state, struct reddit_submit_options_t *options)
{
  int err = 0;
  if (state->logged_in == 0)
    {
      fprintf (state->out, _("You need to login to submit a story."
                             "  Login using the `login' command.\n"));
      return 0;
    }
  fprintf (state->out, _("Sorry, we can't submit a link because "
                         "we can't show you the captcha.\n"));
  return err;
}
