/*  Copyright (C) 2011 Ben Asselstine

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU Library General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
  02110-1301, USA.
*/
#ifndef REDDIT_PRIV_H
#define REDDIT_PRIV_H 1

#include <curl/curl.h>
#include <glib.h>
#include "story.h"

struct reddit_state_t
{
  int logged_in;
  char *username;
  CURL *curl;
  FILE *out;
  struct reddit_story_t *stories;
  int num_stories;
  char *command; //current command we're working on.
  int story_number; //current story number we're looking at.
  int whats; //what tab we're on.
  char *subreddit; //what subreddit we're in.
  gchar *browser_binary; //where the browser program is living 
  gchar *links_binary; //where the links program is living (for html2text)
  char *modhash; //the last modhash we saw.
  char *page; //what page we're on.
  int columns; //how many columns are on our screen.
};

int reddit_load_and_show_stories (struct reddit_state_t *state, char *page, int *response);
void reddit_reshow_stories (struct reddit_state_t *state);
char * reddit_construct_url (struct reddit_state_t *state, char *page);
int argp_help_check (int argc, char **argv);
int reddit_update_modhash (struct reddit_state_t *state);
void reddit_line (struct reddit_state_t *state);

#define REDDIT_SITE             "www.reddit.com"
#define REDDIT_COOKIEJAR        "/tmp/" PACKAGE ".crumbs"
#endif
