#!/bin/sh
#simple script to generate makefile compatible list of prerequisites

#RollCageX (sci-fi racer inspired by the original RollCage games)
#Copyright (C) 2009-2010  Mats Wahlberg ("Slinger" on gorcx.net forum)
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#
#GNU General Public License for more details.
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.



#remove old
rm prereqs.lst

#generate new
for FILE in *cpp */*cpp
do
	DIR=$(dirname $FILE)
	NAME=$(basename $FILE ".cpp")

	#in case file is in root of src dir, don't print "/./"
	if [ $DIR == "." ]
	then
		echo -n "build/$NAME.o:" >> prereqs.lst
	else
		echo -n "build/$DIR/$NAME.o:" >> prereqs.lst
	fi

	for HEADER in $(grep '^#include.*"' $FILE |cut -d'"' -f2)
	do
		echo -n " $DIR/$HEADER" >> prereqs.lst
	done
	echo "" >> prereqs.lst
done
