#!/usr/bin/perl

#   Rebot 0.8 (beta): Bot para aventuras de texto por red
#   http://aventuras.presi.org/rebot
#   (C) 2005 Enrique D. Bosch 'presi'
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#
#   http://www.gnu.org/licenses/gpl.html

use FileHandle;
use rebot_conf;

BEGIN
{
$d_tmp=$rebot_conf::directorio_temporal;           # Inicializando parmetros
$d_interprete=$rebot_conf::directorio_interpretes; # de configuracin
$d_aventura=$rebot_conf::directorio_aventuras;
$d_aplic=$rebot_conf::directorio_aplicaciones;
$log=$rebot_conf::modulo_log;
eval "require $log";                # Incluyendo mdulo de log
$con=$rebot_conf::modulo_protocolo;
eval "require $con";                # Incluyendo mdulo de protocolo
}

undef $/;
$modo_comando=1;
$linea1_texto_inicial='Rebot 0.8 (beta): Bot para aventuras de texto por red. http://aventuras.presi.org/rebot';
$texto_inicial="$linea1_texto_inicial\nTeclea 'ayuda' para mostrar comandos disponibles";

sub cargar
{
  $aventura=$_[0];
  $interprete=$_[1];
  $donde=$_[2];

  if ($interprete eq '-aplic-')  # Es una aplicacin genrica
  {
    if (!esta_en_directorio($d_aplic,$aventura,'Aplicacin','a')) { return 0; }
  }
  else  # Es un juego (aventura e intrprete)
  {
    if (!esta_en_directorio($d_aventura,$aventura,'Aventura','a')) { return 0; }
    if ($interprete eq '')  
    {                                              # Asignando intrprete a la aventura
      foreach my $aux (@rebot_conf::extensiones_interpretes)
      {
        my ($ext,$int,$opc)=@$aux;
        if ($aventura=~/\.$ext/i) { $interprete=$int; $opciones=$opc; }
      }
    }
    else    # Comprobando si el intrprete est en el directorio
    {
      if (!esta_en_directorio($d_interprete,$interprete,'Intrprete','o')) { return 0; }
    }
  }
  # Lanzando intrprete

  open STDERR, "> $d_tmp/err_$$" or die 'Error creando fichero temporal de error';
  my $linea;
  my $mens;
  my $mensl;
  my $mensi;
  my $mensf;
  if ($interprete eq '-aplic-')
  {
    $linea="$d_aplic/$aventura > $d_tmp/tmp_$$";
    $mens="Aplicacin '$aventura' cargada";
    $mensl='Aplicacin cargada';
    $mensi='la aplicacin';
    $mensf='Aplicacin finalizada';
  }
  else
  {
    $linea="$d_interprete/$interprete $opciones $d_aventura/$aventura > $d_tmp/tmp_$$";
    $mens="Aventura '$aventura' cargada usando el intrprete '$interprete'";
    $mensl='Aventura cargada';
    $mensi='el intrprete';
    $mensf='Intrprete finalizado';
  }
  $log->eslog($linea);
  open ESINT," | $linea" or die "Error lanzando $mensi";
  ESINT->autoflush(1);
  sleep 2;
  open ERR,"$d_tmp/err_$$" or die 'Error abriendo fichero temporal de error';
  my $er=<ERR>;
  close(ERR);
  if ($er ne '')
  {
    $log->eslog($er);
    $con->enviar_mensaje("Error lanzando $mensi");
    modo('',$donde);
    $log->eslog($mense);
  }
  else
  {
    open LEINT, "$d_tmp/tmp_$$" or die 'Error abriendo fichero temporal';
    LEINT->autoflush(1);
    $con->enviar_mensaje($mens,$donde);
    $log->eslog($mensl);
    modo('juego',$donde);
    my $le=<LEINT>;
    if ($le eq '')            # se comprueba si el intrprete se aborta
    {
      $log->eslog($mensf);
      modo('comando');
    }
    else { $con->enviar_mensaje($le,$donde); }      # se vuelca la respuesta
  }
}

sub leer_dir   # Lee un directorio y lo coloca en un array
{
  my $dir=$_[0];

  opendir DIR, $dir or die 'Error leyendo directorio';
  my @lista=readdir(DIR);
  closedir(DIR);
  if ($lista[0] eq '.')
  {
    shift(@lista);
    if ($lista[0] eq '..') { shift(@lista); }
  }
  return @lista;
}

sub listar_dir  # Lee y lista un directorio
{
  my $dir=$_[0];
  my $donde=$_[1];

  my @lista=leer_dir($dir);
  $con->enviar_mensaje(join("\n",@lista),$donde);
}

sub esta_en_directorio
{
  my $dir=$_[0];
  my $fich=$_[1];
  my $mens=$_[2];
  my $sufix=$_[3];

  my @lista=leer_dir($dir);
  my $enc=0;
  foreach my $item (@lista)   # Comprobando si el fichero est en el directorio
  {
    if ($item eq $fich) { $enc=1; }
  }
  if ($enc==0)
  {
    $con->enviar_mensaje("$mens no encontrad$sufix");
    modo('',$donde);
    $log->eslog("$mens '$fich' no encontrad$sufix");
    return 0;
  }
  return 1;
}

sub ayuda
{
  my $donde=$_[0];
  my $texto_ayuda=
'Existen dos modos de funcionamiento:
Modo comando: el bot esperar comandos para realizar
  diferentes acciones.
Modo juego o aplicacin: es cuando se ha cargado un juego
  o aplicacin, toda la entrada ir ahi. Para volver al
  modo comando hay que salir del juego o aplicacin.
Comandos del modo comando:
  ayuda/?
     Muestra este texto.
  cargar/jugar <aventura> [intrprete]
     Inicia una aventura con un interprete y pasa
     a modo juego.
  aventuras/juegos
     Muestra la lista de aventuras disponibles.
  interpretes
     Muestra la lista de intrpretes disponibles.
  ejecutar <aplicacin>
     Ejecuta la aplicacin.
  aplicaciones
     Muestra la lista de aplicaciones disponibles.'."\n".$con->texto_ayuda();
  $con->enviar_mensaje($texto_ayuda,$donde);
}

sub tratar_texto    # Maneja el texto de entrada
{
   my $texto=$_[0];
   my $donde=$_[1];

   if ($modo_comando)  # Parser de comandos
   {
      my @elem=split(' ',$texto);
      lc($elem[0]);
      if ( ($elem[0] eq 'cargar') || ($elem[0] eq 'jugar') )
      {
         cargar($elem[1],$elem[2],$donde);
      }
      elsif ( ($elem[0] eq 'aventuras') || ($elem[0] eq 'juegos') )
      {
         listar_dir($d_aventura,$donde);
         modo('',$donde);
      }
      elsif ( $elem[0] eq 'interpretes' )
      {
         listar_dir($d_interprete,$donde);
         modo('',$donde);
      }
      elsif ( $elem[0] eq 'ejecutar')
      {
         cargar($elem[1],'-aplic-',$donde);
      }
      elsif ( $elem [0] eq 'aplicaciones')
      {
         listar_dir($d_aplic,$donde);
         modo('',$donde);
      }
      elsif ( ($elem[0] eq 'ayuda') || ( $elem[0] eq '?') )
      {
         ayuda($donde);
         modo('',$donde);
      }
      elsif ( !($con->comando($donde,@elem)) )
          { $con->enviar_mensaje('Comando no reconocido',$donde); modo('',$donde); }
   }
   else
   {
      print ESINT $texto,"\n";  # se le pasa al intrprete
      sleep 1;
      $le=<LEINT>;              # se obtiene respuesta vaca del intrprete
      $le=<LEINT>;              # se obtiene respuesta del intrprete
      if ($le eq '')            # se comprueba si ha acabado el interprete
      {
        $log->eslog('Intrprete finalizado');
        modo('comando');
      }
      else { $con->enviar_mensaje($le,$donde); }      # se vuelca la respuesta
    }

}


sub modo   # Cambio/consulta de modo (comando o juego)
{
  my $cad_modo=$_[0];
  my $donde=$_[1];

  if ($cad_modo eq '')
  {
    print_modo($modo_comando,$donde,0);
  }
  elsif ($cad_modo eq 'comando')
  {
    $modo_comando=1;
    print_modo(1,$donde,1);
  }
  elsif ($cad_modo eq 'juego')
  {
    $modo_comando=0;
    print_modo(0,$donde,1);
  }
  else { $log->eslog('Modo errneo, no cambiado.'); }
}

sub print_modo
{
  my $modo=$_[0];
  my $donde=$_[1];
  my $loggear=$_[2];

  if ($modo)
  {
    if ($loggear) { $log->eslog('Modo comando'); }
    $con->enviar_mensaje('--Modo comando--',$donde);
  }
  else
  {
    if ($loggear) { $log->eslog('Modo juego o aplicacin'); }
    $con->enviar_mensaje('--Modo juego o aplicacin--',$donde);
  }
}

my @txt_ini=split("\n",$texto_inicial);
$log->eslog($txt_ini[0]);
$log->eslog("Usando mdulo de protocolo '$con'");
$log->eslog($con.': '.$con->texto_inicial());
$con->configurar();
$con->conectar();

END
{
  unlink("$d_tmp/tmp_$$");
  unlink("$d_tmp/err_$$");
  $log->eslog('Finalizando');
}
