/*  Copyright (C) 2005-2010, Axis Communications AB, LUND, SWEDEN
 *
 *  This file is part of RAPP.
 *
 *  RAPP is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published
 *  by the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *  You can use the comments under either the terms of the GNU Lesser General
 *  Public License version 3 as published by the Free Software Foundation,
 *  either version 3 of the License or (at your option) any later version, or
 *  the GNU Free Documentation License version 1.3 or any later version
 *  published by the Free Software Foundation; with no Invariant Sections, no
 *  Front-Cover Texts, and no Back-Cover Texts.
 *  A copy of the license is included in the documentation section entitled
 *  "GNU Free Documentation License".
 *
 *  RAPP is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License and a copy of the GNU Free Documentation License along
 *  with RAPP. If not, see <http://www.gnu.org/licenses/>.
 */
/**
 *  @file   rc_morph_bin.c
 *  @author Auto-generated by autogen_morph_bin.py on Fri Feb  6 07:21:19 2009
 *  @brief  RAPP Compute layer binary morphology primitives.
 */

#include <stddef.h>
#include "rc_platform.h"
#include "rc_impl_cfg.h"
#include "rc_util.h"
#include "rc_word.h"
#include "rc_morph_bin.h"

/*
 * --------------------------------------------------------------
 *  Template macros
 * --------------------------------------------------------------
 */

/**
 *  Align words left.
 */
#define RC_MORPH_LEFT(ptr, off)                       \
    RC_WORD_ALIGN(RC_WORD_LOAD((ptr) - RC_WORD_SIZE), \
                  RC_WORD_LOAD(ptr),                  \
                  8*RC_WORD_SIZE - (off))

/**
 *  Align words right.
 */
#define RC_MORPH_RIGHT(ptr, off)                      \
    RC_WORD_ALIGN(RC_WORD_LOAD(ptr),                  \
                  RC_WORD_LOAD((ptr) + RC_WORD_SIZE), \
                  off)

/**
 *  Morphology iteration step.
 */
#define RC_MORPH_ITER(dptr, sptr, sew) \
do {                                   \
    rc_word_t word_ = sew(sptr);       \
    RC_WORD_STORE(dptr, word_);        \
    (sptr) += RC_WORD_SIZE;            \
    (dptr) += RC_WORD_SIZE;            \
} while (0)


/**
 *  Morphology template.
 */
#define RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, \
                          width, height, sew, unroll) \
do {                                                  \
    int tot_ = RC_DIV_CEIL(width, 8*RC_WORD_SIZE);    \
    int len_ = tot_ / (unroll);                       \
    int rem_ = tot_ % (unroll);                       \
    int x_, y_;                                       \
    for (y_ = 0; y_ < (height); y_++) {               \
        uint8_t       *dp_ = &(dst)[y_*(dst_dim)];    \
        const uint8_t *sp_ = &(src)[y_*(src_dim)];    \
        for (x_ = 0; x_ < len_; x_++) {               \
            RC_MORPH_ITER(dp_, sp_, sew);             \
            if ((unroll) >= 2) {                      \
                RC_MORPH_ITER(dp_, sp_, sew);         \
            }                                         \
            if ((unroll) == 4) {                      \
                RC_MORPH_ITER(dp_, sp_, sew);         \
                RC_MORPH_ITER(dp_, sp_, sew);         \
            }                                         \
        }                                             \
        for (x_ = 0; x_ < rem_; x_++) {               \
            RC_MORPH_ITER(dp_, sp_, sew);             \
        }                                             \
    }                                                 \
} while (0)

/*
 * --------------------------------------------------------------
 *  SE word macros
 * --------------------------------------------------------------
 */

#define RC_MORPH_ERODE_LINE_1X2(ptr) \
    (RC_MORPH_LEFT (&(ptr)[ 0    ],  1) & \
     RC_WORD_LOAD  (&(ptr)[ 0    ]    ))

#define RC_MORPH_DILATE_LINE_1X2(ptr) \
    (RC_MORPH_RIGHT(&(ptr)[ 0    ],  1) | \
     RC_WORD_LOAD  (&(ptr)[ 0    ]    ))

#define RC_MORPH_ERODE_LINE_1X3(ptr) \
    (RC_MORPH_LEFT (&(ptr)[ 0    ],  1) & \
     RC_WORD_LOAD  (&(ptr)[ 0    ]    ) & \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  1))

#define RC_MORPH_DILATE_LINE_1X3(ptr) \
    (RC_MORPH_RIGHT(&(ptr)[ 0    ],  1) | \
     RC_WORD_LOAD  (&(ptr)[ 0    ]    ) | \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  1))

#define RC_MORPH_ERODE_LINE_1X3_P(ptr) \
    (RC_MORPH_LEFT (&(ptr)[ 0    ],  1) & \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  1))

#define RC_MORPH_DILATE_LINE_1X3_P(ptr) \
    (RC_MORPH_RIGHT(&(ptr)[ 0    ],  1) | \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  1))

#define RC_MORPH_ERODE_LINE_1X5_P(ptr) \
    (RC_MORPH_LEFT (&(ptr)[ 0    ],  2) & \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  2))

#define RC_MORPH_DILATE_LINE_1X5_P(ptr) \
    (RC_MORPH_RIGHT(&(ptr)[ 0    ],  2) | \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  2))

#define RC_MORPH_ERODE_LINE_1X7_P(ptr) \
    (RC_MORPH_LEFT (&(ptr)[ 0    ],  3) & \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  3))

#define RC_MORPH_DILATE_LINE_1X7_P(ptr) \
    (RC_MORPH_RIGHT(&(ptr)[ 0    ],  3) | \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  3))

#define RC_MORPH_ERODE_LINE_1X9_P(ptr) \
    (RC_MORPH_LEFT (&(ptr)[ 0    ],  4) & \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  4))

#define RC_MORPH_DILATE_LINE_1X9_P(ptr) \
    (RC_MORPH_RIGHT(&(ptr)[ 0    ],  4) | \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  4))

#define RC_MORPH_ERODE_LINE_1X13_P(ptr) \
    (RC_MORPH_LEFT (&(ptr)[ 0    ],  6) & \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  6))

#define RC_MORPH_DILATE_LINE_1X13_P(ptr) \
    (RC_MORPH_RIGHT(&(ptr)[ 0    ],  6) | \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  6))

#define RC_MORPH_ERODE_LINE_1X15_P(ptr) \
    (RC_MORPH_LEFT (&(ptr)[ 0    ],  7) & \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  7))

#define RC_MORPH_DILATE_LINE_1X15_P(ptr) \
    (RC_MORPH_RIGHT(&(ptr)[ 0    ],  7) | \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  7))

#define RC_MORPH_ERODE_LINE_1X17_P(ptr) \
    (RC_MORPH_LEFT (&(ptr)[ 0    ],  8) & \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  8))

#define RC_MORPH_DILATE_LINE_1X17_P(ptr) \
    (RC_MORPH_RIGHT(&(ptr)[ 0    ],  8) | \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  8))

#define RC_MORPH_ERODE_LINE_1X25_P(ptr) \
    (RC_MORPH_LEFT (&(ptr)[ 0    ], 12) & \
     RC_MORPH_RIGHT(&(ptr)[ 0    ], 12))

#define RC_MORPH_DILATE_LINE_1X25_P(ptr) \
    (RC_MORPH_RIGHT(&(ptr)[ 0    ], 12) | \
     RC_MORPH_LEFT (&(ptr)[ 0    ], 12))

#define RC_MORPH_ERODE_LINE_1X29_P(ptr) \
    (RC_MORPH_LEFT (&(ptr)[ 0    ], 14) & \
     RC_MORPH_RIGHT(&(ptr)[ 0    ], 14))

#define RC_MORPH_DILATE_LINE_1X29_P(ptr) \
    (RC_MORPH_RIGHT(&(ptr)[ 0    ], 14) | \
     RC_MORPH_LEFT (&(ptr)[ 0    ], 14))

#define RC_MORPH_ERODE_LINE_1X31_P(ptr) \
    (RC_MORPH_LEFT (&(ptr)[ 0    ], 15) & \
     RC_MORPH_RIGHT(&(ptr)[ 0    ], 15))

#define RC_MORPH_DILATE_LINE_1X31_P(ptr) \
    (RC_MORPH_RIGHT(&(ptr)[ 0    ], 15) | \
     RC_MORPH_LEFT (&(ptr)[ 0    ], 15))

#define RC_MORPH_ERODE_LINE_2X1(ptr) \
    (RC_WORD_LOAD  (&(ptr)[-dim1 ]    ) & \
     RC_WORD_LOAD  (&(ptr)[ 0    ]    ))

#define RC_MORPH_DILATE_LINE_2X1(ptr) \
    (RC_WORD_LOAD  (&(ptr)[ dim1 ]    ) | \
     RC_WORD_LOAD  (&(ptr)[ 0    ]    ))

#define RC_MORPH_ERODE_LINE_3X1(ptr) \
    (RC_WORD_LOAD  (&(ptr)[-dim1 ]    ) & \
     RC_WORD_LOAD  (&(ptr)[ 0    ]    ) & \
     RC_WORD_LOAD  (&(ptr)[ dim1 ]    ))

#define RC_MORPH_DILATE_LINE_3X1(ptr) \
    (RC_WORD_LOAD  (&(ptr)[ dim1 ]    ) | \
     RC_WORD_LOAD  (&(ptr)[ 0    ]    ) | \
     RC_WORD_LOAD  (&(ptr)[-dim1 ]    ))

#define RC_MORPH_ERODE_LINE_3X1_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[-dim1 ]    ) & \
     RC_WORD_LOAD  (&(ptr)[ dim1 ]    ))

#define RC_MORPH_DILATE_LINE_3X1_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[ dim1 ]    ) | \
     RC_WORD_LOAD  (&(ptr)[-dim1 ]    ))

#define RC_MORPH_ERODE_LINE_5X1_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[-dim2 ]    ) & \
     RC_WORD_LOAD  (&(ptr)[ dim2 ]    ))

#define RC_MORPH_DILATE_LINE_5X1_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[ dim2 ]    ) | \
     RC_WORD_LOAD  (&(ptr)[-dim2 ]    ))

#define RC_MORPH_ERODE_LINE_7X1_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[-dim3 ]    ) & \
     RC_WORD_LOAD  (&(ptr)[ dim3 ]    ))

#define RC_MORPH_DILATE_LINE_7X1_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[ dim3 ]    ) | \
     RC_WORD_LOAD  (&(ptr)[-dim3 ]    ))

#define RC_MORPH_ERODE_LINE_9X1_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[-dim4 ]    ) & \
     RC_WORD_LOAD  (&(ptr)[ dim4 ]    ))

#define RC_MORPH_DILATE_LINE_9X1_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[ dim4 ]    ) | \
     RC_WORD_LOAD  (&(ptr)[-dim4 ]    ))

#define RC_MORPH_ERODE_LINE_13X1_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[-dim6 ]    ) & \
     RC_WORD_LOAD  (&(ptr)[ dim6 ]    ))

#define RC_MORPH_DILATE_LINE_13X1_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[ dim6 ]    ) | \
     RC_WORD_LOAD  (&(ptr)[-dim6 ]    ))

#define RC_MORPH_ERODE_LINE_15X1_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[-dim7 ]    ) & \
     RC_WORD_LOAD  (&(ptr)[ dim7 ]    ))

#define RC_MORPH_DILATE_LINE_15X1_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[ dim7 ]    ) | \
     RC_WORD_LOAD  (&(ptr)[-dim7 ]    ))

#define RC_MORPH_ERODE_LINE_17X1_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[-dim8 ]    ) & \
     RC_WORD_LOAD  (&(ptr)[ dim8 ]    ))

#define RC_MORPH_DILATE_LINE_17X1_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[ dim8 ]    ) | \
     RC_WORD_LOAD  (&(ptr)[-dim8 ]    ))

#define RC_MORPH_ERODE_LINE_25X1_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[-dim12]    ) & \
     RC_WORD_LOAD  (&(ptr)[ dim12]    ))

#define RC_MORPH_DILATE_LINE_25X1_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[ dim12]    ) | \
     RC_WORD_LOAD  (&(ptr)[-dim12]    ))

#define RC_MORPH_ERODE_LINE_29X1_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[-dim14]    ) & \
     RC_WORD_LOAD  (&(ptr)[ dim14]    ))

#define RC_MORPH_DILATE_LINE_29X1_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[ dim14]    ) | \
     RC_WORD_LOAD  (&(ptr)[-dim14]    ))

#define RC_MORPH_ERODE_LINE_31X1_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[-dim15]    ) & \
     RC_WORD_LOAD  (&(ptr)[ dim15]    ))

#define RC_MORPH_DILATE_LINE_31X1_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[ dim15]    ) | \
     RC_WORD_LOAD  (&(ptr)[-dim15]    ))

#define RC_MORPH_ERODE_SQUARE_2X2(ptr) \
    (RC_MORPH_LEFT (&(ptr)[-dim1 ],  1) & \
     RC_WORD_LOAD  (&(ptr)[-dim1 ]    ) & \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  1) & \
     RC_WORD_LOAD  (&(ptr)[ 0    ]    ))

#define RC_MORPH_DILATE_SQUARE_2X2(ptr) \
    (RC_MORPH_RIGHT(&(ptr)[ dim1 ],  1) | \
     RC_WORD_LOAD  (&(ptr)[ dim1 ]    ) | \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  1) | \
     RC_WORD_LOAD  (&(ptr)[ 0    ]    ))

#define RC_MORPH_ERODE_SQUARE_3X3(ptr) \
    (RC_MORPH_LEFT (&(ptr)[-dim1 ],  1) & \
     RC_WORD_LOAD  (&(ptr)[-dim1 ]    ) & \
     RC_MORPH_RIGHT(&(ptr)[-dim1 ],  1) & \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  1) & \
     RC_WORD_LOAD  (&(ptr)[ 0    ]    ) & \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  1) & \
     RC_MORPH_LEFT (&(ptr)[ dim1 ],  1) & \
     RC_WORD_LOAD  (&(ptr)[ dim1 ]    ) & \
     RC_MORPH_RIGHT(&(ptr)[ dim1 ],  1))

#define RC_MORPH_DILATE_SQUARE_3X3(ptr) \
    (RC_MORPH_RIGHT(&(ptr)[ dim1 ],  1) | \
     RC_WORD_LOAD  (&(ptr)[ dim1 ]    ) | \
     RC_MORPH_LEFT (&(ptr)[ dim1 ],  1) | \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  1) | \
     RC_WORD_LOAD  (&(ptr)[ 0    ]    ) | \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  1) | \
     RC_MORPH_RIGHT(&(ptr)[-dim1 ],  1) | \
     RC_WORD_LOAD  (&(ptr)[-dim1 ]    ) | \
     RC_MORPH_LEFT (&(ptr)[-dim1 ],  1))

#define RC_MORPH_ERODE_SQUARE_3X3_P(ptr) \
    (RC_MORPH_LEFT (&(ptr)[-dim1 ],  1) & \
     RC_MORPH_RIGHT(&(ptr)[-dim1 ],  1) & \
     RC_MORPH_LEFT (&(ptr)[ dim1 ],  1) & \
     RC_MORPH_RIGHT(&(ptr)[ dim1 ],  1))

#define RC_MORPH_DILATE_SQUARE_3X3_P(ptr) \
    (RC_MORPH_RIGHT(&(ptr)[ dim1 ],  1) | \
     RC_MORPH_LEFT (&(ptr)[ dim1 ],  1) | \
     RC_MORPH_RIGHT(&(ptr)[-dim1 ],  1) | \
     RC_MORPH_LEFT (&(ptr)[-dim1 ],  1))

#define RC_MORPH_ERODE_DIAMOND_3X3(ptr) \
    (RC_WORD_LOAD  (&(ptr)[-dim1 ]    ) & \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  1) & \
     RC_WORD_LOAD  (&(ptr)[ 0    ]    ) & \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  1) & \
     RC_WORD_LOAD  (&(ptr)[ dim1 ]    ))

#define RC_MORPH_DILATE_DIAMOND_3X3(ptr) \
    (RC_WORD_LOAD  (&(ptr)[ dim1 ]    ) | \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  1) | \
     RC_WORD_LOAD  (&(ptr)[ 0    ]    ) | \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  1) | \
     RC_WORD_LOAD  (&(ptr)[-dim1 ]    ))

#define RC_MORPH_ERODE_DIAMOND_3X3_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[-dim1 ]    ) & \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  1) & \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  1) & \
     RC_WORD_LOAD  (&(ptr)[ dim1 ]    ))

#define RC_MORPH_DILATE_DIAMOND_3X3_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[ dim1 ]    ) | \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  1) | \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  1) | \
     RC_WORD_LOAD  (&(ptr)[-dim1 ]    ))

#define RC_MORPH_ERODE_DIAMOND_5X5_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[-dim2 ]    ) & \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  2) & \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  2) & \
     RC_WORD_LOAD  (&(ptr)[ dim2 ]    ))

#define RC_MORPH_DILATE_DIAMOND_5X5_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[ dim2 ]    ) | \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  2) | \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  2) | \
     RC_WORD_LOAD  (&(ptr)[-dim2 ]    ))

#define RC_MORPH_ERODE_DIAMOND_7X7_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[-dim3 ]    ) & \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  3) & \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  3) & \
     RC_WORD_LOAD  (&(ptr)[ dim3 ]    ))

#define RC_MORPH_DILATE_DIAMOND_7X7_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[ dim3 ]    ) | \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  3) | \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  3) | \
     RC_WORD_LOAD  (&(ptr)[-dim3 ]    ))

#define RC_MORPH_ERODE_DIAMOND_9X9_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[-dim4 ]    ) & \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  4) & \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  4) & \
     RC_WORD_LOAD  (&(ptr)[ dim4 ]    ))

#define RC_MORPH_DILATE_DIAMOND_9X9_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[ dim4 ]    ) | \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  4) | \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  4) | \
     RC_WORD_LOAD  (&(ptr)[-dim4 ]    ))

#define RC_MORPH_ERODE_DIAMOND_13X13_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[-dim6 ]    ) & \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  6) & \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  6) & \
     RC_WORD_LOAD  (&(ptr)[ dim6 ]    ))

#define RC_MORPH_DILATE_DIAMOND_13X13_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[ dim6 ]    ) | \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  6) | \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  6) | \
     RC_WORD_LOAD  (&(ptr)[-dim6 ]    ))

#define RC_MORPH_ERODE_DIAMOND_15X15_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[-dim7 ]    ) & \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  7) & \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  7) & \
     RC_WORD_LOAD  (&(ptr)[ dim7 ]    ))

#define RC_MORPH_DILATE_DIAMOND_15X15_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[ dim7 ]    ) | \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  7) | \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  7) | \
     RC_WORD_LOAD  (&(ptr)[-dim7 ]    ))

#define RC_MORPH_ERODE_DIAMOND_17X17_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[-dim8 ]    ) & \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  8) & \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  8) & \
     RC_WORD_LOAD  (&(ptr)[ dim8 ]    ))

#define RC_MORPH_DILATE_DIAMOND_17X17_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[ dim8 ]    ) | \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  8) | \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  8) | \
     RC_WORD_LOAD  (&(ptr)[-dim8 ]    ))

#define RC_MORPH_ERODE_DIAMOND_25X25_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[-dim12]    ) & \
     RC_MORPH_LEFT (&(ptr)[ 0    ], 12) & \
     RC_MORPH_RIGHT(&(ptr)[ 0    ], 12) & \
     RC_WORD_LOAD  (&(ptr)[ dim12]    ))

#define RC_MORPH_DILATE_DIAMOND_25X25_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[ dim12]    ) | \
     RC_MORPH_RIGHT(&(ptr)[ 0    ], 12) | \
     RC_MORPH_LEFT (&(ptr)[ 0    ], 12) | \
     RC_WORD_LOAD  (&(ptr)[-dim12]    ))

#define RC_MORPH_ERODE_DIAMOND_29X29_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[-dim14]    ) & \
     RC_MORPH_LEFT (&(ptr)[ 0    ], 14) & \
     RC_MORPH_RIGHT(&(ptr)[ 0    ], 14) & \
     RC_WORD_LOAD  (&(ptr)[ dim14]    ))

#define RC_MORPH_DILATE_DIAMOND_29X29_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[ dim14]    ) | \
     RC_MORPH_RIGHT(&(ptr)[ 0    ], 14) | \
     RC_MORPH_LEFT (&(ptr)[ 0    ], 14) | \
     RC_WORD_LOAD  (&(ptr)[-dim14]    ))

#define RC_MORPH_ERODE_DIAMOND_31X31_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[-dim15]    ) & \
     RC_MORPH_LEFT (&(ptr)[ 0    ], 15) & \
     RC_MORPH_RIGHT(&(ptr)[ 0    ], 15) & \
     RC_WORD_LOAD  (&(ptr)[ dim15]    ))

#define RC_MORPH_DILATE_DIAMOND_31X31_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[ dim15]    ) | \
     RC_MORPH_RIGHT(&(ptr)[ 0    ], 15) | \
     RC_MORPH_LEFT (&(ptr)[ 0    ], 15) | \
     RC_WORD_LOAD  (&(ptr)[-dim15]    ))

#define RC_MORPH_ERODE_OCTAGON_5X5_P(ptr) \
    (RC_MORPH_LEFT (&(ptr)[-dim2 ],  1) & \
     RC_MORPH_RIGHT(&(ptr)[-dim2 ],  1) & \
     RC_MORPH_LEFT (&(ptr)[-dim1 ],  2) & \
     RC_MORPH_RIGHT(&(ptr)[-dim1 ],  2) & \
     RC_MORPH_LEFT (&(ptr)[ dim1 ],  2) & \
     RC_MORPH_RIGHT(&(ptr)[ dim1 ],  2) & \
     RC_MORPH_LEFT (&(ptr)[ dim2 ],  1) & \
     RC_MORPH_RIGHT(&(ptr)[ dim2 ],  1))

#define RC_MORPH_DILATE_OCTAGON_5X5_P(ptr) \
    (RC_MORPH_RIGHT(&(ptr)[ dim2 ],  1) | \
     RC_MORPH_LEFT (&(ptr)[ dim2 ],  1) | \
     RC_MORPH_RIGHT(&(ptr)[ dim1 ],  2) | \
     RC_MORPH_LEFT (&(ptr)[ dim1 ],  2) | \
     RC_MORPH_RIGHT(&(ptr)[-dim1 ],  2) | \
     RC_MORPH_LEFT (&(ptr)[-dim1 ],  2) | \
     RC_MORPH_RIGHT(&(ptr)[-dim2 ],  1) | \
     RC_MORPH_LEFT (&(ptr)[-dim2 ],  1))

#define RC_MORPH_ERODE_OCTAGON_7X7_P(ptr) \
    (RC_MORPH_LEFT (&(ptr)[-dim3 ],  1) & \
     RC_MORPH_RIGHT(&(ptr)[-dim3 ],  1) & \
     RC_MORPH_LEFT (&(ptr)[-dim1 ],  3) & \
     RC_MORPH_RIGHT(&(ptr)[-dim1 ],  3) & \
     RC_MORPH_LEFT (&(ptr)[ dim1 ],  3) & \
     RC_MORPH_RIGHT(&(ptr)[ dim1 ],  3) & \
     RC_MORPH_LEFT (&(ptr)[ dim3 ],  1) & \
     RC_MORPH_RIGHT(&(ptr)[ dim3 ],  1))

#define RC_MORPH_DILATE_OCTAGON_7X7_P(ptr) \
    (RC_MORPH_RIGHT(&(ptr)[ dim3 ],  1) | \
     RC_MORPH_LEFT (&(ptr)[ dim3 ],  1) | \
     RC_MORPH_RIGHT(&(ptr)[ dim1 ],  3) | \
     RC_MORPH_LEFT (&(ptr)[ dim1 ],  3) | \
     RC_MORPH_RIGHT(&(ptr)[-dim1 ],  3) | \
     RC_MORPH_LEFT (&(ptr)[-dim1 ],  3) | \
     RC_MORPH_RIGHT(&(ptr)[-dim3 ],  1) | \
     RC_MORPH_LEFT (&(ptr)[-dim3 ],  1))

#define RC_MORPH_ERODE_OCTAGON_9X9_P(ptr) \
    (RC_MORPH_LEFT (&(ptr)[-dim4 ],  2) & \
     RC_MORPH_RIGHT(&(ptr)[-dim4 ],  2) & \
     RC_MORPH_LEFT (&(ptr)[-dim2 ],  4) & \
     RC_MORPH_RIGHT(&(ptr)[-dim2 ],  4) & \
     RC_MORPH_LEFT (&(ptr)[ dim2 ],  4) & \
     RC_MORPH_RIGHT(&(ptr)[ dim2 ],  4) & \
     RC_MORPH_LEFT (&(ptr)[ dim4 ],  2) & \
     RC_MORPH_RIGHT(&(ptr)[ dim4 ],  2))

#define RC_MORPH_DILATE_OCTAGON_9X9_P(ptr) \
    (RC_MORPH_RIGHT(&(ptr)[ dim4 ],  2) | \
     RC_MORPH_LEFT (&(ptr)[ dim4 ],  2) | \
     RC_MORPH_RIGHT(&(ptr)[ dim2 ],  4) | \
     RC_MORPH_LEFT (&(ptr)[ dim2 ],  4) | \
     RC_MORPH_RIGHT(&(ptr)[-dim2 ],  4) | \
     RC_MORPH_LEFT (&(ptr)[-dim2 ],  4) | \
     RC_MORPH_RIGHT(&(ptr)[-dim4 ],  2) | \
     RC_MORPH_LEFT (&(ptr)[-dim4 ],  2))

#define RC_MORPH_ERODE_OCTAGON_13X13_P(ptr) \
    (RC_MORPH_LEFT (&(ptr)[-dim6 ],  2) & \
     RC_MORPH_RIGHT(&(ptr)[-dim6 ],  2) & \
     RC_MORPH_LEFT (&(ptr)[-dim2 ],  6) & \
     RC_MORPH_RIGHT(&(ptr)[-dim2 ],  6) & \
     RC_MORPH_LEFT (&(ptr)[ dim2 ],  6) & \
     RC_MORPH_RIGHT(&(ptr)[ dim2 ],  6) & \
     RC_MORPH_LEFT (&(ptr)[ dim6 ],  2) & \
     RC_MORPH_RIGHT(&(ptr)[ dim6 ],  2))

#define RC_MORPH_DILATE_OCTAGON_13X13_P(ptr) \
    (RC_MORPH_RIGHT(&(ptr)[ dim6 ],  2) | \
     RC_MORPH_LEFT (&(ptr)[ dim6 ],  2) | \
     RC_MORPH_RIGHT(&(ptr)[ dim2 ],  6) | \
     RC_MORPH_LEFT (&(ptr)[ dim2 ],  6) | \
     RC_MORPH_RIGHT(&(ptr)[-dim2 ],  6) | \
     RC_MORPH_LEFT (&(ptr)[-dim2 ],  6) | \
     RC_MORPH_RIGHT(&(ptr)[-dim6 ],  2) | \
     RC_MORPH_LEFT (&(ptr)[-dim6 ],  2))

#define RC_MORPH_ERODE_OCTAGON_15X15_P(ptr) \
    (RC_MORPH_LEFT (&(ptr)[-dim7 ],  3) & \
     RC_MORPH_RIGHT(&(ptr)[-dim7 ],  3) & \
     RC_MORPH_LEFT (&(ptr)[-dim3 ],  7) & \
     RC_MORPH_RIGHT(&(ptr)[-dim3 ],  7) & \
     RC_MORPH_LEFT (&(ptr)[ dim3 ],  7) & \
     RC_MORPH_RIGHT(&(ptr)[ dim3 ],  7) & \
     RC_MORPH_LEFT (&(ptr)[ dim7 ],  3) & \
     RC_MORPH_RIGHT(&(ptr)[ dim7 ],  3))

#define RC_MORPH_DILATE_OCTAGON_15X15_P(ptr) \
    (RC_MORPH_RIGHT(&(ptr)[ dim7 ],  3) | \
     RC_MORPH_LEFT (&(ptr)[ dim7 ],  3) | \
     RC_MORPH_RIGHT(&(ptr)[ dim3 ],  7) | \
     RC_MORPH_LEFT (&(ptr)[ dim3 ],  7) | \
     RC_MORPH_RIGHT(&(ptr)[-dim3 ],  7) | \
     RC_MORPH_LEFT (&(ptr)[-dim3 ],  7) | \
     RC_MORPH_RIGHT(&(ptr)[-dim7 ],  3) | \
     RC_MORPH_LEFT (&(ptr)[-dim7 ],  3))

#define RC_MORPH_ERODE_OCTAGON_17X17_P(ptr) \
    (RC_MORPH_LEFT (&(ptr)[-dim8 ],  3) & \
     RC_MORPH_RIGHT(&(ptr)[-dim8 ],  3) & \
     RC_MORPH_LEFT (&(ptr)[-dim3 ],  8) & \
     RC_MORPH_RIGHT(&(ptr)[-dim3 ],  8) & \
     RC_MORPH_LEFT (&(ptr)[ dim3 ],  8) & \
     RC_MORPH_RIGHT(&(ptr)[ dim3 ],  8) & \
     RC_MORPH_LEFT (&(ptr)[ dim8 ],  3) & \
     RC_MORPH_RIGHT(&(ptr)[ dim8 ],  3))

#define RC_MORPH_DILATE_OCTAGON_17X17_P(ptr) \
    (RC_MORPH_RIGHT(&(ptr)[ dim8 ],  3) | \
     RC_MORPH_LEFT (&(ptr)[ dim8 ],  3) | \
     RC_MORPH_RIGHT(&(ptr)[ dim3 ],  8) | \
     RC_MORPH_LEFT (&(ptr)[ dim3 ],  8) | \
     RC_MORPH_RIGHT(&(ptr)[-dim3 ],  8) | \
     RC_MORPH_LEFT (&(ptr)[-dim3 ],  8) | \
     RC_MORPH_RIGHT(&(ptr)[-dim8 ],  3) | \
     RC_MORPH_LEFT (&(ptr)[-dim8 ],  3))

#define RC_MORPH_ERODE_OCTAGON_25X25_P(ptr) \
    (RC_MORPH_LEFT (&(ptr)[-dim12],  5) & \
     RC_MORPH_RIGHT(&(ptr)[-dim12],  5) & \
     RC_MORPH_LEFT (&(ptr)[-dim5 ], 12) & \
     RC_MORPH_RIGHT(&(ptr)[-dim5 ], 12) & \
     RC_MORPH_LEFT (&(ptr)[ dim5 ], 12) & \
     RC_MORPH_RIGHT(&(ptr)[ dim5 ], 12) & \
     RC_MORPH_LEFT (&(ptr)[ dim12],  5) & \
     RC_MORPH_RIGHT(&(ptr)[ dim12],  5))

#define RC_MORPH_DILATE_OCTAGON_25X25_P(ptr) \
    (RC_MORPH_RIGHT(&(ptr)[ dim12],  5) | \
     RC_MORPH_LEFT (&(ptr)[ dim12],  5) | \
     RC_MORPH_RIGHT(&(ptr)[ dim5 ], 12) | \
     RC_MORPH_LEFT (&(ptr)[ dim5 ], 12) | \
     RC_MORPH_RIGHT(&(ptr)[-dim5 ], 12) | \
     RC_MORPH_LEFT (&(ptr)[-dim5 ], 12) | \
     RC_MORPH_RIGHT(&(ptr)[-dim12],  5) | \
     RC_MORPH_LEFT (&(ptr)[-dim12],  5))

#define RC_MORPH_ERODE_OCTAGON_29X29_P(ptr) \
    (RC_MORPH_LEFT (&(ptr)[-dim14],  6) & \
     RC_MORPH_RIGHT(&(ptr)[-dim14],  6) & \
     RC_MORPH_LEFT (&(ptr)[-dim6 ], 14) & \
     RC_MORPH_RIGHT(&(ptr)[-dim6 ], 14) & \
     RC_MORPH_LEFT (&(ptr)[ dim6 ], 14) & \
     RC_MORPH_RIGHT(&(ptr)[ dim6 ], 14) & \
     RC_MORPH_LEFT (&(ptr)[ dim14],  6) & \
     RC_MORPH_RIGHT(&(ptr)[ dim14],  6))

#define RC_MORPH_DILATE_OCTAGON_29X29_P(ptr) \
    (RC_MORPH_RIGHT(&(ptr)[ dim14],  6) | \
     RC_MORPH_LEFT (&(ptr)[ dim14],  6) | \
     RC_MORPH_RIGHT(&(ptr)[ dim6 ], 14) | \
     RC_MORPH_LEFT (&(ptr)[ dim6 ], 14) | \
     RC_MORPH_RIGHT(&(ptr)[-dim6 ], 14) | \
     RC_MORPH_LEFT (&(ptr)[-dim6 ], 14) | \
     RC_MORPH_RIGHT(&(ptr)[-dim14],  6) | \
     RC_MORPH_LEFT (&(ptr)[-dim14],  6))

#define RC_MORPH_ERODE_OCTAGON_31X31_P(ptr) \
    (RC_MORPH_LEFT (&(ptr)[-dim15],  6) & \
     RC_MORPH_RIGHT(&(ptr)[-dim15],  6) & \
     RC_MORPH_LEFT (&(ptr)[-dim6 ], 15) & \
     RC_MORPH_RIGHT(&(ptr)[-dim6 ], 15) & \
     RC_MORPH_LEFT (&(ptr)[ dim6 ], 15) & \
     RC_MORPH_RIGHT(&(ptr)[ dim6 ], 15) & \
     RC_MORPH_LEFT (&(ptr)[ dim15],  6) & \
     RC_MORPH_RIGHT(&(ptr)[ dim15],  6))

#define RC_MORPH_DILATE_OCTAGON_31X31_P(ptr) \
    (RC_MORPH_RIGHT(&(ptr)[ dim15],  6) | \
     RC_MORPH_LEFT (&(ptr)[ dim15],  6) | \
     RC_MORPH_RIGHT(&(ptr)[ dim6 ], 15) | \
     RC_MORPH_LEFT (&(ptr)[ dim6 ], 15) | \
     RC_MORPH_RIGHT(&(ptr)[-dim6 ], 15) | \
     RC_MORPH_LEFT (&(ptr)[-dim6 ], 15) | \
     RC_MORPH_RIGHT(&(ptr)[-dim15],  6) | \
     RC_MORPH_LEFT (&(ptr)[-dim15],  6))

#define RC_MORPH_ERODE_DISC_7X7(ptr) \
    (RC_WORD_LOAD  (&(ptr)[-dim3 ]    ) & \
     RC_MORPH_LEFT (&(ptr)[-dim2 ],  2) & \
     RC_MORPH_LEFT (&(ptr)[-dim2 ],  1) & \
     RC_WORD_LOAD  (&(ptr)[-dim2 ]    ) & \
     RC_MORPH_RIGHT(&(ptr)[-dim2 ],  1) & \
     RC_MORPH_RIGHT(&(ptr)[-dim2 ],  2) & \
     RC_MORPH_LEFT (&(ptr)[-dim1 ],  2) & \
     RC_MORPH_LEFT (&(ptr)[-dim1 ],  1) & \
     RC_WORD_LOAD  (&(ptr)[-dim1 ]    ) & \
     RC_MORPH_RIGHT(&(ptr)[-dim1 ],  1) & \
     RC_MORPH_RIGHT(&(ptr)[-dim1 ],  2) & \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  3) & \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  2) & \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  1) & \
     RC_WORD_LOAD  (&(ptr)[ 0    ]    ) & \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  1) & \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  2) & \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  3) & \
     RC_MORPH_LEFT (&(ptr)[ dim1 ],  2) & \
     RC_MORPH_LEFT (&(ptr)[ dim1 ],  1) & \
     RC_WORD_LOAD  (&(ptr)[ dim1 ]    ) & \
     RC_MORPH_RIGHT(&(ptr)[ dim1 ],  1) & \
     RC_MORPH_RIGHT(&(ptr)[ dim1 ],  2) & \
     RC_MORPH_LEFT (&(ptr)[ dim2 ],  2) & \
     RC_MORPH_LEFT (&(ptr)[ dim2 ],  1) & \
     RC_WORD_LOAD  (&(ptr)[ dim2 ]    ) & \
     RC_MORPH_RIGHT(&(ptr)[ dim2 ],  1) & \
     RC_MORPH_RIGHT(&(ptr)[ dim2 ],  2) & \
     RC_WORD_LOAD  (&(ptr)[ dim3 ]    ))

#define RC_MORPH_DILATE_DISC_7X7(ptr) \
    (RC_WORD_LOAD  (&(ptr)[ dim3 ]    ) | \
     RC_MORPH_RIGHT(&(ptr)[ dim2 ],  2) | \
     RC_MORPH_RIGHT(&(ptr)[ dim2 ],  1) | \
     RC_WORD_LOAD  (&(ptr)[ dim2 ]    ) | \
     RC_MORPH_LEFT (&(ptr)[ dim2 ],  1) | \
     RC_MORPH_LEFT (&(ptr)[ dim2 ],  2) | \
     RC_MORPH_RIGHT(&(ptr)[ dim1 ],  2) | \
     RC_MORPH_RIGHT(&(ptr)[ dim1 ],  1) | \
     RC_WORD_LOAD  (&(ptr)[ dim1 ]    ) | \
     RC_MORPH_LEFT (&(ptr)[ dim1 ],  1) | \
     RC_MORPH_LEFT (&(ptr)[ dim1 ],  2) | \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  3) | \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  2) | \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  1) | \
     RC_WORD_LOAD  (&(ptr)[ 0    ]    ) | \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  1) | \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  2) | \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  3) | \
     RC_MORPH_RIGHT(&(ptr)[-dim1 ],  2) | \
     RC_MORPH_RIGHT(&(ptr)[-dim1 ],  1) | \
     RC_WORD_LOAD  (&(ptr)[-dim1 ]    ) | \
     RC_MORPH_LEFT (&(ptr)[-dim1 ],  1) | \
     RC_MORPH_LEFT (&(ptr)[-dim1 ],  2) | \
     RC_MORPH_RIGHT(&(ptr)[-dim2 ],  2) | \
     RC_MORPH_RIGHT(&(ptr)[-dim2 ],  1) | \
     RC_WORD_LOAD  (&(ptr)[-dim2 ]    ) | \
     RC_MORPH_LEFT (&(ptr)[-dim2 ],  1) | \
     RC_MORPH_LEFT (&(ptr)[-dim2 ],  2) | \
     RC_WORD_LOAD  (&(ptr)[-dim3 ]    ))

#define RC_MORPH_ERODE_DISC_7X7_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[-dim3 ]    ) & \
     RC_MORPH_LEFT (&(ptr)[-dim2 ],  2) & \
     RC_MORPH_RIGHT(&(ptr)[-dim2 ],  2) & \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  3) & \
     RC_WORD_LOAD  (&(ptr)[ 0    ]    ) & \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  3) & \
     RC_MORPH_LEFT (&(ptr)[ dim2 ],  2) & \
     RC_MORPH_RIGHT(&(ptr)[ dim2 ],  2) & \
     RC_WORD_LOAD  (&(ptr)[ dim3 ]    ))

#define RC_MORPH_DILATE_DISC_7X7_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[ dim3 ]    ) | \
     RC_MORPH_RIGHT(&(ptr)[ dim2 ],  2) | \
     RC_MORPH_LEFT (&(ptr)[ dim2 ],  2) | \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  3) | \
     RC_WORD_LOAD  (&(ptr)[ 0    ]    ) | \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  3) | \
     RC_MORPH_RIGHT(&(ptr)[-dim2 ],  2) | \
     RC_MORPH_LEFT (&(ptr)[-dim2 ],  2) | \
     RC_WORD_LOAD  (&(ptr)[-dim3 ]    ))

#define RC_MORPH_ERODE_DISC_9X9_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[-dim4 ]    ) & \
     RC_MORPH_LEFT (&(ptr)[-dim3 ],  3) & \
     RC_MORPH_RIGHT(&(ptr)[-dim3 ],  3) & \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  4) & \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  4) & \
     RC_MORPH_LEFT (&(ptr)[ dim3 ],  3) & \
     RC_MORPH_RIGHT(&(ptr)[ dim3 ],  3) & \
     RC_WORD_LOAD  (&(ptr)[ dim4 ]    ))

#define RC_MORPH_DILATE_DISC_9X9_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[ dim4 ]    ) | \
     RC_MORPH_RIGHT(&(ptr)[ dim3 ],  3) | \
     RC_MORPH_LEFT (&(ptr)[ dim3 ],  3) | \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  4) | \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  4) | \
     RC_MORPH_RIGHT(&(ptr)[-dim3 ],  3) | \
     RC_MORPH_LEFT (&(ptr)[-dim3 ],  3) | \
     RC_WORD_LOAD  (&(ptr)[-dim4 ]    ))

#define RC_MORPH_ERODE_DISC_11X11_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[-dim5 ]    ) & \
     RC_MORPH_LEFT (&(ptr)[-dim4 ],  4) & \
     RC_MORPH_LEFT (&(ptr)[-dim4 ],  3) & \
     RC_MORPH_RIGHT(&(ptr)[-dim4 ],  3) & \
     RC_MORPH_RIGHT(&(ptr)[-dim4 ],  4) & \
     RC_MORPH_LEFT (&(ptr)[-dim3 ],  4) & \
     RC_MORPH_RIGHT(&(ptr)[-dim3 ],  4) & \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  5) & \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  5) & \
     RC_MORPH_LEFT (&(ptr)[ dim3 ],  4) & \
     RC_MORPH_RIGHT(&(ptr)[ dim3 ],  4) & \
     RC_MORPH_LEFT (&(ptr)[ dim4 ],  4) & \
     RC_MORPH_LEFT (&(ptr)[ dim4 ],  3) & \
     RC_MORPH_RIGHT(&(ptr)[ dim4 ],  3) & \
     RC_MORPH_RIGHT(&(ptr)[ dim4 ],  4) & \
     RC_WORD_LOAD  (&(ptr)[ dim5 ]    ))

#define RC_MORPH_DILATE_DISC_11X11_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[ dim5 ]    ) | \
     RC_MORPH_RIGHT(&(ptr)[ dim4 ],  4) | \
     RC_MORPH_RIGHT(&(ptr)[ dim4 ],  3) | \
     RC_MORPH_LEFT (&(ptr)[ dim4 ],  3) | \
     RC_MORPH_LEFT (&(ptr)[ dim4 ],  4) | \
     RC_MORPH_RIGHT(&(ptr)[ dim3 ],  4) | \
     RC_MORPH_LEFT (&(ptr)[ dim3 ],  4) | \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  5) | \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  5) | \
     RC_MORPH_RIGHT(&(ptr)[-dim3 ],  4) | \
     RC_MORPH_LEFT (&(ptr)[-dim3 ],  4) | \
     RC_MORPH_RIGHT(&(ptr)[-dim4 ],  4) | \
     RC_MORPH_RIGHT(&(ptr)[-dim4 ],  3) | \
     RC_MORPH_LEFT (&(ptr)[-dim4 ],  3) | \
     RC_MORPH_LEFT (&(ptr)[-dim4 ],  4) | \
     RC_WORD_LOAD  (&(ptr)[-dim5 ]    ))

#define RC_MORPH_ERODE_DISC_13X13_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[-dim6 ]    ) & \
     RC_MORPH_LEFT (&(ptr)[-dim5 ],  4) & \
     RC_MORPH_LEFT (&(ptr)[-dim5 ],  3) & \
     RC_MORPH_RIGHT(&(ptr)[-dim5 ],  3) & \
     RC_MORPH_RIGHT(&(ptr)[-dim5 ],  4) & \
     RC_MORPH_LEFT (&(ptr)[-dim4 ],  5) & \
     RC_MORPH_RIGHT(&(ptr)[-dim4 ],  5) & \
     RC_MORPH_LEFT (&(ptr)[-dim3 ],  5) & \
     RC_MORPH_RIGHT(&(ptr)[-dim3 ],  5) & \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  6) & \
     RC_WORD_LOAD  (&(ptr)[ 0    ]    ) & \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  6) & \
     RC_MORPH_LEFT (&(ptr)[ dim3 ],  5) & \
     RC_MORPH_RIGHT(&(ptr)[ dim3 ],  5) & \
     RC_MORPH_LEFT (&(ptr)[ dim4 ],  5) & \
     RC_MORPH_RIGHT(&(ptr)[ dim4 ],  5) & \
     RC_MORPH_LEFT (&(ptr)[ dim5 ],  4) & \
     RC_MORPH_LEFT (&(ptr)[ dim5 ],  3) & \
     RC_MORPH_RIGHT(&(ptr)[ dim5 ],  3) & \
     RC_MORPH_RIGHT(&(ptr)[ dim5 ],  4) & \
     RC_WORD_LOAD  (&(ptr)[ dim6 ]    ))

#define RC_MORPH_DILATE_DISC_13X13_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[ dim6 ]    ) | \
     RC_MORPH_RIGHT(&(ptr)[ dim5 ],  4) | \
     RC_MORPH_RIGHT(&(ptr)[ dim5 ],  3) | \
     RC_MORPH_LEFT (&(ptr)[ dim5 ],  3) | \
     RC_MORPH_LEFT (&(ptr)[ dim5 ],  4) | \
     RC_MORPH_RIGHT(&(ptr)[ dim4 ],  5) | \
     RC_MORPH_LEFT (&(ptr)[ dim4 ],  5) | \
     RC_MORPH_RIGHT(&(ptr)[ dim3 ],  5) | \
     RC_MORPH_LEFT (&(ptr)[ dim3 ],  5) | \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  6) | \
     RC_WORD_LOAD  (&(ptr)[ 0    ]    ) | \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  6) | \
     RC_MORPH_RIGHT(&(ptr)[-dim3 ],  5) | \
     RC_MORPH_LEFT (&(ptr)[-dim3 ],  5) | \
     RC_MORPH_RIGHT(&(ptr)[-dim4 ],  5) | \
     RC_MORPH_LEFT (&(ptr)[-dim4 ],  5) | \
     RC_MORPH_RIGHT(&(ptr)[-dim5 ],  4) | \
     RC_MORPH_RIGHT(&(ptr)[-dim5 ],  3) | \
     RC_MORPH_LEFT (&(ptr)[-dim5 ],  3) | \
     RC_MORPH_LEFT (&(ptr)[-dim5 ],  4) | \
     RC_WORD_LOAD  (&(ptr)[-dim6 ]    ))

#define RC_MORPH_ERODE_DISC_15X15_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[-dim7 ]    ) & \
     RC_MORPH_LEFT (&(ptr)[-dim6 ],  4) & \
     RC_MORPH_LEFT (&(ptr)[-dim6 ],  3) & \
     RC_MORPH_RIGHT(&(ptr)[-dim6 ],  3) & \
     RC_MORPH_RIGHT(&(ptr)[-dim6 ],  4) & \
     RC_MORPH_LEFT (&(ptr)[-dim4 ],  6) & \
     RC_MORPH_RIGHT(&(ptr)[-dim4 ],  6) & \
     RC_MORPH_LEFT (&(ptr)[-dim3 ],  6) & \
     RC_MORPH_RIGHT(&(ptr)[-dim3 ],  6) & \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  7) & \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  7) & \
     RC_MORPH_LEFT (&(ptr)[ dim3 ],  6) & \
     RC_MORPH_RIGHT(&(ptr)[ dim3 ],  6) & \
     RC_MORPH_LEFT (&(ptr)[ dim4 ],  6) & \
     RC_MORPH_RIGHT(&(ptr)[ dim4 ],  6) & \
     RC_MORPH_LEFT (&(ptr)[ dim6 ],  4) & \
     RC_MORPH_LEFT (&(ptr)[ dim6 ],  3) & \
     RC_MORPH_RIGHT(&(ptr)[ dim6 ],  3) & \
     RC_MORPH_RIGHT(&(ptr)[ dim6 ],  4) & \
     RC_WORD_LOAD  (&(ptr)[ dim7 ]    ))

#define RC_MORPH_DILATE_DISC_15X15_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[ dim7 ]    ) | \
     RC_MORPH_RIGHT(&(ptr)[ dim6 ],  4) | \
     RC_MORPH_RIGHT(&(ptr)[ dim6 ],  3) | \
     RC_MORPH_LEFT (&(ptr)[ dim6 ],  3) | \
     RC_MORPH_LEFT (&(ptr)[ dim6 ],  4) | \
     RC_MORPH_RIGHT(&(ptr)[ dim4 ],  6) | \
     RC_MORPH_LEFT (&(ptr)[ dim4 ],  6) | \
     RC_MORPH_RIGHT(&(ptr)[ dim3 ],  6) | \
     RC_MORPH_LEFT (&(ptr)[ dim3 ],  6) | \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  7) | \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  7) | \
     RC_MORPH_RIGHT(&(ptr)[-dim3 ],  6) | \
     RC_MORPH_LEFT (&(ptr)[-dim3 ],  6) | \
     RC_MORPH_RIGHT(&(ptr)[-dim4 ],  6) | \
     RC_MORPH_LEFT (&(ptr)[-dim4 ],  6) | \
     RC_MORPH_RIGHT(&(ptr)[-dim6 ],  4) | \
     RC_MORPH_RIGHT(&(ptr)[-dim6 ],  3) | \
     RC_MORPH_LEFT (&(ptr)[-dim6 ],  3) | \
     RC_MORPH_LEFT (&(ptr)[-dim6 ],  4) | \
     RC_WORD_LOAD  (&(ptr)[-dim7 ]    ))

#define RC_MORPH_ERODE_DISC_17X17_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[-dim8 ]    ) & \
     RC_MORPH_LEFT (&(ptr)[-dim7 ],  5) & \
     RC_MORPH_LEFT (&(ptr)[-dim7 ],  4) & \
     RC_MORPH_RIGHT(&(ptr)[-dim7 ],  4) & \
     RC_MORPH_RIGHT(&(ptr)[-dim7 ],  5) & \
     RC_MORPH_LEFT (&(ptr)[-dim5 ],  7) & \
     RC_MORPH_RIGHT(&(ptr)[-dim5 ],  7) & \
     RC_MORPH_LEFT (&(ptr)[-dim4 ],  7) & \
     RC_MORPH_RIGHT(&(ptr)[-dim4 ],  7) & \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  8) & \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  8) & \
     RC_MORPH_LEFT (&(ptr)[ dim4 ],  7) & \
     RC_MORPH_RIGHT(&(ptr)[ dim4 ],  7) & \
     RC_MORPH_LEFT (&(ptr)[ dim5 ],  7) & \
     RC_MORPH_RIGHT(&(ptr)[ dim5 ],  7) & \
     RC_MORPH_LEFT (&(ptr)[ dim7 ],  5) & \
     RC_MORPH_LEFT (&(ptr)[ dim7 ],  4) & \
     RC_MORPH_RIGHT(&(ptr)[ dim7 ],  4) & \
     RC_MORPH_RIGHT(&(ptr)[ dim7 ],  5) & \
     RC_WORD_LOAD  (&(ptr)[ dim8 ]    ))

#define RC_MORPH_DILATE_DISC_17X17_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[ dim8 ]    ) | \
     RC_MORPH_RIGHT(&(ptr)[ dim7 ],  5) | \
     RC_MORPH_RIGHT(&(ptr)[ dim7 ],  4) | \
     RC_MORPH_LEFT (&(ptr)[ dim7 ],  4) | \
     RC_MORPH_LEFT (&(ptr)[ dim7 ],  5) | \
     RC_MORPH_RIGHT(&(ptr)[ dim5 ],  7) | \
     RC_MORPH_LEFT (&(ptr)[ dim5 ],  7) | \
     RC_MORPH_RIGHT(&(ptr)[ dim4 ],  7) | \
     RC_MORPH_LEFT (&(ptr)[ dim4 ],  7) | \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  8) | \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  8) | \
     RC_MORPH_RIGHT(&(ptr)[-dim4 ],  7) | \
     RC_MORPH_LEFT (&(ptr)[-dim4 ],  7) | \
     RC_MORPH_RIGHT(&(ptr)[-dim5 ],  7) | \
     RC_MORPH_LEFT (&(ptr)[-dim5 ],  7) | \
     RC_MORPH_RIGHT(&(ptr)[-dim7 ],  5) | \
     RC_MORPH_RIGHT(&(ptr)[-dim7 ],  4) | \
     RC_MORPH_LEFT (&(ptr)[-dim7 ],  4) | \
     RC_MORPH_LEFT (&(ptr)[-dim7 ],  5) | \
     RC_WORD_LOAD  (&(ptr)[-dim8 ]    ))

#define RC_MORPH_ERODE_DISC_19X19_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[-dim9 ]    ) & \
     RC_MORPH_LEFT (&(ptr)[-dim8 ],  5) & \
     RC_MORPH_LEFT (&(ptr)[-dim8 ],  4) & \
     RC_MORPH_RIGHT(&(ptr)[-dim8 ],  4) & \
     RC_MORPH_RIGHT(&(ptr)[-dim8 ],  5) & \
     RC_MORPH_LEFT (&(ptr)[-dim5 ],  8) & \
     RC_MORPH_RIGHT(&(ptr)[-dim5 ],  8) & \
     RC_MORPH_LEFT (&(ptr)[-dim4 ],  8) & \
     RC_MORPH_RIGHT(&(ptr)[-dim4 ],  8) & \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  9) & \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  9) & \
     RC_MORPH_LEFT (&(ptr)[ dim4 ],  8) & \
     RC_MORPH_RIGHT(&(ptr)[ dim4 ],  8) & \
     RC_MORPH_LEFT (&(ptr)[ dim5 ],  8) & \
     RC_MORPH_RIGHT(&(ptr)[ dim5 ],  8) & \
     RC_MORPH_LEFT (&(ptr)[ dim8 ],  5) & \
     RC_MORPH_LEFT (&(ptr)[ dim8 ],  4) & \
     RC_MORPH_RIGHT(&(ptr)[ dim8 ],  4) & \
     RC_MORPH_RIGHT(&(ptr)[ dim8 ],  5) & \
     RC_WORD_LOAD  (&(ptr)[ dim9 ]    ))

#define RC_MORPH_DILATE_DISC_19X19_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[ dim9 ]    ) | \
     RC_MORPH_RIGHT(&(ptr)[ dim8 ],  5) | \
     RC_MORPH_RIGHT(&(ptr)[ dim8 ],  4) | \
     RC_MORPH_LEFT (&(ptr)[ dim8 ],  4) | \
     RC_MORPH_LEFT (&(ptr)[ dim8 ],  5) | \
     RC_MORPH_RIGHT(&(ptr)[ dim5 ],  8) | \
     RC_MORPH_LEFT (&(ptr)[ dim5 ],  8) | \
     RC_MORPH_RIGHT(&(ptr)[ dim4 ],  8) | \
     RC_MORPH_LEFT (&(ptr)[ dim4 ],  8) | \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  9) | \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  9) | \
     RC_MORPH_RIGHT(&(ptr)[-dim4 ],  8) | \
     RC_MORPH_LEFT (&(ptr)[-dim4 ],  8) | \
     RC_MORPH_RIGHT(&(ptr)[-dim5 ],  8) | \
     RC_MORPH_LEFT (&(ptr)[-dim5 ],  8) | \
     RC_MORPH_RIGHT(&(ptr)[-dim8 ],  5) | \
     RC_MORPH_RIGHT(&(ptr)[-dim8 ],  4) | \
     RC_MORPH_LEFT (&(ptr)[-dim8 ],  4) | \
     RC_MORPH_LEFT (&(ptr)[-dim8 ],  5) | \
     RC_WORD_LOAD  (&(ptr)[-dim9 ]    ))

#define RC_MORPH_ERODE_DISC_25X25_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[-dim12]    ) & \
     RC_MORPH_LEFT (&(ptr)[-dim11],  6) & \
     RC_MORPH_LEFT (&(ptr)[-dim11],  5) & \
     RC_MORPH_RIGHT(&(ptr)[-dim11],  5) & \
     RC_MORPH_RIGHT(&(ptr)[-dim11],  6) & \
     RC_MORPH_LEFT (&(ptr)[-dim10],  7) & \
     RC_MORPH_RIGHT(&(ptr)[-dim10],  7) & \
     RC_MORPH_LEFT (&(ptr)[-dim7 ], 10) & \
     RC_MORPH_RIGHT(&(ptr)[-dim7 ], 10) & \
     RC_MORPH_LEFT (&(ptr)[-dim6 ], 11) & \
     RC_MORPH_RIGHT(&(ptr)[-dim6 ], 11) & \
     RC_MORPH_LEFT (&(ptr)[-dim5 ], 11) & \
     RC_MORPH_RIGHT(&(ptr)[-dim5 ], 11) & \
     RC_MORPH_LEFT (&(ptr)[ 0    ], 12) & \
     RC_MORPH_RIGHT(&(ptr)[ 0    ], 12) & \
     RC_MORPH_LEFT (&(ptr)[ dim5 ], 11) & \
     RC_MORPH_RIGHT(&(ptr)[ dim5 ], 11) & \
     RC_MORPH_LEFT (&(ptr)[ dim6 ], 11) & \
     RC_MORPH_RIGHT(&(ptr)[ dim6 ], 11) & \
     RC_MORPH_LEFT (&(ptr)[ dim7 ], 10) & \
     RC_MORPH_RIGHT(&(ptr)[ dim7 ], 10) & \
     RC_MORPH_LEFT (&(ptr)[ dim10],  7) & \
     RC_MORPH_RIGHT(&(ptr)[ dim10],  7) & \
     RC_MORPH_LEFT (&(ptr)[ dim11],  6) & \
     RC_MORPH_LEFT (&(ptr)[ dim11],  5) & \
     RC_MORPH_RIGHT(&(ptr)[ dim11],  5) & \
     RC_MORPH_RIGHT(&(ptr)[ dim11],  6) & \
     RC_WORD_LOAD  (&(ptr)[ dim12]    ))

#define RC_MORPH_DILATE_DISC_25X25_P(ptr) \
    (RC_WORD_LOAD  (&(ptr)[ dim12]    ) | \
     RC_MORPH_RIGHT(&(ptr)[ dim11],  6) | \
     RC_MORPH_RIGHT(&(ptr)[ dim11],  5) | \
     RC_MORPH_LEFT (&(ptr)[ dim11],  5) | \
     RC_MORPH_LEFT (&(ptr)[ dim11],  6) | \
     RC_MORPH_RIGHT(&(ptr)[ dim10],  7) | \
     RC_MORPH_LEFT (&(ptr)[ dim10],  7) | \
     RC_MORPH_RIGHT(&(ptr)[ dim7 ], 10) | \
     RC_MORPH_LEFT (&(ptr)[ dim7 ], 10) | \
     RC_MORPH_RIGHT(&(ptr)[ dim6 ], 11) | \
     RC_MORPH_LEFT (&(ptr)[ dim6 ], 11) | \
     RC_MORPH_RIGHT(&(ptr)[ dim5 ], 11) | \
     RC_MORPH_LEFT (&(ptr)[ dim5 ], 11) | \
     RC_MORPH_RIGHT(&(ptr)[ 0    ], 12) | \
     RC_MORPH_LEFT (&(ptr)[ 0    ], 12) | \
     RC_MORPH_RIGHT(&(ptr)[-dim5 ], 11) | \
     RC_MORPH_LEFT (&(ptr)[-dim5 ], 11) | \
     RC_MORPH_RIGHT(&(ptr)[-dim6 ], 11) | \
     RC_MORPH_LEFT (&(ptr)[-dim6 ], 11) | \
     RC_MORPH_RIGHT(&(ptr)[-dim7 ], 10) | \
     RC_MORPH_LEFT (&(ptr)[-dim7 ], 10) | \
     RC_MORPH_RIGHT(&(ptr)[-dim10],  7) | \
     RC_MORPH_LEFT (&(ptr)[-dim10],  7) | \
     RC_MORPH_RIGHT(&(ptr)[-dim11],  6) | \
     RC_MORPH_RIGHT(&(ptr)[-dim11],  5) | \
     RC_MORPH_LEFT (&(ptr)[-dim11],  5) | \
     RC_MORPH_LEFT (&(ptr)[-dim11],  6) | \
     RC_WORD_LOAD  (&(ptr)[-dim12]    ))

#define RC_MORPH_HMT_GOLAY_L_3X3_C48_R0(ptr) \
  ( (RC_MORPH_LEFT (&(ptr)[ dim1 ],  1) & \
     RC_WORD_LOAD  (&(ptr)[ dim1 ]    ) & \
     RC_MORPH_RIGHT(&(ptr)[ dim1 ],  1)) & \
   ~(RC_MORPH_LEFT (&(ptr)[-dim1 ],  1) | \
     RC_WORD_LOAD  (&(ptr)[-dim1 ]    ) | \
     RC_MORPH_RIGHT(&(ptr)[-dim1 ],  1)))

#define RC_MORPH_HMT_GOLAY_L_3X3_C48_R90(ptr) \
  ( (RC_MORPH_LEFT (&(ptr)[-dim1 ],  1) & \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  1) & \
     RC_MORPH_LEFT (&(ptr)[ dim1 ],  1)) & \
   ~(RC_MORPH_RIGHT(&(ptr)[-dim1 ],  1) | \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  1) | \
     RC_MORPH_RIGHT(&(ptr)[ dim1 ],  1)))

#define RC_MORPH_HMT_GOLAY_L_3X3_C48_R180(ptr) \
  ( (RC_MORPH_RIGHT(&(ptr)[-dim1 ],  1) & \
     RC_WORD_LOAD  (&(ptr)[-dim1 ]    ) & \
     RC_MORPH_LEFT (&(ptr)[-dim1 ],  1)) & \
   ~(RC_MORPH_RIGHT(&(ptr)[ dim1 ],  1) | \
     RC_WORD_LOAD  (&(ptr)[ dim1 ]    ) | \
     RC_MORPH_LEFT (&(ptr)[ dim1 ],  1)))

#define RC_MORPH_HMT_GOLAY_L_3X3_C48_R270(ptr) \
  ( (RC_MORPH_RIGHT(&(ptr)[ dim1 ],  1) & \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  1) & \
     RC_MORPH_RIGHT(&(ptr)[-dim1 ],  1)) & \
   ~(RC_MORPH_LEFT (&(ptr)[ dim1 ],  1) | \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  1) | \
     RC_MORPH_LEFT (&(ptr)[-dim1 ],  1)))

#define RC_MORPH_HMT_GOLAY_L_3X3_C4_R45(ptr) \
  ( (RC_MORPH_LEFT (&(ptr)[ 0    ],  1) & \
     RC_MORPH_LEFT (&(ptr)[ dim1 ],  1) & \
     RC_WORD_LOAD  (&(ptr)[ dim1 ]    )) & \
   ~(RC_WORD_LOAD  (&(ptr)[-dim1 ]    ) | \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  1)))

#define RC_MORPH_HMT_GOLAY_L_3X3_C4_R135(ptr) \
  ( (RC_WORD_LOAD  (&(ptr)[-dim1 ]    ) & \
     RC_MORPH_LEFT (&(ptr)[-dim1 ],  1) & \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  1)) & \
   ~(RC_MORPH_RIGHT(&(ptr)[ 0    ],  1) | \
     RC_WORD_LOAD  (&(ptr)[ dim1 ]    )))

#define RC_MORPH_HMT_GOLAY_L_3X3_C4_R225(ptr) \
  ( (RC_MORPH_RIGHT(&(ptr)[ 0    ],  1) & \
     RC_MORPH_RIGHT(&(ptr)[-dim1 ],  1) & \
     RC_WORD_LOAD  (&(ptr)[-dim1 ]    )) & \
   ~(RC_WORD_LOAD  (&(ptr)[ dim1 ]    ) | \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  1)))

#define RC_MORPH_HMT_GOLAY_L_3X3_C4_R315(ptr) \
  ( (RC_WORD_LOAD  (&(ptr)[ dim1 ]    ) & \
     RC_MORPH_RIGHT(&(ptr)[ dim1 ],  1) & \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  1)) & \
   ~(RC_MORPH_LEFT (&(ptr)[ 0    ],  1) | \
     RC_WORD_LOAD  (&(ptr)[-dim1 ]    )))

#define RC_MORPH_HMT_GOLAY_L_3X3_C8_R45(ptr) \
  ( (RC_MORPH_LEFT (&(ptr)[ 0    ],  1) & \
     RC_WORD_LOAD  (&(ptr)[ dim1 ]    )) & \
   ~(RC_WORD_LOAD  (&(ptr)[-dim1 ]    ) | \
     RC_MORPH_RIGHT(&(ptr)[-dim1 ],  1) | \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  1)))

#define RC_MORPH_HMT_GOLAY_L_3X3_C8_R135(ptr) \
  ( (RC_WORD_LOAD  (&(ptr)[-dim1 ]    ) & \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  1)) & \
   ~(RC_MORPH_RIGHT(&(ptr)[ 0    ],  1) | \
     RC_MORPH_RIGHT(&(ptr)[ dim1 ],  1) | \
     RC_WORD_LOAD  (&(ptr)[ dim1 ]    )))

#define RC_MORPH_HMT_GOLAY_L_3X3_C8_R225(ptr) \
  ( (RC_MORPH_RIGHT(&(ptr)[ 0    ],  1) & \
     RC_WORD_LOAD  (&(ptr)[-dim1 ]    )) & \
   ~(RC_WORD_LOAD  (&(ptr)[ dim1 ]    ) | \
     RC_MORPH_LEFT (&(ptr)[ dim1 ],  1) | \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  1)))

#define RC_MORPH_HMT_GOLAY_L_3X3_C8_R315(ptr) \
  ( (RC_WORD_LOAD  (&(ptr)[ dim1 ]    ) & \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  1)) & \
   ~(RC_MORPH_LEFT (&(ptr)[ 0    ],  1) | \
     RC_MORPH_LEFT (&(ptr)[-dim1 ],  1) | \
     RC_WORD_LOAD  (&(ptr)[-dim1 ]    )))

#define RC_MORPH_HMT_GOLAY_E_3X3_C4_R0(ptr) \
  (~(RC_WORD_LOAD  (&(ptr)[-dim1 ]    ) | \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  1) | \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  1)))

#define RC_MORPH_HMT_GOLAY_E_3X3_C4_R90(ptr) \
  (~(RC_MORPH_RIGHT(&(ptr)[ 0    ],  1) | \
     RC_WORD_LOAD  (&(ptr)[-dim1 ]    ) | \
     RC_WORD_LOAD  (&(ptr)[ dim1 ]    )))

#define RC_MORPH_HMT_GOLAY_E_3X3_C4_R180(ptr) \
  (~(RC_WORD_LOAD  (&(ptr)[ dim1 ]    ) | \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  1) | \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  1)))

#define RC_MORPH_HMT_GOLAY_E_3X3_C4_R270(ptr) \
  (~(RC_MORPH_LEFT (&(ptr)[ 0    ],  1) | \
     RC_WORD_LOAD  (&(ptr)[ dim1 ]    ) | \
     RC_WORD_LOAD  (&(ptr)[-dim1 ]    )))

#define RC_MORPH_HMT_GOLAY_E_3X3_C8_R0(ptr) \
  (~(RC_MORPH_LEFT (&(ptr)[-dim1 ],  1) | \
     RC_WORD_LOAD  (&(ptr)[-dim1 ]    ) | \
     RC_MORPH_RIGHT(&(ptr)[-dim1 ],  1) | \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  1) | \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  1) | \
     RC_MORPH_LEFT (&(ptr)[ dim1 ],  1)))

#define RC_MORPH_HMT_GOLAY_E_3X3_C8_R90(ptr) \
  (~(RC_MORPH_RIGHT(&(ptr)[-dim1 ],  1) | \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  1) | \
     RC_MORPH_RIGHT(&(ptr)[ dim1 ],  1) | \
     RC_WORD_LOAD  (&(ptr)[-dim1 ]    ) | \
     RC_WORD_LOAD  (&(ptr)[ dim1 ]    ) | \
     RC_MORPH_LEFT (&(ptr)[-dim1 ],  1)))

#define RC_MORPH_HMT_GOLAY_E_3X3_C8_R180(ptr) \
  (~(RC_MORPH_RIGHT(&(ptr)[ dim1 ],  1) | \
     RC_WORD_LOAD  (&(ptr)[ dim1 ]    ) | \
     RC_MORPH_LEFT (&(ptr)[ dim1 ],  1) | \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  1) | \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  1) | \
     RC_MORPH_RIGHT(&(ptr)[-dim1 ],  1)))

#define RC_MORPH_HMT_GOLAY_E_3X3_C8_R270(ptr) \
  (~(RC_MORPH_LEFT (&(ptr)[ dim1 ],  1) | \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  1) | \
     RC_MORPH_LEFT (&(ptr)[-dim1 ],  1) | \
     RC_WORD_LOAD  (&(ptr)[ dim1 ]    ) | \
     RC_WORD_LOAD  (&(ptr)[-dim1 ]    ) | \
     RC_MORPH_RIGHT(&(ptr)[ dim1 ],  1)))

#define RC_MORPH_HMT_GOLAY_E_3X3_C8_R45(ptr) \
  (~(RC_MORPH_LEFT (&(ptr)[-dim1 ],  1) | \
     RC_WORD_LOAD  (&(ptr)[-dim1 ]    ) | \
     RC_MORPH_RIGHT(&(ptr)[-dim1 ],  1) | \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  1) | \
     RC_MORPH_LEFT (&(ptr)[ dim1 ],  1) | \
     RC_WORD_LOAD  (&(ptr)[ dim1 ]    )))

#define RC_MORPH_HMT_GOLAY_E_3X3_C8_R135(ptr) \
  (~(RC_MORPH_RIGHT(&(ptr)[-dim1 ],  1) | \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  1) | \
     RC_MORPH_RIGHT(&(ptr)[ dim1 ],  1) | \
     RC_WORD_LOAD  (&(ptr)[-dim1 ]    ) | \
     RC_MORPH_LEFT (&(ptr)[-dim1 ],  1) | \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  1)))

#define RC_MORPH_HMT_GOLAY_E_3X3_C8_R225(ptr) \
  (~(RC_MORPH_RIGHT(&(ptr)[ dim1 ],  1) | \
     RC_WORD_LOAD  (&(ptr)[ dim1 ]    ) | \
     RC_MORPH_LEFT (&(ptr)[ dim1 ],  1) | \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  1) | \
     RC_MORPH_RIGHT(&(ptr)[-dim1 ],  1) | \
     RC_WORD_LOAD  (&(ptr)[-dim1 ]    )))

#define RC_MORPH_HMT_GOLAY_E_3X3_C8_R315(ptr) \
  (~(RC_MORPH_LEFT (&(ptr)[ dim1 ],  1) | \
     RC_MORPH_LEFT (&(ptr)[ 0    ],  1) | \
     RC_MORPH_LEFT (&(ptr)[-dim1 ],  1) | \
     RC_WORD_LOAD  (&(ptr)[ dim1 ]    ) | \
     RC_MORPH_RIGHT(&(ptr)[ dim1 ],  1) | \
     RC_MORPH_RIGHT(&(ptr)[ 0    ],  1)))

/*
 * --------------------------------------------------------------
 *  Exported functions
 * --------------------------------------------------------------
 */

#if RC_IMPL(rc_morph_erode_line_1x2_bin, 1)
void
rc_morph_erode_line_1x2_bin(uint8_t *restrict dst, int dst_dim,
                            const uint8_t *restrict src, int src_dim,
                            int width, int height)
{
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_LINE_1X2,
                      RC_UNROLL(rc_morph_erode_line_1x2_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_line_1x2_bin, 1)
void
rc_morph_dilate_line_1x2_bin(uint8_t *restrict dst, int dst_dim,
                             const uint8_t *restrict src, int src_dim,
                             int width, int height)
{
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_LINE_1X2,
                      RC_UNROLL(rc_morph_dilate_line_1x2_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_line_1x3_bin, 1)
void
rc_morph_erode_line_1x3_bin(uint8_t *restrict dst, int dst_dim,
                            const uint8_t *restrict src, int src_dim,
                            int width, int height)
{
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_LINE_1X3,
                      RC_UNROLL(rc_morph_erode_line_1x3_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_line_1x3_bin, 1)
void
rc_morph_dilate_line_1x3_bin(uint8_t *restrict dst, int dst_dim,
                             const uint8_t *restrict src, int src_dim,
                             int width, int height)
{
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_LINE_1X3,
                      RC_UNROLL(rc_morph_dilate_line_1x3_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_line_1x3_p_bin, 1)
void
rc_morph_erode_line_1x3_p_bin(uint8_t *restrict dst, int dst_dim,
                              const uint8_t *restrict src, int src_dim,
                              int width, int height)
{
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_LINE_1X3_P,
                      RC_UNROLL(rc_morph_erode_line_1x3_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_line_1x3_p_bin, 1)
void
rc_morph_dilate_line_1x3_p_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height)
{
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_LINE_1X3_P,
                      RC_UNROLL(rc_morph_dilate_line_1x3_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_line_1x5_p_bin, 1)
void
rc_morph_erode_line_1x5_p_bin(uint8_t *restrict dst, int dst_dim,
                              const uint8_t *restrict src, int src_dim,
                              int width, int height)
{
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_LINE_1X5_P,
                      RC_UNROLL(rc_morph_erode_line_1x5_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_line_1x5_p_bin, 1)
void
rc_morph_dilate_line_1x5_p_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height)
{
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_LINE_1X5_P,
                      RC_UNROLL(rc_morph_dilate_line_1x5_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_line_1x7_p_bin, 1)
void
rc_morph_erode_line_1x7_p_bin(uint8_t *restrict dst, int dst_dim,
                              const uint8_t *restrict src, int src_dim,
                              int width, int height)
{
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_LINE_1X7_P,
                      RC_UNROLL(rc_morph_erode_line_1x7_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_line_1x7_p_bin, 1)
void
rc_morph_dilate_line_1x7_p_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height)
{
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_LINE_1X7_P,
                      RC_UNROLL(rc_morph_dilate_line_1x7_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_line_1x9_p_bin, 1)
void
rc_morph_erode_line_1x9_p_bin(uint8_t *restrict dst, int dst_dim,
                              const uint8_t *restrict src, int src_dim,
                              int width, int height)
{
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_LINE_1X9_P,
                      RC_UNROLL(rc_morph_erode_line_1x9_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_line_1x9_p_bin, 1)
void
rc_morph_dilate_line_1x9_p_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height)
{
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_LINE_1X9_P,
                      RC_UNROLL(rc_morph_dilate_line_1x9_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_line_1x13_p_bin, 1)
void
rc_morph_erode_line_1x13_p_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height)
{
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_LINE_1X13_P,
                      RC_UNROLL(rc_morph_erode_line_1x13_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_line_1x13_p_bin, 1)
void
rc_morph_dilate_line_1x13_p_bin(uint8_t *restrict dst, int dst_dim,
                                const uint8_t *restrict src, int src_dim,
                                int width, int height)
{
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_LINE_1X13_P,
                      RC_UNROLL(rc_morph_dilate_line_1x13_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_line_1x15_p_bin, 1)
void
rc_morph_erode_line_1x15_p_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height)
{
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_LINE_1X15_P,
                      RC_UNROLL(rc_morph_erode_line_1x15_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_line_1x15_p_bin, 1)
void
rc_morph_dilate_line_1x15_p_bin(uint8_t *restrict dst, int dst_dim,
                                const uint8_t *restrict src, int src_dim,
                                int width, int height)
{
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_LINE_1X15_P,
                      RC_UNROLL(rc_morph_dilate_line_1x15_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_line_1x17_p_bin, 1)
void
rc_morph_erode_line_1x17_p_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height)
{
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_LINE_1X17_P,
                      RC_UNROLL(rc_morph_erode_line_1x17_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_line_1x17_p_bin, 1)
void
rc_morph_dilate_line_1x17_p_bin(uint8_t *restrict dst, int dst_dim,
                                const uint8_t *restrict src, int src_dim,
                                int width, int height)
{
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_LINE_1X17_P,
                      RC_UNROLL(rc_morph_dilate_line_1x17_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_line_1x25_p_bin, 1)
void
rc_morph_erode_line_1x25_p_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height)
{
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_LINE_1X25_P,
                      RC_UNROLL(rc_morph_erode_line_1x25_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_line_1x25_p_bin, 1)
void
rc_morph_dilate_line_1x25_p_bin(uint8_t *restrict dst, int dst_dim,
                                const uint8_t *restrict src, int src_dim,
                                int width, int height)
{
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_LINE_1X25_P,
                      RC_UNROLL(rc_morph_dilate_line_1x25_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_line_1x29_p_bin, 1)
void
rc_morph_erode_line_1x29_p_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height)
{
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_LINE_1X29_P,
                      RC_UNROLL(rc_morph_erode_line_1x29_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_line_1x29_p_bin, 1)
void
rc_morph_dilate_line_1x29_p_bin(uint8_t *restrict dst, int dst_dim,
                                const uint8_t *restrict src, int src_dim,
                                int width, int height)
{
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_LINE_1X29_P,
                      RC_UNROLL(rc_morph_dilate_line_1x29_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_line_1x31_p_bin, 1)
void
rc_morph_erode_line_1x31_p_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height)
{
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_LINE_1X31_P,
                      RC_UNROLL(rc_morph_erode_line_1x31_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_line_1x31_p_bin, 1)
void
rc_morph_dilate_line_1x31_p_bin(uint8_t *restrict dst, int dst_dim,
                                const uint8_t *restrict src, int src_dim,
                                int width, int height)
{
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_LINE_1X31_P,
                      RC_UNROLL(rc_morph_dilate_line_1x31_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_line_2x1_bin, 1)
void
rc_morph_erode_line_2x1_bin(uint8_t *restrict dst, int dst_dim,
                            const uint8_t *restrict src, int src_dim,
                            int width, int height)
{
    int dim1 = src_dim*1;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_LINE_2X1,
                      RC_UNROLL(rc_morph_erode_line_2x1_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_line_2x1_bin, 1)
void
rc_morph_dilate_line_2x1_bin(uint8_t *restrict dst, int dst_dim,
                             const uint8_t *restrict src, int src_dim,
                             int width, int height)
{
    int dim1 = src_dim*1;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_LINE_2X1,
                      RC_UNROLL(rc_morph_dilate_line_2x1_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_line_3x1_bin, 1)
void
rc_morph_erode_line_3x1_bin(uint8_t *restrict dst, int dst_dim,
                            const uint8_t *restrict src, int src_dim,
                            int width, int height)
{
    int dim1 = src_dim*1;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_LINE_3X1,
                      RC_UNROLL(rc_morph_erode_line_3x1_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_line_3x1_bin, 1)
void
rc_morph_dilate_line_3x1_bin(uint8_t *restrict dst, int dst_dim,
                             const uint8_t *restrict src, int src_dim,
                             int width, int height)
{
    int dim1 = src_dim*1;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_LINE_3X1,
                      RC_UNROLL(rc_morph_dilate_line_3x1_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_line_3x1_p_bin, 1)
void
rc_morph_erode_line_3x1_p_bin(uint8_t *restrict dst, int dst_dim,
                              const uint8_t *restrict src, int src_dim,
                              int width, int height)
{
    int dim1 = src_dim*1;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_LINE_3X1_P,
                      RC_UNROLL(rc_morph_erode_line_3x1_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_line_3x1_p_bin, 1)
void
rc_morph_dilate_line_3x1_p_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height)
{
    int dim1 = src_dim*1;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_LINE_3X1_P,
                      RC_UNROLL(rc_morph_dilate_line_3x1_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_line_5x1_p_bin, 1)
void
rc_morph_erode_line_5x1_p_bin(uint8_t *restrict dst, int dst_dim,
                              const uint8_t *restrict src, int src_dim,
                              int width, int height)
{
    int dim2 = src_dim*2;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_LINE_5X1_P,
                      RC_UNROLL(rc_morph_erode_line_5x1_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_line_5x1_p_bin, 1)
void
rc_morph_dilate_line_5x1_p_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height)
{
    int dim2 = src_dim*2;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_LINE_5X1_P,
                      RC_UNROLL(rc_morph_dilate_line_5x1_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_line_7x1_p_bin, 1)
void
rc_morph_erode_line_7x1_p_bin(uint8_t *restrict dst, int dst_dim,
                              const uint8_t *restrict src, int src_dim,
                              int width, int height)
{
    int dim3 = src_dim*3;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_LINE_7X1_P,
                      RC_UNROLL(rc_morph_erode_line_7x1_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_line_7x1_p_bin, 1)
void
rc_morph_dilate_line_7x1_p_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height)
{
    int dim3 = src_dim*3;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_LINE_7X1_P,
                      RC_UNROLL(rc_morph_dilate_line_7x1_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_line_9x1_p_bin, 1)
void
rc_morph_erode_line_9x1_p_bin(uint8_t *restrict dst, int dst_dim,
                              const uint8_t *restrict src, int src_dim,
                              int width, int height)
{
    int dim4 = src_dim*4;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_LINE_9X1_P,
                      RC_UNROLL(rc_morph_erode_line_9x1_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_line_9x1_p_bin, 1)
void
rc_morph_dilate_line_9x1_p_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height)
{
    int dim4 = src_dim*4;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_LINE_9X1_P,
                      RC_UNROLL(rc_morph_dilate_line_9x1_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_line_13x1_p_bin, 1)
void
rc_morph_erode_line_13x1_p_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height)
{
    int dim6 = src_dim*6;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_LINE_13X1_P,
                      RC_UNROLL(rc_morph_erode_line_13x1_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_line_13x1_p_bin, 1)
void
rc_morph_dilate_line_13x1_p_bin(uint8_t *restrict dst, int dst_dim,
                                const uint8_t *restrict src, int src_dim,
                                int width, int height)
{
    int dim6 = src_dim*6;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_LINE_13X1_P,
                      RC_UNROLL(rc_morph_dilate_line_13x1_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_line_15x1_p_bin, 1)
void
rc_morph_erode_line_15x1_p_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height)
{
    int dim7 = src_dim*7;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_LINE_15X1_P,
                      RC_UNROLL(rc_morph_erode_line_15x1_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_line_15x1_p_bin, 1)
void
rc_morph_dilate_line_15x1_p_bin(uint8_t *restrict dst, int dst_dim,
                                const uint8_t *restrict src, int src_dim,
                                int width, int height)
{
    int dim7 = src_dim*7;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_LINE_15X1_P,
                      RC_UNROLL(rc_morph_dilate_line_15x1_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_line_17x1_p_bin, 1)
void
rc_morph_erode_line_17x1_p_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height)
{
    int dim8 = src_dim*8;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_LINE_17X1_P,
                      RC_UNROLL(rc_morph_erode_line_17x1_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_line_17x1_p_bin, 1)
void
rc_morph_dilate_line_17x1_p_bin(uint8_t *restrict dst, int dst_dim,
                                const uint8_t *restrict src, int src_dim,
                                int width, int height)
{
    int dim8 = src_dim*8;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_LINE_17X1_P,
                      RC_UNROLL(rc_morph_dilate_line_17x1_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_line_25x1_p_bin, 1)
void
rc_morph_erode_line_25x1_p_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height)
{
    int dim12 = src_dim*12;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_LINE_25X1_P,
                      RC_UNROLL(rc_morph_erode_line_25x1_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_line_25x1_p_bin, 1)
void
rc_morph_dilate_line_25x1_p_bin(uint8_t *restrict dst, int dst_dim,
                                const uint8_t *restrict src, int src_dim,
                                int width, int height)
{
    int dim12 = src_dim*12;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_LINE_25X1_P,
                      RC_UNROLL(rc_morph_dilate_line_25x1_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_line_29x1_p_bin, 1)
void
rc_morph_erode_line_29x1_p_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height)
{
    int dim14 = src_dim*14;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_LINE_29X1_P,
                      RC_UNROLL(rc_morph_erode_line_29x1_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_line_29x1_p_bin, 1)
void
rc_morph_dilate_line_29x1_p_bin(uint8_t *restrict dst, int dst_dim,
                                const uint8_t *restrict src, int src_dim,
                                int width, int height)
{
    int dim14 = src_dim*14;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_LINE_29X1_P,
                      RC_UNROLL(rc_morph_dilate_line_29x1_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_line_31x1_p_bin, 1)
void
rc_morph_erode_line_31x1_p_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height)
{
    int dim15 = src_dim*15;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_LINE_31X1_P,
                      RC_UNROLL(rc_morph_erode_line_31x1_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_line_31x1_p_bin, 1)
void
rc_morph_dilate_line_31x1_p_bin(uint8_t *restrict dst, int dst_dim,
                                const uint8_t *restrict src, int src_dim,
                                int width, int height)
{
    int dim15 = src_dim*15;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_LINE_31X1_P,
                      RC_UNROLL(rc_morph_dilate_line_31x1_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_square_2x2_bin, 1)
void
rc_morph_erode_square_2x2_bin(uint8_t *restrict dst, int dst_dim,
                              const uint8_t *restrict src, int src_dim,
                              int width, int height)
{
    int dim1 = src_dim*1;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_SQUARE_2X2,
                      RC_UNROLL(rc_morph_erode_square_2x2_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_square_2x2_bin, 1)
void
rc_morph_dilate_square_2x2_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height)
{
    int dim1 = src_dim*1;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_SQUARE_2X2,
                      RC_UNROLL(rc_morph_dilate_square_2x2_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_square_3x3_bin, 1)
void
rc_morph_erode_square_3x3_bin(uint8_t *restrict dst, int dst_dim,
                              const uint8_t *restrict src, int src_dim,
                              int width, int height)
{
    int dim1 = src_dim*1;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_SQUARE_3X3,
                      RC_UNROLL(rc_morph_erode_square_3x3_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_square_3x3_bin, 1)
void
rc_morph_dilate_square_3x3_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height)
{
    int dim1 = src_dim*1;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_SQUARE_3X3,
                      RC_UNROLL(rc_morph_dilate_square_3x3_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_square_3x3_p_bin, 1)
void
rc_morph_erode_square_3x3_p_bin(uint8_t *restrict dst, int dst_dim,
                                const uint8_t *restrict src, int src_dim,
                                int width, int height)
{
    int dim1 = src_dim*1;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_SQUARE_3X3_P,
                      RC_UNROLL(rc_morph_erode_square_3x3_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_square_3x3_p_bin, 1)
void
rc_morph_dilate_square_3x3_p_bin(uint8_t *restrict dst, int dst_dim,
                                 const uint8_t *restrict src, int src_dim,
                                 int width, int height)
{
    int dim1 = src_dim*1;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_SQUARE_3X3_P,
                      RC_UNROLL(rc_morph_dilate_square_3x3_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_diamond_3x3_bin, 1)
void
rc_morph_erode_diamond_3x3_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height)
{
    int dim1 = src_dim*1;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_DIAMOND_3X3,
                      RC_UNROLL(rc_morph_erode_diamond_3x3_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_diamond_3x3_bin, 1)
void
rc_morph_dilate_diamond_3x3_bin(uint8_t *restrict dst, int dst_dim,
                                const uint8_t *restrict src, int src_dim,
                                int width, int height)
{
    int dim1 = src_dim*1;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_DIAMOND_3X3,
                      RC_UNROLL(rc_morph_dilate_diamond_3x3_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_diamond_3x3_p_bin, 1)
void
rc_morph_erode_diamond_3x3_p_bin(uint8_t *restrict dst, int dst_dim,
                                 const uint8_t *restrict src, int src_dim,
                                 int width, int height)
{
    int dim1 = src_dim*1;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_DIAMOND_3X3_P,
                      RC_UNROLL(rc_morph_erode_diamond_3x3_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_diamond_3x3_p_bin, 1)
void
rc_morph_dilate_diamond_3x3_p_bin(uint8_t *restrict dst, int dst_dim,
                                  const uint8_t *restrict src, int src_dim,
                                  int width, int height)
{
    int dim1 = src_dim*1;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_DIAMOND_3X3_P,
                      RC_UNROLL(rc_morph_dilate_diamond_3x3_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_diamond_5x5_p_bin, 1)
void
rc_morph_erode_diamond_5x5_p_bin(uint8_t *restrict dst, int dst_dim,
                                 const uint8_t *restrict src, int src_dim,
                                 int width, int height)
{
    int dim2 = src_dim*2;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_DIAMOND_5X5_P,
                      RC_UNROLL(rc_morph_erode_diamond_5x5_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_diamond_5x5_p_bin, 1)
void
rc_morph_dilate_diamond_5x5_p_bin(uint8_t *restrict dst, int dst_dim,
                                  const uint8_t *restrict src, int src_dim,
                                  int width, int height)
{
    int dim2 = src_dim*2;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_DIAMOND_5X5_P,
                      RC_UNROLL(rc_morph_dilate_diamond_5x5_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_diamond_7x7_p_bin, 1)
void
rc_morph_erode_diamond_7x7_p_bin(uint8_t *restrict dst, int dst_dim,
                                 const uint8_t *restrict src, int src_dim,
                                 int width, int height)
{
    int dim3 = src_dim*3;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_DIAMOND_7X7_P,
                      RC_UNROLL(rc_morph_erode_diamond_7x7_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_diamond_7x7_p_bin, 1)
void
rc_morph_dilate_diamond_7x7_p_bin(uint8_t *restrict dst, int dst_dim,
                                  const uint8_t *restrict src, int src_dim,
                                  int width, int height)
{
    int dim3 = src_dim*3;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_DIAMOND_7X7_P,
                      RC_UNROLL(rc_morph_dilate_diamond_7x7_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_diamond_9x9_p_bin, 1)
void
rc_morph_erode_diamond_9x9_p_bin(uint8_t *restrict dst, int dst_dim,
                                 const uint8_t *restrict src, int src_dim,
                                 int width, int height)
{
    int dim4 = src_dim*4;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_DIAMOND_9X9_P,
                      RC_UNROLL(rc_morph_erode_diamond_9x9_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_diamond_9x9_p_bin, 1)
void
rc_morph_dilate_diamond_9x9_p_bin(uint8_t *restrict dst, int dst_dim,
                                  const uint8_t *restrict src, int src_dim,
                                  int width, int height)
{
    int dim4 = src_dim*4;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_DIAMOND_9X9_P,
                      RC_UNROLL(rc_morph_dilate_diamond_9x9_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_diamond_13x13_p_bin, 1)
void
rc_morph_erode_diamond_13x13_p_bin(uint8_t *restrict dst, int dst_dim,
                                   const uint8_t *restrict src, int src_dim,
                                   int width, int height)
{
    int dim6 = src_dim*6;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_DIAMOND_13X13_P,
                      RC_UNROLL(rc_morph_erode_diamond_13x13_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_diamond_13x13_p_bin, 1)
void
rc_morph_dilate_diamond_13x13_p_bin(uint8_t *restrict dst, int dst_dim,
                                    const uint8_t *restrict src, int src_dim,
                                    int width, int height)
{
    int dim6 = src_dim*6;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_DIAMOND_13X13_P,
                      RC_UNROLL(rc_morph_dilate_diamond_13x13_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_diamond_15x15_p_bin, 1)
void
rc_morph_erode_diamond_15x15_p_bin(uint8_t *restrict dst, int dst_dim,
                                   const uint8_t *restrict src, int src_dim,
                                   int width, int height)
{
    int dim7 = src_dim*7;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_DIAMOND_15X15_P,
                      RC_UNROLL(rc_morph_erode_diamond_15x15_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_diamond_15x15_p_bin, 1)
void
rc_morph_dilate_diamond_15x15_p_bin(uint8_t *restrict dst, int dst_dim,
                                    const uint8_t *restrict src, int src_dim,
                                    int width, int height)
{
    int dim7 = src_dim*7;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_DIAMOND_15X15_P,
                      RC_UNROLL(rc_morph_dilate_diamond_15x15_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_diamond_17x17_p_bin, 1)
void
rc_morph_erode_diamond_17x17_p_bin(uint8_t *restrict dst, int dst_dim,
                                   const uint8_t *restrict src, int src_dim,
                                   int width, int height)
{
    int dim8 = src_dim*8;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_DIAMOND_17X17_P,
                      RC_UNROLL(rc_morph_erode_diamond_17x17_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_diamond_17x17_p_bin, 1)
void
rc_morph_dilate_diamond_17x17_p_bin(uint8_t *restrict dst, int dst_dim,
                                    const uint8_t *restrict src, int src_dim,
                                    int width, int height)
{
    int dim8 = src_dim*8;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_DIAMOND_17X17_P,
                      RC_UNROLL(rc_morph_dilate_diamond_17x17_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_diamond_25x25_p_bin, 1)
void
rc_morph_erode_diamond_25x25_p_bin(uint8_t *restrict dst, int dst_dim,
                                   const uint8_t *restrict src, int src_dim,
                                   int width, int height)
{
    int dim12 = src_dim*12;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_DIAMOND_25X25_P,
                      RC_UNROLL(rc_morph_erode_diamond_25x25_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_diamond_25x25_p_bin, 1)
void
rc_morph_dilate_diamond_25x25_p_bin(uint8_t *restrict dst, int dst_dim,
                                    const uint8_t *restrict src, int src_dim,
                                    int width, int height)
{
    int dim12 = src_dim*12;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_DIAMOND_25X25_P,
                      RC_UNROLL(rc_morph_dilate_diamond_25x25_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_diamond_29x29_p_bin, 1)
void
rc_morph_erode_diamond_29x29_p_bin(uint8_t *restrict dst, int dst_dim,
                                   const uint8_t *restrict src, int src_dim,
                                   int width, int height)
{
    int dim14 = src_dim*14;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_DIAMOND_29X29_P,
                      RC_UNROLL(rc_morph_erode_diamond_29x29_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_diamond_29x29_p_bin, 1)
void
rc_morph_dilate_diamond_29x29_p_bin(uint8_t *restrict dst, int dst_dim,
                                    const uint8_t *restrict src, int src_dim,
                                    int width, int height)
{
    int dim14 = src_dim*14;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_DIAMOND_29X29_P,
                      RC_UNROLL(rc_morph_dilate_diamond_29x29_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_diamond_31x31_p_bin, 1)
void
rc_morph_erode_diamond_31x31_p_bin(uint8_t *restrict dst, int dst_dim,
                                   const uint8_t *restrict src, int src_dim,
                                   int width, int height)
{
    int dim15 = src_dim*15;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_DIAMOND_31X31_P,
                      RC_UNROLL(rc_morph_erode_diamond_31x31_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_diamond_31x31_p_bin, 1)
void
rc_morph_dilate_diamond_31x31_p_bin(uint8_t *restrict dst, int dst_dim,
                                    const uint8_t *restrict src, int src_dim,
                                    int width, int height)
{
    int dim15 = src_dim*15;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_DIAMOND_31X31_P,
                      RC_UNROLL(rc_morph_dilate_diamond_31x31_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_octagon_5x5_p_bin, 1)
void
rc_morph_erode_octagon_5x5_p_bin(uint8_t *restrict dst, int dst_dim,
                                 const uint8_t *restrict src, int src_dim,
                                 int width, int height)
{
    int dim1 = src_dim*1;
    int dim2 = src_dim*2;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_OCTAGON_5X5_P,
                      RC_UNROLL(rc_morph_erode_octagon_5x5_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_octagon_5x5_p_bin, 1)
void
rc_morph_dilate_octagon_5x5_p_bin(uint8_t *restrict dst, int dst_dim,
                                  const uint8_t *restrict src, int src_dim,
                                  int width, int height)
{
    int dim1 = src_dim*1;
    int dim2 = src_dim*2;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_OCTAGON_5X5_P,
                      RC_UNROLL(rc_morph_dilate_octagon_5x5_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_octagon_7x7_p_bin, 1)
void
rc_morph_erode_octagon_7x7_p_bin(uint8_t *restrict dst, int dst_dim,
                                 const uint8_t *restrict src, int src_dim,
                                 int width, int height)
{
    int dim1 = src_dim*1;
    int dim3 = src_dim*3;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_OCTAGON_7X7_P,
                      RC_UNROLL(rc_morph_erode_octagon_7x7_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_octagon_7x7_p_bin, 1)
void
rc_morph_dilate_octagon_7x7_p_bin(uint8_t *restrict dst, int dst_dim,
                                  const uint8_t *restrict src, int src_dim,
                                  int width, int height)
{
    int dim1 = src_dim*1;
    int dim3 = src_dim*3;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_OCTAGON_7X7_P,
                      RC_UNROLL(rc_morph_dilate_octagon_7x7_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_octagon_9x9_p_bin, 1)
void
rc_morph_erode_octagon_9x9_p_bin(uint8_t *restrict dst, int dst_dim,
                                 const uint8_t *restrict src, int src_dim,
                                 int width, int height)
{
    int dim2 = src_dim*2;
    int dim4 = src_dim*4;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_OCTAGON_9X9_P,
                      RC_UNROLL(rc_morph_erode_octagon_9x9_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_octagon_9x9_p_bin, 1)
void
rc_morph_dilate_octagon_9x9_p_bin(uint8_t *restrict dst, int dst_dim,
                                  const uint8_t *restrict src, int src_dim,
                                  int width, int height)
{
    int dim2 = src_dim*2;
    int dim4 = src_dim*4;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_OCTAGON_9X9_P,
                      RC_UNROLL(rc_morph_dilate_octagon_9x9_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_octagon_13x13_p_bin, 1)
void
rc_morph_erode_octagon_13x13_p_bin(uint8_t *restrict dst, int dst_dim,
                                   const uint8_t *restrict src, int src_dim,
                                   int width, int height)
{
    int dim2 = src_dim*2;
    int dim6 = src_dim*6;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_OCTAGON_13X13_P,
                      RC_UNROLL(rc_morph_erode_octagon_13x13_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_octagon_13x13_p_bin, 1)
void
rc_morph_dilate_octagon_13x13_p_bin(uint8_t *restrict dst, int dst_dim,
                                    const uint8_t *restrict src, int src_dim,
                                    int width, int height)
{
    int dim2 = src_dim*2;
    int dim6 = src_dim*6;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_OCTAGON_13X13_P,
                      RC_UNROLL(rc_morph_dilate_octagon_13x13_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_octagon_15x15_p_bin, 1)
void
rc_morph_erode_octagon_15x15_p_bin(uint8_t *restrict dst, int dst_dim,
                                   const uint8_t *restrict src, int src_dim,
                                   int width, int height)
{
    int dim3 = src_dim*3;
    int dim7 = src_dim*7;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_OCTAGON_15X15_P,
                      RC_UNROLL(rc_morph_erode_octagon_15x15_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_octagon_15x15_p_bin, 1)
void
rc_morph_dilate_octagon_15x15_p_bin(uint8_t *restrict dst, int dst_dim,
                                    const uint8_t *restrict src, int src_dim,
                                    int width, int height)
{
    int dim3 = src_dim*3;
    int dim7 = src_dim*7;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_OCTAGON_15X15_P,
                      RC_UNROLL(rc_morph_dilate_octagon_15x15_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_octagon_17x17_p_bin, 1)
void
rc_morph_erode_octagon_17x17_p_bin(uint8_t *restrict dst, int dst_dim,
                                   const uint8_t *restrict src, int src_dim,
                                   int width, int height)
{
    int dim3 = src_dim*3;
    int dim8 = src_dim*8;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_OCTAGON_17X17_P,
                      RC_UNROLL(rc_morph_erode_octagon_17x17_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_octagon_17x17_p_bin, 1)
void
rc_morph_dilate_octagon_17x17_p_bin(uint8_t *restrict dst, int dst_dim,
                                    const uint8_t *restrict src, int src_dim,
                                    int width, int height)
{
    int dim3 = src_dim*3;
    int dim8 = src_dim*8;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_OCTAGON_17X17_P,
                      RC_UNROLL(rc_morph_dilate_octagon_17x17_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_octagon_25x25_p_bin, 1)
void
rc_morph_erode_octagon_25x25_p_bin(uint8_t *restrict dst, int dst_dim,
                                   const uint8_t *restrict src, int src_dim,
                                   int width, int height)
{
    int dim5 = src_dim*5;
    int dim12 = src_dim*12;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_OCTAGON_25X25_P,
                      RC_UNROLL(rc_morph_erode_octagon_25x25_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_octagon_25x25_p_bin, 1)
void
rc_morph_dilate_octagon_25x25_p_bin(uint8_t *restrict dst, int dst_dim,
                                    const uint8_t *restrict src, int src_dim,
                                    int width, int height)
{
    int dim5 = src_dim*5;
    int dim12 = src_dim*12;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_OCTAGON_25X25_P,
                      RC_UNROLL(rc_morph_dilate_octagon_25x25_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_octagon_29x29_p_bin, 1)
void
rc_morph_erode_octagon_29x29_p_bin(uint8_t *restrict dst, int dst_dim,
                                   const uint8_t *restrict src, int src_dim,
                                   int width, int height)
{
    int dim6 = src_dim*6;
    int dim14 = src_dim*14;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_OCTAGON_29X29_P,
                      RC_UNROLL(rc_morph_erode_octagon_29x29_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_octagon_29x29_p_bin, 1)
void
rc_morph_dilate_octagon_29x29_p_bin(uint8_t *restrict dst, int dst_dim,
                                    const uint8_t *restrict src, int src_dim,
                                    int width, int height)
{
    int dim6 = src_dim*6;
    int dim14 = src_dim*14;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_OCTAGON_29X29_P,
                      RC_UNROLL(rc_morph_dilate_octagon_29x29_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_octagon_31x31_p_bin, 1)
void
rc_morph_erode_octagon_31x31_p_bin(uint8_t *restrict dst, int dst_dim,
                                   const uint8_t *restrict src, int src_dim,
                                   int width, int height)
{
    int dim6 = src_dim*6;
    int dim15 = src_dim*15;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_OCTAGON_31X31_P,
                      RC_UNROLL(rc_morph_erode_octagon_31x31_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_octagon_31x31_p_bin, 1)
void
rc_morph_dilate_octagon_31x31_p_bin(uint8_t *restrict dst, int dst_dim,
                                    const uint8_t *restrict src, int src_dim,
                                    int width, int height)
{
    int dim6 = src_dim*6;
    int dim15 = src_dim*15;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_OCTAGON_31X31_P,
                      RC_UNROLL(rc_morph_dilate_octagon_31x31_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_disc_7x7_bin, 1)
void
rc_morph_erode_disc_7x7_bin(uint8_t *restrict dst, int dst_dim,
                            const uint8_t *restrict src, int src_dim,
                            int width, int height)
{
    int dim1 = src_dim*1;
    int dim2 = src_dim*2;
    int dim3 = src_dim*3;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_DISC_7X7,
                      RC_UNROLL(rc_morph_erode_disc_7x7_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_disc_7x7_bin, 1)
void
rc_morph_dilate_disc_7x7_bin(uint8_t *restrict dst, int dst_dim,
                             const uint8_t *restrict src, int src_dim,
                             int width, int height)
{
    int dim1 = src_dim*1;
    int dim2 = src_dim*2;
    int dim3 = src_dim*3;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_DISC_7X7,
                      RC_UNROLL(rc_morph_dilate_disc_7x7_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_disc_7x7_p_bin, 1)
void
rc_morph_erode_disc_7x7_p_bin(uint8_t *restrict dst, int dst_dim,
                              const uint8_t *restrict src, int src_dim,
                              int width, int height)
{
    int dim2 = src_dim*2;
    int dim3 = src_dim*3;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_DISC_7X7_P,
                      RC_UNROLL(rc_morph_erode_disc_7x7_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_disc_7x7_p_bin, 1)
void
rc_morph_dilate_disc_7x7_p_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height)
{
    int dim2 = src_dim*2;
    int dim3 = src_dim*3;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_DISC_7X7_P,
                      RC_UNROLL(rc_morph_dilate_disc_7x7_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_disc_9x9_p_bin, 1)
void
rc_morph_erode_disc_9x9_p_bin(uint8_t *restrict dst, int dst_dim,
                              const uint8_t *restrict src, int src_dim,
                              int width, int height)
{
    int dim3 = src_dim*3;
    int dim4 = src_dim*4;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_DISC_9X9_P,
                      RC_UNROLL(rc_morph_erode_disc_9x9_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_disc_9x9_p_bin, 1)
void
rc_morph_dilate_disc_9x9_p_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height)
{
    int dim3 = src_dim*3;
    int dim4 = src_dim*4;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_DISC_9X9_P,
                      RC_UNROLL(rc_morph_dilate_disc_9x9_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_disc_11x11_p_bin, 1)
void
rc_morph_erode_disc_11x11_p_bin(uint8_t *restrict dst, int dst_dim,
                                const uint8_t *restrict src, int src_dim,
                                int width, int height)
{
    int dim3 = src_dim*3;
    int dim4 = src_dim*4;
    int dim5 = src_dim*5;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_DISC_11X11_P,
                      RC_UNROLL(rc_morph_erode_disc_11x11_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_disc_11x11_p_bin, 1)
void
rc_morph_dilate_disc_11x11_p_bin(uint8_t *restrict dst, int dst_dim,
                                 const uint8_t *restrict src, int src_dim,
                                 int width, int height)
{
    int dim3 = src_dim*3;
    int dim4 = src_dim*4;
    int dim5 = src_dim*5;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_DISC_11X11_P,
                      RC_UNROLL(rc_morph_dilate_disc_11x11_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_disc_13x13_p_bin, 1)
void
rc_morph_erode_disc_13x13_p_bin(uint8_t *restrict dst, int dst_dim,
                                const uint8_t *restrict src, int src_dim,
                                int width, int height)
{
    int dim3 = src_dim*3;
    int dim4 = src_dim*4;
    int dim5 = src_dim*5;
    int dim6 = src_dim*6;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_DISC_13X13_P,
                      RC_UNROLL(rc_morph_erode_disc_13x13_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_disc_13x13_p_bin, 1)
void
rc_morph_dilate_disc_13x13_p_bin(uint8_t *restrict dst, int dst_dim,
                                 const uint8_t *restrict src, int src_dim,
                                 int width, int height)
{
    int dim3 = src_dim*3;
    int dim4 = src_dim*4;
    int dim5 = src_dim*5;
    int dim6 = src_dim*6;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_DISC_13X13_P,
                      RC_UNROLL(rc_morph_dilate_disc_13x13_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_disc_15x15_p_bin, 1)
void
rc_morph_erode_disc_15x15_p_bin(uint8_t *restrict dst, int dst_dim,
                                const uint8_t *restrict src, int src_dim,
                                int width, int height)
{
    int dim3 = src_dim*3;
    int dim4 = src_dim*4;
    int dim6 = src_dim*6;
    int dim7 = src_dim*7;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_DISC_15X15_P,
                      RC_UNROLL(rc_morph_erode_disc_15x15_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_disc_15x15_p_bin, 1)
void
rc_morph_dilate_disc_15x15_p_bin(uint8_t *restrict dst, int dst_dim,
                                 const uint8_t *restrict src, int src_dim,
                                 int width, int height)
{
    int dim3 = src_dim*3;
    int dim4 = src_dim*4;
    int dim6 = src_dim*6;
    int dim7 = src_dim*7;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_DISC_15X15_P,
                      RC_UNROLL(rc_morph_dilate_disc_15x15_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_disc_17x17_p_bin, 1)
void
rc_morph_erode_disc_17x17_p_bin(uint8_t *restrict dst, int dst_dim,
                                const uint8_t *restrict src, int src_dim,
                                int width, int height)
{
    int dim4 = src_dim*4;
    int dim5 = src_dim*5;
    int dim7 = src_dim*7;
    int dim8 = src_dim*8;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_DISC_17X17_P,
                      RC_UNROLL(rc_morph_erode_disc_17x17_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_disc_17x17_p_bin, 1)
void
rc_morph_dilate_disc_17x17_p_bin(uint8_t *restrict dst, int dst_dim,
                                 const uint8_t *restrict src, int src_dim,
                                 int width, int height)
{
    int dim4 = src_dim*4;
    int dim5 = src_dim*5;
    int dim7 = src_dim*7;
    int dim8 = src_dim*8;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_DISC_17X17_P,
                      RC_UNROLL(rc_morph_dilate_disc_17x17_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_disc_19x19_p_bin, 1)
void
rc_morph_erode_disc_19x19_p_bin(uint8_t *restrict dst, int dst_dim,
                                const uint8_t *restrict src, int src_dim,
                                int width, int height)
{
    int dim4 = src_dim*4;
    int dim5 = src_dim*5;
    int dim8 = src_dim*8;
    int dim9 = src_dim*9;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_DISC_19X19_P,
                      RC_UNROLL(rc_morph_erode_disc_19x19_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_disc_19x19_p_bin, 1)
void
rc_morph_dilate_disc_19x19_p_bin(uint8_t *restrict dst, int dst_dim,
                                 const uint8_t *restrict src, int src_dim,
                                 int width, int height)
{
    int dim4 = src_dim*4;
    int dim5 = src_dim*5;
    int dim8 = src_dim*8;
    int dim9 = src_dim*9;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_DISC_19X19_P,
                      RC_UNROLL(rc_morph_dilate_disc_19x19_p_bin));
}
#endif


#if RC_IMPL(rc_morph_erode_disc_25x25_p_bin, 1)
void
rc_morph_erode_disc_25x25_p_bin(uint8_t *restrict dst, int dst_dim,
                                const uint8_t *restrict src, int src_dim,
                                int width, int height)
{
    int dim5 = src_dim*5;
    int dim6 = src_dim*6;
    int dim7 = src_dim*7;
    int dim10 = src_dim*10;
    int dim11 = src_dim*11;
    int dim12 = src_dim*12;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_ERODE_DISC_25X25_P,
                      RC_UNROLL(rc_morph_erode_disc_25x25_p_bin));
}
#endif


#if RC_IMPL(rc_morph_dilate_disc_25x25_p_bin, 1)
void
rc_morph_dilate_disc_25x25_p_bin(uint8_t *restrict dst, int dst_dim,
                                 const uint8_t *restrict src, int src_dim,
                                 int width, int height)
{
    int dim5 = src_dim*5;
    int dim6 = src_dim*6;
    int dim7 = src_dim*7;
    int dim10 = src_dim*10;
    int dim11 = src_dim*11;
    int dim12 = src_dim*12;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_DILATE_DISC_25X25_P,
                      RC_UNROLL(rc_morph_dilate_disc_25x25_p_bin));
}
#endif


#if RC_IMPL(rc_morph_hmt_golay_l_3x3_c48_r0_bin, 1)
void
rc_morph_hmt_golay_l_3x3_c48_r0_bin(uint8_t *restrict dst, int dst_dim,
                                    const uint8_t *restrict src, int src_dim,
                                    int width, int height)
{
    int dim1 = src_dim*1;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_HMT_GOLAY_L_3X3_C48_R0,
                      RC_UNROLL(rc_morph_hmt_golay_l_3x3_c48_r0_bin));
}
#endif


#if RC_IMPL(rc_morph_hmt_golay_l_3x3_c48_r90_bin, 1)
void
rc_morph_hmt_golay_l_3x3_c48_r90_bin(uint8_t *restrict dst, int dst_dim,
                                     const uint8_t *restrict src, int src_dim,
                                     int width, int height)
{
    int dim1 = src_dim*1;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_HMT_GOLAY_L_3X3_C48_R90,
                      RC_UNROLL(rc_morph_hmt_golay_l_3x3_c48_r90_bin));
}
#endif


#if RC_IMPL(rc_morph_hmt_golay_l_3x3_c48_r180_bin, 1)
void
rc_morph_hmt_golay_l_3x3_c48_r180_bin(uint8_t *restrict dst, int dst_dim,
                                      const uint8_t *restrict src, int src_dim,
                                      int width, int height)
{
    int dim1 = src_dim*1;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_HMT_GOLAY_L_3X3_C48_R180,
                      RC_UNROLL(rc_morph_hmt_golay_l_3x3_c48_r180_bin));
}
#endif


#if RC_IMPL(rc_morph_hmt_golay_l_3x3_c48_r270_bin, 1)
void
rc_morph_hmt_golay_l_3x3_c48_r270_bin(uint8_t *restrict dst, int dst_dim,
                                      const uint8_t *restrict src, int src_dim,
                                      int width, int height)
{
    int dim1 = src_dim*1;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_HMT_GOLAY_L_3X3_C48_R270,
                      RC_UNROLL(rc_morph_hmt_golay_l_3x3_c48_r270_bin));
}
#endif


#if RC_IMPL(rc_morph_hmt_golay_l_3x3_c4_r45_bin, 1)
void
rc_morph_hmt_golay_l_3x3_c4_r45_bin(uint8_t *restrict dst, int dst_dim,
                                    const uint8_t *restrict src, int src_dim,
                                    int width, int height)
{
    int dim1 = src_dim*1;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_HMT_GOLAY_L_3X3_C4_R45,
                      RC_UNROLL(rc_morph_hmt_golay_l_3x3_c4_r45_bin));
}
#endif


#if RC_IMPL(rc_morph_hmt_golay_l_3x3_c4_r135_bin, 1)
void
rc_morph_hmt_golay_l_3x3_c4_r135_bin(uint8_t *restrict dst, int dst_dim,
                                     const uint8_t *restrict src, int src_dim,
                                     int width, int height)
{
    int dim1 = src_dim*1;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_HMT_GOLAY_L_3X3_C4_R135,
                      RC_UNROLL(rc_morph_hmt_golay_l_3x3_c4_r135_bin));
}
#endif


#if RC_IMPL(rc_morph_hmt_golay_l_3x3_c4_r225_bin, 1)
void
rc_morph_hmt_golay_l_3x3_c4_r225_bin(uint8_t *restrict dst, int dst_dim,
                                     const uint8_t *restrict src, int src_dim,
                                     int width, int height)
{
    int dim1 = src_dim*1;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_HMT_GOLAY_L_3X3_C4_R225,
                      RC_UNROLL(rc_morph_hmt_golay_l_3x3_c4_r225_bin));
}
#endif


#if RC_IMPL(rc_morph_hmt_golay_l_3x3_c4_r315_bin, 1)
void
rc_morph_hmt_golay_l_3x3_c4_r315_bin(uint8_t *restrict dst, int dst_dim,
                                     const uint8_t *restrict src, int src_dim,
                                     int width, int height)
{
    int dim1 = src_dim*1;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_HMT_GOLAY_L_3X3_C4_R315,
                      RC_UNROLL(rc_morph_hmt_golay_l_3x3_c4_r315_bin));
}
#endif


#if RC_IMPL(rc_morph_hmt_golay_l_3x3_c8_r45_bin, 1)
void
rc_morph_hmt_golay_l_3x3_c8_r45_bin(uint8_t *restrict dst, int dst_dim,
                                    const uint8_t *restrict src, int src_dim,
                                    int width, int height)
{
    int dim1 = src_dim*1;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_HMT_GOLAY_L_3X3_C8_R45,
                      RC_UNROLL(rc_morph_hmt_golay_l_3x3_c8_r45_bin));
}
#endif


#if RC_IMPL(rc_morph_hmt_golay_l_3x3_c8_r135_bin, 1)
void
rc_morph_hmt_golay_l_3x3_c8_r135_bin(uint8_t *restrict dst, int dst_dim,
                                     const uint8_t *restrict src, int src_dim,
                                     int width, int height)
{
    int dim1 = src_dim*1;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_HMT_GOLAY_L_3X3_C8_R135,
                      RC_UNROLL(rc_morph_hmt_golay_l_3x3_c8_r135_bin));
}
#endif


#if RC_IMPL(rc_morph_hmt_golay_l_3x3_c8_r225_bin, 1)
void
rc_morph_hmt_golay_l_3x3_c8_r225_bin(uint8_t *restrict dst, int dst_dim,
                                     const uint8_t *restrict src, int src_dim,
                                     int width, int height)
{
    int dim1 = src_dim*1;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_HMT_GOLAY_L_3X3_C8_R225,
                      RC_UNROLL(rc_morph_hmt_golay_l_3x3_c8_r225_bin));
}
#endif


#if RC_IMPL(rc_morph_hmt_golay_l_3x3_c8_r315_bin, 1)
void
rc_morph_hmt_golay_l_3x3_c8_r315_bin(uint8_t *restrict dst, int dst_dim,
                                     const uint8_t *restrict src, int src_dim,
                                     int width, int height)
{
    int dim1 = src_dim*1;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_HMT_GOLAY_L_3X3_C8_R315,
                      RC_UNROLL(rc_morph_hmt_golay_l_3x3_c8_r315_bin));
}
#endif


#if RC_IMPL(rc_morph_hmt_golay_e_3x3_c4_r0_bin, 1)
void
rc_morph_hmt_golay_e_3x3_c4_r0_bin(uint8_t *restrict dst, int dst_dim,
                                   const uint8_t *restrict src, int src_dim,
                                   int width, int height)
{
    int dim1 = src_dim*1;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_HMT_GOLAY_E_3X3_C4_R0,
                      RC_UNROLL(rc_morph_hmt_golay_e_3x3_c4_r0_bin));
}
#endif


#if RC_IMPL(rc_morph_hmt_golay_e_3x3_c4_r90_bin, 1)
void
rc_morph_hmt_golay_e_3x3_c4_r90_bin(uint8_t *restrict dst, int dst_dim,
                                    const uint8_t *restrict src, int src_dim,
                                    int width, int height)
{
    int dim1 = src_dim*1;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_HMT_GOLAY_E_3X3_C4_R90,
                      RC_UNROLL(rc_morph_hmt_golay_e_3x3_c4_r90_bin));
}
#endif


#if RC_IMPL(rc_morph_hmt_golay_e_3x3_c4_r180_bin, 1)
void
rc_morph_hmt_golay_e_3x3_c4_r180_bin(uint8_t *restrict dst, int dst_dim,
                                     const uint8_t *restrict src, int src_dim,
                                     int width, int height)
{
    int dim1 = src_dim*1;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_HMT_GOLAY_E_3X3_C4_R180,
                      RC_UNROLL(rc_morph_hmt_golay_e_3x3_c4_r180_bin));
}
#endif


#if RC_IMPL(rc_morph_hmt_golay_e_3x3_c4_r270_bin, 1)
void
rc_morph_hmt_golay_e_3x3_c4_r270_bin(uint8_t *restrict dst, int dst_dim,
                                     const uint8_t *restrict src, int src_dim,
                                     int width, int height)
{
    int dim1 = src_dim*1;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_HMT_GOLAY_E_3X3_C4_R270,
                      RC_UNROLL(rc_morph_hmt_golay_e_3x3_c4_r270_bin));
}
#endif


#if RC_IMPL(rc_morph_hmt_golay_e_3x3_c8_r0_bin, 1)
void
rc_morph_hmt_golay_e_3x3_c8_r0_bin(uint8_t *restrict dst, int dst_dim,
                                   const uint8_t *restrict src, int src_dim,
                                   int width, int height)
{
    int dim1 = src_dim*1;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_HMT_GOLAY_E_3X3_C8_R0,
                      RC_UNROLL(rc_morph_hmt_golay_e_3x3_c8_r0_bin));
}
#endif


#if RC_IMPL(rc_morph_hmt_golay_e_3x3_c8_r90_bin, 1)
void
rc_morph_hmt_golay_e_3x3_c8_r90_bin(uint8_t *restrict dst, int dst_dim,
                                    const uint8_t *restrict src, int src_dim,
                                    int width, int height)
{
    int dim1 = src_dim*1;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_HMT_GOLAY_E_3X3_C8_R90,
                      RC_UNROLL(rc_morph_hmt_golay_e_3x3_c8_r90_bin));
}
#endif


#if RC_IMPL(rc_morph_hmt_golay_e_3x3_c8_r180_bin, 1)
void
rc_morph_hmt_golay_e_3x3_c8_r180_bin(uint8_t *restrict dst, int dst_dim,
                                     const uint8_t *restrict src, int src_dim,
                                     int width, int height)
{
    int dim1 = src_dim*1;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_HMT_GOLAY_E_3X3_C8_R180,
                      RC_UNROLL(rc_morph_hmt_golay_e_3x3_c8_r180_bin));
}
#endif


#if RC_IMPL(rc_morph_hmt_golay_e_3x3_c8_r270_bin, 1)
void
rc_morph_hmt_golay_e_3x3_c8_r270_bin(uint8_t *restrict dst, int dst_dim,
                                     const uint8_t *restrict src, int src_dim,
                                     int width, int height)
{
    int dim1 = src_dim*1;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_HMT_GOLAY_E_3X3_C8_R270,
                      RC_UNROLL(rc_morph_hmt_golay_e_3x3_c8_r270_bin));
}
#endif


#if RC_IMPL(rc_morph_hmt_golay_e_3x3_c8_r45_bin, 1)
void
rc_morph_hmt_golay_e_3x3_c8_r45_bin(uint8_t *restrict dst, int dst_dim,
                                    const uint8_t *restrict src, int src_dim,
                                    int width, int height)
{
    int dim1 = src_dim*1;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_HMT_GOLAY_E_3X3_C8_R45,
                      RC_UNROLL(rc_morph_hmt_golay_e_3x3_c8_r45_bin));
}
#endif


#if RC_IMPL(rc_morph_hmt_golay_e_3x3_c8_r135_bin, 1)
void
rc_morph_hmt_golay_e_3x3_c8_r135_bin(uint8_t *restrict dst, int dst_dim,
                                     const uint8_t *restrict src, int src_dim,
                                     int width, int height)
{
    int dim1 = src_dim*1;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_HMT_GOLAY_E_3X3_C8_R135,
                      RC_UNROLL(rc_morph_hmt_golay_e_3x3_c8_r135_bin));
}
#endif


#if RC_IMPL(rc_morph_hmt_golay_e_3x3_c8_r225_bin, 1)
void
rc_morph_hmt_golay_e_3x3_c8_r225_bin(uint8_t *restrict dst, int dst_dim,
                                     const uint8_t *restrict src, int src_dim,
                                     int width, int height)
{
    int dim1 = src_dim*1;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_HMT_GOLAY_E_3X3_C8_R225,
                      RC_UNROLL(rc_morph_hmt_golay_e_3x3_c8_r225_bin));
}
#endif


#if RC_IMPL(rc_morph_hmt_golay_e_3x3_c8_r315_bin, 1)
void
rc_morph_hmt_golay_e_3x3_c8_r315_bin(uint8_t *restrict dst, int dst_dim,
                                     const uint8_t *restrict src, int src_dim,
                                     int width, int height)
{
    int dim1 = src_dim*1;
    RC_MORPH_TEMPLATE(dst, dst_dim, src, src_dim, width, height,
                      RC_MORPH_HMT_GOLAY_E_3X3_C8_R315,
                      RC_UNROLL(rc_morph_hmt_golay_e_3x3_c8_r315_bin));
}
#endif
