/*  Copyright (C) 2005-2010, Axis Communications AB, LUND, SWEDEN
 *
 *  This file is part of RAPP.
 *
 *  RAPP is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published
 *  by the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *  You can use the comments under either the terms of the GNU Lesser General
 *  Public License version 3 as published by the Free Software Foundation,
 *  either version 3 of the License or (at your option) any later version, or
 *  the GNU Free Documentation License version 1.3 or any later version
 *  published by the Free Software Foundation; with no Invariant Sections, no
 *  Front-Cover Texts, and no Back-Cover Texts.
 *  A copy of the license is included in the documentation section entitled
 *  "GNU Free Documentation License".
 *
 *  RAPP is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License and a copy of the GNU Free Documentation License along
 *  with RAPP. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *  @file   rapp_info.c
 *  @brief  RAPP build information string.
 */

#include "rappcompute.h"  /* RAPP Compute API */
#include "rapp_version.h" /* RAPP versioning  */
#include "rapp_info.h"    /* Info API         */


/*
 * -------------------------------------------------------------
 *  Constants
 * -------------------------------------------------------------
 */

/**
 *  The SIMD info string and RAPP_INFO_SIMD macro are generated by
 *  configure.ac, to avoid testing for e.g. __SSE2__ and writing "SSE2"
 *  when a generic backend is explicitly specified.
 */

/**
 *  The word (not vector) size info string.
 */
#if   RC_NATIVE_SIZE == 8
#define RAPP_INFO_SIZE "64"
#elif RC_NATIVE_SIZE == 4
#define RAPP_INFO_SIZE "32"
#elif RC_NATIVE_SIZE == 2
#define RAPP_INFO_SIZE "16"
#else
#error Unsupported RC_NATIVE_SIZE
#endif

/**
 *  The RAPP info string.
 */
#define RAPP_INFO                               \
    "RAPP "                                     \
    RAPP_INFO_VERSION(RAPP_MAJOR_VERSION,       \
                      RAPP_MINOR_VERSION) " "   \
    RAPP_INFO_SIZE "-bit "                      \
    RAPP_INFO_SIMD " built on "                 \
    __DATE__ " " __TIME__


/*
 * -------------------------------------------------------------
 *  Macros
 * -------------------------------------------------------------
 */

/**
 *  Stringify argument
 */
#define RAPP_INFO_STRING(x) #x

/**
 *  The version string
 */
#define RAPP_INFO_VERSION(major, minor) \
    RAPP_INFO_STRING(major) "." RAPP_INFO_STRING(minor)


/*
 * -------------------------------------------------------------
 *  Global variables
 * -------------------------------------------------------------
 */

/**
 *  The exported RAPP build information string.
 */
const char *rapp_info = RAPP_INFO;
