/*  Copyright (C) 2005-2010, Axis Communications AB, LUND, SWEDEN
 *
 *  This file is part of RAPP.
 *
 *  RAPP is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published
 *  by the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *  You can use the comments under either the terms of the GNU Lesser General
 *  Public License version 3 as published by the Free Software Foundation,
 *  either version 3 of the License or (at your option) any later version, or
 *  the GNU Free Documentation License version 1.3 or any later version
 *  published by the Free Software Foundation; with no Invariant Sections, no
 *  Front-Cover Texts, and no Back-Cover Texts.
 *  A copy of the license is included in the documentation section entitled
 *  "GNU Free Documentation License".
 *
 *  RAPP is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License and a copy of the GNU Free Documentation License along
 *  with RAPP. If not, see <http://www.gnu.org/licenses/>.
 */
/**
 *  @file   rc_morph_bin.h
 *  @author Auto-generated by autogen_morph_bin.py on Fri Feb  6 07:21:19 2009
 *  @brief  RAPP Compute layer binary morphology primitives.
 */

#ifndef RC_MORPH_BIN_H
#define RC_MORPH_BIN_H

#include <stdint.h>
#include "rc_export.h"

/**
 *  Erosion.
 *  1x2 filled horizontal line.
 *  Hit  = [[-1, 0], [0, 0]]
 */
RC_EXPORT void
rc_morph_erode_line_1x2_bin(uint8_t *restrict dst, int dst_dim,
                            const uint8_t *restrict src, int src_dim,
                            int width, int height);

/**
 *  Dilation.
 *  1x2 filled horizontal line.
 *  Hit  = [[-1, 0], [0, 0]]
 */
RC_EXPORT void
rc_morph_dilate_line_1x2_bin(uint8_t *restrict dst, int dst_dim,
                             const uint8_t *restrict src, int src_dim,
                             int width, int height);

/**
 *  Erosion.
 *  1x3 filled horizontal line.
 *  Hit  = [[-1, 0], [0, 0], [1, 0]]
 */
RC_EXPORT void
rc_morph_erode_line_1x3_bin(uint8_t *restrict dst, int dst_dim,
                            const uint8_t *restrict src, int src_dim,
                            int width, int height);

/**
 *  Dilation.
 *  1x3 filled horizontal line.
 *  Hit  = [[-1, 0], [0, 0], [1, 0]]
 */
RC_EXPORT void
rc_morph_dilate_line_1x3_bin(uint8_t *restrict dst, int dst_dim,
                             const uint8_t *restrict src, int src_dim,
                             int width, int height);

/**
 *  Erosion.
 *  1x3 horizontal line perimeter.
 *  Hit  = [[-1, 0], [1, 0]]
 */
RC_EXPORT void
rc_morph_erode_line_1x3_p_bin(uint8_t *restrict dst, int dst_dim,
                              const uint8_t *restrict src, int src_dim,
                              int width, int height);

/**
 *  Dilation.
 *  1x3 horizontal line perimeter.
 *  Hit  = [[-1, 0], [1, 0]]
 */
RC_EXPORT void
rc_morph_dilate_line_1x3_p_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height);

/**
 *  Erosion.
 *  1x5 horizontal line perimeter
 *  Hit  = [[-2, 0], [2, 0]]
 */
RC_EXPORT void
rc_morph_erode_line_1x5_p_bin(uint8_t *restrict dst, int dst_dim,
                              const uint8_t *restrict src, int src_dim,
                              int width, int height);

/**
 *  Dilation.
 *  1x5 horizontal line perimeter
 *  Hit  = [[-2, 0], [2, 0]]
 */
RC_EXPORT void
rc_morph_dilate_line_1x5_p_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height);

/**
 *  Erosion.
 *  1x7 horizontal line perimeter
 *  Hit  = [[-3, 0], [3, 0]]
 */
RC_EXPORT void
rc_morph_erode_line_1x7_p_bin(uint8_t *restrict dst, int dst_dim,
                              const uint8_t *restrict src, int src_dim,
                              int width, int height);

/**
 *  Dilation.
 *  1x7 horizontal line perimeter
 *  Hit  = [[-3, 0], [3, 0]]
 */
RC_EXPORT void
rc_morph_dilate_line_1x7_p_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height);

/**
 *  Erosion.
 *  1x7 horizontal line perimeter
 *  Hit  = [[-4, 0], [4, 0]]
 */
RC_EXPORT void
rc_morph_erode_line_1x9_p_bin(uint8_t *restrict dst, int dst_dim,
                              const uint8_t *restrict src, int src_dim,
                              int width, int height);

/**
 *  Dilation.
 *  1x7 horizontal line perimeter
 *  Hit  = [[-4, 0], [4, 0]]
 */
RC_EXPORT void
rc_morph_dilate_line_1x9_p_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height);

/**
 *  Erosion.
 *   1x13 horizontal line perimeter
 *  Hit  = [[-6, 0], [6, 0]]
 */
RC_EXPORT void
rc_morph_erode_line_1x13_p_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height);

/**
 *  Dilation.
 *   1x13 horizontal line perimeter
 *  Hit  = [[-6, 0], [6, 0]]
 */
RC_EXPORT void
rc_morph_dilate_line_1x13_p_bin(uint8_t *restrict dst, int dst_dim,
                                const uint8_t *restrict src, int src_dim,
                                int width, int height);

/**
 *  Erosion.
 *  1x15 horizontal line perimeter
 *  Hit  = [[-7, 0], [7, 0]]
 */
RC_EXPORT void
rc_morph_erode_line_1x15_p_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height);

/**
 *  Dilation.
 *  1x15 horizontal line perimeter
 *  Hit  = [[-7, 0], [7, 0]]
 */
RC_EXPORT void
rc_morph_dilate_line_1x15_p_bin(uint8_t *restrict dst, int dst_dim,
                                const uint8_t *restrict src, int src_dim,
                                int width, int height);

/**
 *  Erosion.
 *  1x17 horizontal line perimeter
 *  Hit  = [[-8, 0], [8, 0]]
 */
RC_EXPORT void
rc_morph_erode_line_1x17_p_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height);

/**
 *  Dilation.
 *  1x17 horizontal line perimeter
 *  Hit  = [[-8, 0], [8, 0]]
 */
RC_EXPORT void
rc_morph_dilate_line_1x17_p_bin(uint8_t *restrict dst, int dst_dim,
                                const uint8_t *restrict src, int src_dim,
                                int width, int height);

/**
 *  Erosion.
 *  1x25 horizontal line perimeter
 *  Hit  = [[-12, 0], [12, 0]]
 */
RC_EXPORT void
rc_morph_erode_line_1x25_p_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height);

/**
 *  Dilation.
 *  1x25 horizontal line perimeter
 *  Hit  = [[-12, 0], [12, 0]]
 */
RC_EXPORT void
rc_morph_dilate_line_1x25_p_bin(uint8_t *restrict dst, int dst_dim,
                                const uint8_t *restrict src, int src_dim,
                                int width, int height);

/**
 *  Erosion.
 *  1x29 horizontal line perimeter
 *  Hit  = [[-14, 0], [14, 0]]
 */
RC_EXPORT void
rc_morph_erode_line_1x29_p_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height);

/**
 *  Dilation.
 *  1x29 horizontal line perimeter
 *  Hit  = [[-14, 0], [14, 0]]
 */
RC_EXPORT void
rc_morph_dilate_line_1x29_p_bin(uint8_t *restrict dst, int dst_dim,
                                const uint8_t *restrict src, int src_dim,
                                int width, int height);

/**
 *  Erosion.
 *  1x31 horizontal line perimeter
 *  Hit  = [[-15, 0], [15, 0]]
 */
RC_EXPORT void
rc_morph_erode_line_1x31_p_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height);

/**
 *  Dilation.
 *  1x31 horizontal line perimeter
 *  Hit  = [[-15, 0], [15, 0]]
 */
RC_EXPORT void
rc_morph_dilate_line_1x31_p_bin(uint8_t *restrict dst, int dst_dim,
                                const uint8_t *restrict src, int src_dim,
                                int width, int height);

/**
 *  Erosion.
 *  2x1 filled vertical line.
 *  Hit  = [[0, -1], [0, 0]]
 */
RC_EXPORT void
rc_morph_erode_line_2x1_bin(uint8_t *restrict dst, int dst_dim,
                            const uint8_t *restrict src, int src_dim,
                            int width, int height);

/**
 *  Dilation.
 *  2x1 filled vertical line.
 *  Hit  = [[0, -1], [0, 0]]
 */
RC_EXPORT void
rc_morph_dilate_line_2x1_bin(uint8_t *restrict dst, int dst_dim,
                             const uint8_t *restrict src, int src_dim,
                             int width, int height);

/**
 *  Erosion.
 *  3x1 filled vertical line.
 *  Hit  = [[0, -1], [0, 0], [0, 1]]
 */
RC_EXPORT void
rc_morph_erode_line_3x1_bin(uint8_t *restrict dst, int dst_dim,
                            const uint8_t *restrict src, int src_dim,
                            int width, int height);

/**
 *  Dilation.
 *  3x1 filled vertical line.
 *  Hit  = [[0, -1], [0, 0], [0, 1]]
 */
RC_EXPORT void
rc_morph_dilate_line_3x1_bin(uint8_t *restrict dst, int dst_dim,
                             const uint8_t *restrict src, int src_dim,
                             int width, int height);

/**
 *  Erosion.
 *  3x1 vertical line perimeter.
 *  Hit  = [[0, -1], [0, 1]]
 */
RC_EXPORT void
rc_morph_erode_line_3x1_p_bin(uint8_t *restrict dst, int dst_dim,
                              const uint8_t *restrict src, int src_dim,
                              int width, int height);

/**
 *  Dilation.
 *  3x1 vertical line perimeter.
 *  Hit  = [[0, -1], [0, 1]]
 */
RC_EXPORT void
rc_morph_dilate_line_3x1_p_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height);

/**
 *  Erosion.
 *  5x1 vertical line perimeter
 *  Hit  = [[0, -2], [0, 2]]
 */
RC_EXPORT void
rc_morph_erode_line_5x1_p_bin(uint8_t *restrict dst, int dst_dim,
                              const uint8_t *restrict src, int src_dim,
                              int width, int height);

/**
 *  Dilation.
 *  5x1 vertical line perimeter
 *  Hit  = [[0, -2], [0, 2]]
 */
RC_EXPORT void
rc_morph_dilate_line_5x1_p_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height);

/**
 *  Erosion.
 *  7x1 vertical line perimeter
 *  Hit  = [[0, -3], [0, 3]]
 */
RC_EXPORT void
rc_morph_erode_line_7x1_p_bin(uint8_t *restrict dst, int dst_dim,
                              const uint8_t *restrict src, int src_dim,
                              int width, int height);

/**
 *  Dilation.
 *  7x1 vertical line perimeter
 *  Hit  = [[0, -3], [0, 3]]
 */
RC_EXPORT void
rc_morph_dilate_line_7x1_p_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height);

/**
 *  Erosion.
 *  9x1 vertical line perimeter
 *  Hit  = [[0, -4], [0, 4]]
 */
RC_EXPORT void
rc_morph_erode_line_9x1_p_bin(uint8_t *restrict dst, int dst_dim,
                              const uint8_t *restrict src, int src_dim,
                              int width, int height);

/**
 *  Dilation.
 *  9x1 vertical line perimeter
 *  Hit  = [[0, -4], [0, 4]]
 */
RC_EXPORT void
rc_morph_dilate_line_9x1_p_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height);

/**
 *  Erosion.
 *  13x1 vertical line perimeter
 *  Hit  = [[0, -6], [0, 6]]
 */
RC_EXPORT void
rc_morph_erode_line_13x1_p_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height);

/**
 *  Dilation.
 *  13x1 vertical line perimeter
 *  Hit  = [[0, -6], [0, 6]]
 */
RC_EXPORT void
rc_morph_dilate_line_13x1_p_bin(uint8_t *restrict dst, int dst_dim,
                                const uint8_t *restrict src, int src_dim,
                                int width, int height);

/**
 *  Erosion.
 *  15x1 vertical line perimeter
 *  Hit  = [[0, -7], [0, 7]]
 */
RC_EXPORT void
rc_morph_erode_line_15x1_p_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height);

/**
 *  Dilation.
 *  15x1 vertical line perimeter
 *  Hit  = [[0, -7], [0, 7]]
 */
RC_EXPORT void
rc_morph_dilate_line_15x1_p_bin(uint8_t *restrict dst, int dst_dim,
                                const uint8_t *restrict src, int src_dim,
                                int width, int height);

/**
 *  Erosion.
 *  17x1 vertical line perimeter
 *  Hit  = [[0, -8], [0, 8]]
 */
RC_EXPORT void
rc_morph_erode_line_17x1_p_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height);

/**
 *  Dilation.
 *  17x1 vertical line perimeter
 *  Hit  = [[0, -8], [0, 8]]
 */
RC_EXPORT void
rc_morph_dilate_line_17x1_p_bin(uint8_t *restrict dst, int dst_dim,
                                const uint8_t *restrict src, int src_dim,
                                int width, int height);

/**
 *  Erosion.
 *  25x1 vertical line perimeter
 *  Hit  = [[0, -12], [0, 12]]
 */
RC_EXPORT void
rc_morph_erode_line_25x1_p_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height);

/**
 *  Dilation.
 *  25x1 vertical line perimeter
 *  Hit  = [[0, -12], [0, 12]]
 */
RC_EXPORT void
rc_morph_dilate_line_25x1_p_bin(uint8_t *restrict dst, int dst_dim,
                                const uint8_t *restrict src, int src_dim,
                                int width, int height);

/**
 *  Erosion.
 *   29x1 vertical line perimeter
 *  Hit  = [[0, -14], [0, 14]]
 */
RC_EXPORT void
rc_morph_erode_line_29x1_p_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height);

/**
 *  Dilation.
 *   29x1 vertical line perimeter
 *  Hit  = [[0, -14], [0, 14]]
 */
RC_EXPORT void
rc_morph_dilate_line_29x1_p_bin(uint8_t *restrict dst, int dst_dim,
                                const uint8_t *restrict src, int src_dim,
                                int width, int height);

/**
 *  Erosion.
 *  31x1 vertical line perimeter
 *  Hit  = [[0, -15], [0, 15]]
 */
RC_EXPORT void
rc_morph_erode_line_31x1_p_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height);

/**
 *  Dilation.
 *  31x1 vertical line perimeter
 *  Hit  = [[0, -15], [0, 15]]
 */
RC_EXPORT void
rc_morph_dilate_line_31x1_p_bin(uint8_t *restrict dst, int dst_dim,
                                const uint8_t *restrict src, int src_dim,
                                int width, int height);

/**
 *  Erosion.
 *  2x2 filled square.
 *  Hit  = [[-1, -1], [0, -1], [-1, 0], [0, 0]]
 */
RC_EXPORT void
rc_morph_erode_square_2x2_bin(uint8_t *restrict dst, int dst_dim,
                              const uint8_t *restrict src, int src_dim,
                              int width, int height);

/**
 *  Dilation.
 *  2x2 filled square.
 *  Hit  = [[-1, -1], [0, -1], [-1, 0], [0, 0]]
 */
RC_EXPORT void
rc_morph_dilate_square_2x2_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height);

/**
 *  Erosion.
 *  3x3 filled square.
 *  Hit  = [[-1, -1], [0, -1], [1, -1], [-1, 0],
 *          [0, 0], [1, 0], [-1, 1], [0, 1],
 *          [1, 1]]
 */
RC_EXPORT void
rc_morph_erode_square_3x3_bin(uint8_t *restrict dst, int dst_dim,
                              const uint8_t *restrict src, int src_dim,
                              int width, int height);

/**
 *  Dilation.
 *  3x3 filled square.
 *  Hit  = [[-1, -1], [0, -1], [1, -1], [-1, 0],
 *          [0, 0], [1, 0], [-1, 1], [0, 1],
 *          [1, 1]]
 */
RC_EXPORT void
rc_morph_dilate_square_3x3_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height);

/**
 *  Erosion.
 *  3x3 square perimeter.
 *  Hit  = [[-1, -1], [1, -1], [-1, 1], [1, 1]]
 */
RC_EXPORT void
rc_morph_erode_square_3x3_p_bin(uint8_t *restrict dst, int dst_dim,
                                const uint8_t *restrict src, int src_dim,
                                int width, int height);

/**
 *  Dilation.
 *  3x3 square perimeter.
 *  Hit  = [[-1, -1], [1, -1], [-1, 1], [1, 1]]
 */
RC_EXPORT void
rc_morph_dilate_square_3x3_p_bin(uint8_t *restrict dst, int dst_dim,
                                 const uint8_t *restrict src, int src_dim,
                                 int width, int height);

/**
 *  Erosion.
 *  3x3 filled diamond.
 *  Hit  = [[0, -1], [-1, 0], [0, 0], [1, 0],
 *          [0, 1]]
 */
RC_EXPORT void
rc_morph_erode_diamond_3x3_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height);

/**
 *  Dilation.
 *  3x3 filled diamond.
 *  Hit  = [[0, -1], [-1, 0], [0, 0], [1, 0],
 *          [0, 1]]
 */
RC_EXPORT void
rc_morph_dilate_diamond_3x3_bin(uint8_t *restrict dst, int dst_dim,
                                const uint8_t *restrict src, int src_dim,
                                int width, int height);

/**
 *  Erosion.
 *  3x3 diamond perimeter.
 *  Hit  = [[0, -1], [-1, 0], [1, 0], [0, 1]]
 */
RC_EXPORT void
rc_morph_erode_diamond_3x3_p_bin(uint8_t *restrict dst, int dst_dim,
                                 const uint8_t *restrict src, int src_dim,
                                 int width, int height);

/**
 *  Dilation.
 *  3x3 diamond perimeter.
 *  Hit  = [[0, -1], [-1, 0], [1, 0], [0, 1]]
 */
RC_EXPORT void
rc_morph_dilate_diamond_3x3_p_bin(uint8_t *restrict dst, int dst_dim,
                                  const uint8_t *restrict src, int src_dim,
                                  int width, int height);

/**
 *  Erosion.
 *  5x5 diamond perimeter.
 *  Hit  = [[0, -2], [-2, 0], [2, 0], [0, 2]]
 */
RC_EXPORT void
rc_morph_erode_diamond_5x5_p_bin(uint8_t *restrict dst, int dst_dim,
                                 const uint8_t *restrict src, int src_dim,
                                 int width, int height);

/**
 *  Dilation.
 *  5x5 diamond perimeter.
 *  Hit  = [[0, -2], [-2, 0], [2, 0], [0, 2]]
 */
RC_EXPORT void
rc_morph_dilate_diamond_5x5_p_bin(uint8_t *restrict dst, int dst_dim,
                                  const uint8_t *restrict src, int src_dim,
                                  int width, int height);

/**
 *  Erosion.
 *  7x7 diamond perimeter.
 *  Hit  = [[0, -3], [-3, 0], [3, 0], [0, 3]]
 */
RC_EXPORT void
rc_morph_erode_diamond_7x7_p_bin(uint8_t *restrict dst, int dst_dim,
                                 const uint8_t *restrict src, int src_dim,
                                 int width, int height);

/**
 *  Dilation.
 *  7x7 diamond perimeter.
 *  Hit  = [[0, -3], [-3, 0], [3, 0], [0, 3]]
 */
RC_EXPORT void
rc_morph_dilate_diamond_7x7_p_bin(uint8_t *restrict dst, int dst_dim,
                                  const uint8_t *restrict src, int src_dim,
                                  int width, int height);

/**
 *  Erosion.
 *  9x9 diamond perimeter.
 *  Hit  = [[0, -4], [-4, 0], [4, 0], [0, 4]]
 */
RC_EXPORT void
rc_morph_erode_diamond_9x9_p_bin(uint8_t *restrict dst, int dst_dim,
                                 const uint8_t *restrict src, int src_dim,
                                 int width, int height);

/**
 *  Dilation.
 *  9x9 diamond perimeter.
 *  Hit  = [[0, -4], [-4, 0], [4, 0], [0, 4]]
 */
RC_EXPORT void
rc_morph_dilate_diamond_9x9_p_bin(uint8_t *restrict dst, int dst_dim,
                                  const uint8_t *restrict src, int src_dim,
                                  int width, int height);

/**
 *  Erosion.
 *  13x13 diamond perimeter.
 *  Hit  = [[0, -6], [-6, 0], [6, 0], [0, 6]]
 */
RC_EXPORT void
rc_morph_erode_diamond_13x13_p_bin(uint8_t *restrict dst, int dst_dim,
                                   const uint8_t *restrict src, int src_dim,
                                   int width, int height);

/**
 *  Dilation.
 *  13x13 diamond perimeter.
 *  Hit  = [[0, -6], [-6, 0], [6, 0], [0, 6]]
 */
RC_EXPORT void
rc_morph_dilate_diamond_13x13_p_bin(uint8_t *restrict dst, int dst_dim,
                                    const uint8_t *restrict src, int src_dim,
                                    int width, int height);

/**
 *  Erosion.
 *  15x15 diamond perimeter.
 *  Hit  = [[0, -7], [-7, 0], [7, 0], [0, 7]]
 */
RC_EXPORT void
rc_morph_erode_diamond_15x15_p_bin(uint8_t *restrict dst, int dst_dim,
                                   const uint8_t *restrict src, int src_dim,
                                   int width, int height);

/**
 *  Dilation.
 *  15x15 diamond perimeter.
 *  Hit  = [[0, -7], [-7, 0], [7, 0], [0, 7]]
 */
RC_EXPORT void
rc_morph_dilate_diamond_15x15_p_bin(uint8_t *restrict dst, int dst_dim,
                                    const uint8_t *restrict src, int src_dim,
                                    int width, int height);

/**
 *  Erosion.
 *  17x17 diamond perimeter.
 *  Hit  = [[0, -8], [-8, 0], [8, 0], [0, 8]]
 */
RC_EXPORT void
rc_morph_erode_diamond_17x17_p_bin(uint8_t *restrict dst, int dst_dim,
                                   const uint8_t *restrict src, int src_dim,
                                   int width, int height);

/**
 *  Dilation.
 *  17x17 diamond perimeter.
 *  Hit  = [[0, -8], [-8, 0], [8, 0], [0, 8]]
 */
RC_EXPORT void
rc_morph_dilate_diamond_17x17_p_bin(uint8_t *restrict dst, int dst_dim,
                                    const uint8_t *restrict src, int src_dim,
                                    int width, int height);

/**
 *  Erosion.
 *  25x25 diamond perimeter.
 *  Hit  = [[0, -12], [-12, 0], [12, 0], [0, 12]]
 */
RC_EXPORT void
rc_morph_erode_diamond_25x25_p_bin(uint8_t *restrict dst, int dst_dim,
                                   const uint8_t *restrict src, int src_dim,
                                   int width, int height);

/**
 *  Dilation.
 *  25x25 diamond perimeter.
 *  Hit  = [[0, -12], [-12, 0], [12, 0], [0, 12]]
 */
RC_EXPORT void
rc_morph_dilate_diamond_25x25_p_bin(uint8_t *restrict dst, int dst_dim,
                                    const uint8_t *restrict src, int src_dim,
                                    int width, int height);

/**
 *  Erosion.
 *  29x29 diamond perimeter.
 *  Hit  = [[0, -14], [-14, 0], [14, 0], [0, 14]]
 */
RC_EXPORT void
rc_morph_erode_diamond_29x29_p_bin(uint8_t *restrict dst, int dst_dim,
                                   const uint8_t *restrict src, int src_dim,
                                   int width, int height);

/**
 *  Dilation.
 *  29x29 diamond perimeter.
 *  Hit  = [[0, -14], [-14, 0], [14, 0], [0, 14]]
 */
RC_EXPORT void
rc_morph_dilate_diamond_29x29_p_bin(uint8_t *restrict dst, int dst_dim,
                                    const uint8_t *restrict src, int src_dim,
                                    int width, int height);

/**
 *  Erosion.
 *  31x31 diamond perimeter.
 *  Hit  = [[0, -15], [-15, 0], [15, 0], [0, 15]]
 */
RC_EXPORT void
rc_morph_erode_diamond_31x31_p_bin(uint8_t *restrict dst, int dst_dim,
                                   const uint8_t *restrict src, int src_dim,
                                   int width, int height);

/**
 *  Dilation.
 *  31x31 diamond perimeter.
 *  Hit  = [[0, -15], [-15, 0], [15, 0], [0, 15]]
 */
RC_EXPORT void
rc_morph_dilate_diamond_31x31_p_bin(uint8_t *restrict dst, int dst_dim,
                                    const uint8_t *restrict src, int src_dim,
                                    int width, int height);

/**
 *  Erosion.
 *  5x5 octagon perimeter.
 *  Hit  = [[-1, -2], [1, -2], [-2, -1], [2, -1],
 *          [-2, 1], [2, 1], [-1, 2], [1, 2]]
 */
RC_EXPORT void
rc_morph_erode_octagon_5x5_p_bin(uint8_t *restrict dst, int dst_dim,
                                 const uint8_t *restrict src, int src_dim,
                                 int width, int height);

/**
 *  Dilation.
 *  5x5 octagon perimeter.
 *  Hit  = [[-1, -2], [1, -2], [-2, -1], [2, -1],
 *          [-2, 1], [2, 1], [-1, 2], [1, 2]]
 */
RC_EXPORT void
rc_morph_dilate_octagon_5x5_p_bin(uint8_t *restrict dst, int dst_dim,
                                  const uint8_t *restrict src, int src_dim,
                                  int width, int height);

/**
 *  Erosion.
 *  7x7 octagon perimeter.
 *  Hit  = [[-1, -3], [1, -3], [-3, -1], [3, -1],
 *          [-3, 1], [3, 1], [-1, 3], [1, 3]]
 */
RC_EXPORT void
rc_morph_erode_octagon_7x7_p_bin(uint8_t *restrict dst, int dst_dim,
                                 const uint8_t *restrict src, int src_dim,
                                 int width, int height);

/**
 *  Dilation.
 *  7x7 octagon perimeter.
 *  Hit  = [[-1, -3], [1, -3], [-3, -1], [3, -1],
 *          [-3, 1], [3, 1], [-1, 3], [1, 3]]
 */
RC_EXPORT void
rc_morph_dilate_octagon_7x7_p_bin(uint8_t *restrict dst, int dst_dim,
                                  const uint8_t *restrict src, int src_dim,
                                  int width, int height);

/**
 *  Erosion.
 *  9x9 octagon perimeter.
 *  Hit  = [[-2, -4], [2, -4], [-4, -2], [4, -2],
 *          [-4, 2], [4, 2], [-2, 4], [2, 4]]
 */
RC_EXPORT void
rc_morph_erode_octagon_9x9_p_bin(uint8_t *restrict dst, int dst_dim,
                                 const uint8_t *restrict src, int src_dim,
                                 int width, int height);

/**
 *  Dilation.
 *  9x9 octagon perimeter.
 *  Hit  = [[-2, -4], [2, -4], [-4, -2], [4, -2],
 *          [-4, 2], [4, 2], [-2, 4], [2, 4]]
 */
RC_EXPORT void
rc_morph_dilate_octagon_9x9_p_bin(uint8_t *restrict dst, int dst_dim,
                                  const uint8_t *restrict src, int src_dim,
                                  int width, int height);

/**
 *  Erosion.
 *  13x13 octagon perimeter.
 *  Hit  = [[-2, -6], [2, -6], [-6, -2], [6, -2],
 *          [-6, 2], [6, 2], [-2, 6], [2, 6]]
 */
RC_EXPORT void
rc_morph_erode_octagon_13x13_p_bin(uint8_t *restrict dst, int dst_dim,
                                   const uint8_t *restrict src, int src_dim,
                                   int width, int height);

/**
 *  Dilation.
 *  13x13 octagon perimeter.
 *  Hit  = [[-2, -6], [2, -6], [-6, -2], [6, -2],
 *          [-6, 2], [6, 2], [-2, 6], [2, 6]]
 */
RC_EXPORT void
rc_morph_dilate_octagon_13x13_p_bin(uint8_t *restrict dst, int dst_dim,
                                    const uint8_t *restrict src, int src_dim,
                                    int width, int height);

/**
 *  Erosion.
 *  15x15 octagon perimeter.
 *  Hit  = [[-3, -7], [3, -7], [-7, -3], [7, -3],
 *          [-7, 3], [7, 3], [-3, 7], [3, 7]]
 */
RC_EXPORT void
rc_morph_erode_octagon_15x15_p_bin(uint8_t *restrict dst, int dst_dim,
                                   const uint8_t *restrict src, int src_dim,
                                   int width, int height);

/**
 *  Dilation.
 *  15x15 octagon perimeter.
 *  Hit  = [[-3, -7], [3, -7], [-7, -3], [7, -3],
 *          [-7, 3], [7, 3], [-3, 7], [3, 7]]
 */
RC_EXPORT void
rc_morph_dilate_octagon_15x15_p_bin(uint8_t *restrict dst, int dst_dim,
                                    const uint8_t *restrict src, int src_dim,
                                    int width, int height);

/**
 *  Erosion.
 *  17x17 octagon perimeter.
 *  Hit  = [[-3, -8], [3, -8], [-8, -3], [8, -3],
 *          [-8, 3], [8, 3], [-3, 8], [3, 8]]
 */
RC_EXPORT void
rc_morph_erode_octagon_17x17_p_bin(uint8_t *restrict dst, int dst_dim,
                                   const uint8_t *restrict src, int src_dim,
                                   int width, int height);

/**
 *  Dilation.
 *  17x17 octagon perimeter.
 *  Hit  = [[-3, -8], [3, -8], [-8, -3], [8, -3],
 *          [-8, 3], [8, 3], [-3, 8], [3, 8]]
 */
RC_EXPORT void
rc_morph_dilate_octagon_17x17_p_bin(uint8_t *restrict dst, int dst_dim,
                                    const uint8_t *restrict src, int src_dim,
                                    int width, int height);

/**
 *  Erosion.
 *  25x25 octagon perimeter.
 *  Hit  = [[-5, -12], [5, -12], [-12, -5], [12, -5],
 *          [-12, 5], [12, 5], [-5, 12], [5, 12]]
 */
RC_EXPORT void
rc_morph_erode_octagon_25x25_p_bin(uint8_t *restrict dst, int dst_dim,
                                   const uint8_t *restrict src, int src_dim,
                                   int width, int height);

/**
 *  Dilation.
 *  25x25 octagon perimeter.
 *  Hit  = [[-5, -12], [5, -12], [-12, -5], [12, -5],
 *          [-12, 5], [12, 5], [-5, 12], [5, 12]]
 */
RC_EXPORT void
rc_morph_dilate_octagon_25x25_p_bin(uint8_t *restrict dst, int dst_dim,
                                    const uint8_t *restrict src, int src_dim,
                                    int width, int height);

/**
 *  Erosion.
 *  29x29 octagon perimeter.
 *  Hit  = [[-6, -14], [6, -14], [-14, -6], [14, -6],
 *          [-14, 6], [14, 6], [-6, 14], [6, 14]]
 */
RC_EXPORT void
rc_morph_erode_octagon_29x29_p_bin(uint8_t *restrict dst, int dst_dim,
                                   const uint8_t *restrict src, int src_dim,
                                   int width, int height);

/**
 *  Dilation.
 *  29x29 octagon perimeter.
 *  Hit  = [[-6, -14], [6, -14], [-14, -6], [14, -6],
 *          [-14, 6], [14, 6], [-6, 14], [6, 14]]
 */
RC_EXPORT void
rc_morph_dilate_octagon_29x29_p_bin(uint8_t *restrict dst, int dst_dim,
                                    const uint8_t *restrict src, int src_dim,
                                    int width, int height);

/**
 *  Erosion.
 *  31x31 octagon perimeter.
 *  Hit  = [[-6, -15], [6, -15], [-15, -6], [15, -6],
 *          [-15, 6], [15, 6], [-6, 15], [6, 15]]
 */
RC_EXPORT void
rc_morph_erode_octagon_31x31_p_bin(uint8_t *restrict dst, int dst_dim,
                                   const uint8_t *restrict src, int src_dim,
                                   int width, int height);

/**
 *  Dilation.
 *  31x31 octagon perimeter.
 *  Hit  = [[-6, -15], [6, -15], [-15, -6], [15, -6],
 *          [-15, 6], [15, 6], [-6, 15], [6, 15]]
 */
RC_EXPORT void
rc_morph_dilate_octagon_31x31_p_bin(uint8_t *restrict dst, int dst_dim,
                                    const uint8_t *restrict src, int src_dim,
                                    int width, int height);

/**
 *  Erosion.
 *  7x7 filled disc.
 *  Hit  = [[0, -3], [-2, -2], [-1, -2], [0, -2],
 *          [1, -2], [2, -2], [-2, -1], [-1, -1],
 *          [0, -1], [1, -1], [2, -1], [-3, 0],
 *          [-2, 0], [-1, 0], [0, 0], [1, 0],
 *          [2, 0], [3, 0], [-2, 1], [-1, 1],
 *          [0, 1], [1, 1], [2, 1], [-2, 2],
 *          [-1, 2], [0, 2], [1, 2], [2, 2],
 *          [0, 3]]
 */
RC_EXPORT void
rc_morph_erode_disc_7x7_bin(uint8_t *restrict dst, int dst_dim,
                            const uint8_t *restrict src, int src_dim,
                            int width, int height);

/**
 *  Dilation.
 *  7x7 filled disc.
 *  Hit  = [[0, -3], [-2, -2], [-1, -2], [0, -2],
 *          [1, -2], [2, -2], [-2, -1], [-1, -1],
 *          [0, -1], [1, -1], [2, -1], [-3, 0],
 *          [-2, 0], [-1, 0], [0, 0], [1, 0],
 *          [2, 0], [3, 0], [-2, 1], [-1, 1],
 *          [0, 1], [1, 1], [2, 1], [-2, 2],
 *          [-1, 2], [0, 2], [1, 2], [2, 2],
 *          [0, 3]]
 */
RC_EXPORT void
rc_morph_dilate_disc_7x7_bin(uint8_t *restrict dst, int dst_dim,
                             const uint8_t *restrict src, int src_dim,
                             int width, int height);

/**
 *  Erosion.
 *  7x7 disc perimeter.
 *  Hit  = [[0, -3], [-2, -2], [2, -2], [-3, 0],
 *          [0, 0], [3, 0], [-2, 2], [2, 2],
 *          [0, 3]]
 */
RC_EXPORT void
rc_morph_erode_disc_7x7_p_bin(uint8_t *restrict dst, int dst_dim,
                              const uint8_t *restrict src, int src_dim,
                              int width, int height);

/**
 *  Dilation.
 *  7x7 disc perimeter.
 *  Hit  = [[0, -3], [-2, -2], [2, -2], [-3, 0],
 *          [0, 0], [3, 0], [-2, 2], [2, 2],
 *          [0, 3]]
 */
RC_EXPORT void
rc_morph_dilate_disc_7x7_p_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height);

/**
 *  Erosion.
 *  9x9 disc perimeter.
 *  Hit  = [[0, -4], [-3, -3], [3, -3], [-4, 0],
 *          [4, 0], [-3, 3], [3, 3], [0, 4]]
 */
RC_EXPORT void
rc_morph_erode_disc_9x9_p_bin(uint8_t *restrict dst, int dst_dim,
                              const uint8_t *restrict src, int src_dim,
                              int width, int height);

/**
 *  Dilation.
 *  9x9 disc perimeter.
 *  Hit  = [[0, -4], [-3, -3], [3, -3], [-4, 0],
 *          [4, 0], [-3, 3], [3, 3], [0, 4]]
 */
RC_EXPORT void
rc_morph_dilate_disc_9x9_p_bin(uint8_t *restrict dst, int dst_dim,
                               const uint8_t *restrict src, int src_dim,
                               int width, int height);

/**
 *  Erosion.
 *  11x11 disc perimeter.
 *  Hit  = [[0, -5], [-4, -4], [-3, -4], [3, -4],
 *          [4, -4], [-4, -3], [4, -3], [-5, 0],
 *          [5, 0], [-4, 3], [4, 3], [-4, 4],
 *          [-3, 4], [3, 4], [4, 4], [0, 5]]
 */
RC_EXPORT void
rc_morph_erode_disc_11x11_p_bin(uint8_t *restrict dst, int dst_dim,
                                const uint8_t *restrict src, int src_dim,
                                int width, int height);

/**
 *  Dilation.
 *  11x11 disc perimeter.
 *  Hit  = [[0, -5], [-4, -4], [-3, -4], [3, -4],
 *          [4, -4], [-4, -3], [4, -3], [-5, 0],
 *          [5, 0], [-4, 3], [4, 3], [-4, 4],
 *          [-3, 4], [3, 4], [4, 4], [0, 5]]
 */
RC_EXPORT void
rc_morph_dilate_disc_11x11_p_bin(uint8_t *restrict dst, int dst_dim,
                                 const uint8_t *restrict src, int src_dim,
                                 int width, int height);

/**
 *  Erosion.
 *  13x13 disc perimeter.
 *  Hit  = [[0, -6], [-4, -5], [-3, -5], [3, -5],
 *          [4, -5], [-5, -4], [5, -4], [-5, -3],
 *          [5, -3], [-6, 0], [0, 0], [6, 0],
 *          [-5, 3], [5, 3], [-5, 4], [5, 4],
 *          [-4, 5], [-3, 5], [3, 5], [4, 5],
 *          [0, 6]]
 */
RC_EXPORT void
rc_morph_erode_disc_13x13_p_bin(uint8_t *restrict dst, int dst_dim,
                                const uint8_t *restrict src, int src_dim,
                                int width, int height);

/**
 *  Dilation.
 *  13x13 disc perimeter.
 *  Hit  = [[0, -6], [-4, -5], [-3, -5], [3, -5],
 *          [4, -5], [-5, -4], [5, -4], [-5, -3],
 *          [5, -3], [-6, 0], [0, 0], [6, 0],
 *          [-5, 3], [5, 3], [-5, 4], [5, 4],
 *          [-4, 5], [-3, 5], [3, 5], [4, 5],
 *          [0, 6]]
 */
RC_EXPORT void
rc_morph_dilate_disc_13x13_p_bin(uint8_t *restrict dst, int dst_dim,
                                 const uint8_t *restrict src, int src_dim,
                                 int width, int height);

/**
 *  Erosion.
 *  15x15 disc perimeter.
 *  Hit  = [[0, -7], [-4, -6], [-3, -6], [3, -6],
 *          [4, -6], [-6, -4], [6, -4], [-6, -3],
 *          [6, -3], [-7, 0], [7, 0], [-6, 3],
 *          [6, 3], [-6, 4], [6, 4], [-4, 6],
 *          [-3, 6], [3, 6], [4, 6], [0, 7]]
 */
RC_EXPORT void
rc_morph_erode_disc_15x15_p_bin(uint8_t *restrict dst, int dst_dim,
                                const uint8_t *restrict src, int src_dim,
                                int width, int height);

/**
 *  Dilation.
 *  15x15 disc perimeter.
 *  Hit  = [[0, -7], [-4, -6], [-3, -6], [3, -6],
 *          [4, -6], [-6, -4], [6, -4], [-6, -3],
 *          [6, -3], [-7, 0], [7, 0], [-6, 3],
 *          [6, 3], [-6, 4], [6, 4], [-4, 6],
 *          [-3, 6], [3, 6], [4, 6], [0, 7]]
 */
RC_EXPORT void
rc_morph_dilate_disc_15x15_p_bin(uint8_t *restrict dst, int dst_dim,
                                 const uint8_t *restrict src, int src_dim,
                                 int width, int height);

/**
 *  Erosion.
 *  17x17 disc perimeter.
 *  Hit  = [[0, -8], [-5, -7], [-4, -7], [4, -7],
 *          [5, -7], [-7, -5], [7, -5], [-7, -4],
 *          [7, -4], [-8, 0], [8, 0], [-7, 4],
 *          [7, 4], [-7, 5], [7, 5], [-5, 7],
 *          [-4, 7], [4, 7], [5, 7], [0, 8]]
 */
RC_EXPORT void
rc_morph_erode_disc_17x17_p_bin(uint8_t *restrict dst, int dst_dim,
                                const uint8_t *restrict src, int src_dim,
                                int width, int height);

/**
 *  Dilation.
 *  17x17 disc perimeter.
 *  Hit  = [[0, -8], [-5, -7], [-4, -7], [4, -7],
 *          [5, -7], [-7, -5], [7, -5], [-7, -4],
 *          [7, -4], [-8, 0], [8, 0], [-7, 4],
 *          [7, 4], [-7, 5], [7, 5], [-5, 7],
 *          [-4, 7], [4, 7], [5, 7], [0, 8]]
 */
RC_EXPORT void
rc_morph_dilate_disc_17x17_p_bin(uint8_t *restrict dst, int dst_dim,
                                 const uint8_t *restrict src, int src_dim,
                                 int width, int height);

/**
 *  Erosion.
 *  19x19 disc perimeter.
 *  Hit  = [[0, -9], [-5, -8], [-4, -8], [4, -8],
 *          [5, -8], [-8, -5], [8, -5], [-8, -4],
 *          [8, -4], [-9, 0], [9, 0], [-8, 4],
 *          [8, 4], [-8, 5], [8, 5], [-5, 8],
 *          [-4, 8], [4, 8], [5, 8], [0, 9]]
 */
RC_EXPORT void
rc_morph_erode_disc_19x19_p_bin(uint8_t *restrict dst, int dst_dim,
                                const uint8_t *restrict src, int src_dim,
                                int width, int height);

/**
 *  Dilation.
 *  19x19 disc perimeter.
 *  Hit  = [[0, -9], [-5, -8], [-4, -8], [4, -8],
 *          [5, -8], [-8, -5], [8, -5], [-8, -4],
 *          [8, -4], [-9, 0], [9, 0], [-8, 4],
 *          [8, 4], [-8, 5], [8, 5], [-5, 8],
 *          [-4, 8], [4, 8], [5, 8], [0, 9]]
 */
RC_EXPORT void
rc_morph_dilate_disc_19x19_p_bin(uint8_t *restrict dst, int dst_dim,
                                 const uint8_t *restrict src, int src_dim,
                                 int width, int height);

/**
 *  Erosion.
 *  25x25 disc perimeter.
 *  Hit  = [[0, -12], [-6, -11], [-5, -11], [5, -11],
 *          [6, -11], [-7, -10], [7, -10], [-10, -7],
 *          [10, -7], [-11, -6], [11, -6], [-11, -5],
 *          [11, -5], [-12, 0], [12, 0], [-11, 5],
 *          [11, 5], [-11, 6], [11, 6], [-10, 7],
 *          [10, 7], [-7, 10], [7, 10], [-6, 11],
 *          [-5, 11], [5, 11], [6, 11], [0, 12]]
 */
RC_EXPORT void
rc_morph_erode_disc_25x25_p_bin(uint8_t *restrict dst, int dst_dim,
                                const uint8_t *restrict src, int src_dim,
                                int width, int height);

/**
 *  Dilation.
 *  25x25 disc perimeter.
 *  Hit  = [[0, -12], [-6, -11], [-5, -11], [5, -11],
 *          [6, -11], [-7, -10], [7, -10], [-10, -7],
 *          [10, -7], [-11, -6], [11, -6], [-11, -5],
 *          [11, -5], [-12, 0], [12, 0], [-11, 5],
 *          [11, 5], [-11, 6], [11, 6], [-10, 7],
 *          [10, 7], [-7, 10], [7, 10], [-6, 11],
 *          [-5, 11], [5, 11], [6, 11], [0, 12]]
 */
RC_EXPORT void
rc_morph_dilate_disc_25x25_p_bin(uint8_t *restrict dst, int dst_dim,
                                 const uint8_t *restrict src, int src_dim,
                                 int width, int height);

/**
 *  Hit-or-miss transform.
 *  3x3 HMT Golay letter L, 4- and 8-connectivity, 0 degrees.
 *  Hit  = [[-1, 1], [0, 1], [1, 1]]
 *  Miss = [[-1, -1], [0, -1], [1, -1]]
 */
RC_EXPORT void
rc_morph_hmt_golay_l_3x3_c48_r0_bin(uint8_t *restrict dst, int dst_dim,
                                    const uint8_t *restrict src, int src_dim,
                                    int width, int height);

/**
 *  Hit-or-miss transform.
 *  3x3 HMT Golay letter L, 4- and 8-connectivity, 90 degrees.
 *  Hit  = [[-1, -1], [-1, 0], [-1, 1]]
 *  Miss = [[1, -1], [1, 0], [1, 1]]
 */
RC_EXPORT void
rc_morph_hmt_golay_l_3x3_c48_r90_bin(uint8_t *restrict dst, int dst_dim,
                                     const uint8_t *restrict src, int src_dim,
                                     int width, int height);

/**
 *  Hit-or-miss transform.
 *  3x3 HMT Golay letter L, 4- and 8-connectivity, 180 degrees.
 *  Hit  = [[1, -1], [0, -1], [-1, -1]]
 *  Miss = [[1, 1], [0, 1], [-1, 1]]
 */
RC_EXPORT void
rc_morph_hmt_golay_l_3x3_c48_r180_bin(uint8_t *restrict dst, int dst_dim,
                                      const uint8_t *restrict src, int src_dim,
                                      int width, int height);

/**
 *  Hit-or-miss transform.
 *  3x3 HMT Golay letter L, 4- and 8-connectivity, 270 degrees.
 *  Hit  = [[1, 1], [1, 0], [1, -1]]
 *  Miss = [[-1, 1], [-1, 0], [-1, -1]]
 */
RC_EXPORT void
rc_morph_hmt_golay_l_3x3_c48_r270_bin(uint8_t *restrict dst, int dst_dim,
                                      const uint8_t *restrict src, int src_dim,
                                      int width, int height);

/**
 *  Hit-or-miss transform.
 *  3x3 HMT Golay letter L, 4-connectivity, 45 degrees.
 *  Hit  = [[-1, 0], [-1, 1], [0, 1]]
 *  Miss = [[0, -1], [1, 0]]
 */
RC_EXPORT void
rc_morph_hmt_golay_l_3x3_c4_r45_bin(uint8_t *restrict dst, int dst_dim,
                                    const uint8_t *restrict src, int src_dim,
                                    int width, int height);

/**
 *  Hit-or-miss transform.
 *  3x3 HMT Golay letter L, 4-connectivity, 135 degrees.
 *  Hit  = [[0, -1], [-1, -1], [-1, 0]]
 *  Miss = [[1, 0], [0, 1]]
 */
RC_EXPORT void
rc_morph_hmt_golay_l_3x3_c4_r135_bin(uint8_t *restrict dst, int dst_dim,
                                     const uint8_t *restrict src, int src_dim,
                                     int width, int height);

/**
 *  Hit-or-miss transform.
 *  3x3 HMT Golay letter L, 4-connectivity, 225 degrees.
 *  Hit  = [[1, 0], [1, -1], [0, -1]]
 *  Miss = [[0, 1], [-1, 0]]
 */
RC_EXPORT void
rc_morph_hmt_golay_l_3x3_c4_r225_bin(uint8_t *restrict dst, int dst_dim,
                                     const uint8_t *restrict src, int src_dim,
                                     int width, int height);

/**
 *  Hit-or-miss transform.
 *  3x3 HMT Golay letter L, 4-connectivity, 315 degrees.
 *  Hit  = [[0, 1], [1, 1], [1, 0]]
 *  Miss = [[-1, 0], [0, -1]]
 */
RC_EXPORT void
rc_morph_hmt_golay_l_3x3_c4_r315_bin(uint8_t *restrict dst, int dst_dim,
                                     const uint8_t *restrict src, int src_dim,
                                     int width, int height);

/**
 *  Hit-or-miss transform.
 *  3x3 HMT Golay letter L, 8-connectivity, 45 degrees.
 *  Hit  = [[-1, 0], [0, 1]]
 *  Miss = [[0, -1], [1, -1], [1, 0]]
 */
RC_EXPORT void
rc_morph_hmt_golay_l_3x3_c8_r45_bin(uint8_t *restrict dst, int dst_dim,
                                    const uint8_t *restrict src, int src_dim,
                                    int width, int height);

/**
 *  Hit-or-miss transform.
 *  3x3 HMT Golay letter L, 8-connectivity, 135 degrees.
 *  Hit  = [[0, -1], [-1, 0]]
 *  Miss = [[1, 0], [1, 1], [0, 1]]
 */
RC_EXPORT void
rc_morph_hmt_golay_l_3x3_c8_r135_bin(uint8_t *restrict dst, int dst_dim,
                                     const uint8_t *restrict src, int src_dim,
                                     int width, int height);

/**
 *  Hit-or-miss transform.
 *  3x3 HMT Golay letter L, 8-connectivity, 225 degrees.
 *  Hit  = [[1, 0], [0, -1]]
 *  Miss = [[0, 1], [-1, 1], [-1, 0]]
 */
RC_EXPORT void
rc_morph_hmt_golay_l_3x3_c8_r225_bin(uint8_t *restrict dst, int dst_dim,
                                     const uint8_t *restrict src, int src_dim,
                                     int width, int height);

/**
 *  Hit-or-miss transform.
 *  3x3 HMT Golay letter L, 8-connectivity, 315 degrees.
 *  Hit  = [[0, 1], [1, 0]]
 *  Miss = [[-1, 0], [-1, -1], [0, -1]]
 */
RC_EXPORT void
rc_morph_hmt_golay_l_3x3_c8_r315_bin(uint8_t *restrict dst, int dst_dim,
                                     const uint8_t *restrict src, int src_dim,
                                     int width, int height);

/**
 *  Hit-or-miss transform.
 *  3x3 HMT Golay letter E, 4-connectivity, 0 degrees.
 *  Miss = [[0, -1], [-1, 0], [1, 0]]
 */
RC_EXPORT void
rc_morph_hmt_golay_e_3x3_c4_r0_bin(uint8_t *restrict dst, int dst_dim,
                                   const uint8_t *restrict src, int src_dim,
                                   int width, int height);

/**
 *  Hit-or-miss transform.
 *  3x3 HMT Golay letter E, 4-connectivity, 90 degrees.
 *  Miss = [[1, 0], [0, -1], [0, 1]]
 */
RC_EXPORT void
rc_morph_hmt_golay_e_3x3_c4_r90_bin(uint8_t *restrict dst, int dst_dim,
                                    const uint8_t *restrict src, int src_dim,
                                    int width, int height);

/**
 *  Hit-or-miss transform.
 *  3x3 HMT Golay letter E, 4-connectivity, 180 degrees.
 *  Miss = [[0, 1], [1, 0], [-1, 0]]
 */
RC_EXPORT void
rc_morph_hmt_golay_e_3x3_c4_r180_bin(uint8_t *restrict dst, int dst_dim,
                                     const uint8_t *restrict src, int src_dim,
                                     int width, int height);

/**
 *  Hit-or-miss transform.
 *  3x3 HMT Golay letter E, 4-connectivity, 270 degrees.
 *  Miss = [[-1, 0], [0, 1], [0, -1]]
 */
RC_EXPORT void
rc_morph_hmt_golay_e_3x3_c4_r270_bin(uint8_t *restrict dst, int dst_dim,
                                     const uint8_t *restrict src, int src_dim,
                                     int width, int height);

/**
 *  Hit-or-miss transform.
 *  3x3 HMT Golay letter E, 8-connectivity, 0 degrees.
 *  Miss = [[-1, -1], [0, -1], [1, -1], [-1, 0],
 *          [1, 0], [-1, 1]]
 */
RC_EXPORT void
rc_morph_hmt_golay_e_3x3_c8_r0_bin(uint8_t *restrict dst, int dst_dim,
                                   const uint8_t *restrict src, int src_dim,
                                   int width, int height);

/**
 *  Hit-or-miss transform.
 *  3x3 HMT Golay letter E, 8-connectivity, 90 degrees.
 *  Miss = [[1, -1], [1, 0], [1, 1], [0, -1],
 *          [0, 1], [-1, -1]]
 */
RC_EXPORT void
rc_morph_hmt_golay_e_3x3_c8_r90_bin(uint8_t *restrict dst, int dst_dim,
                                    const uint8_t *restrict src, int src_dim,
                                    int width, int height);

/**
 *  Hit-or-miss transform.
 *  3x3 HMT Golay letter E, 8-connectivity, 180 degrees.
 *  Miss = [[1, 1], [0, 1], [-1, 1], [1, 0],
 *          [-1, 0], [1, -1]]
 */
RC_EXPORT void
rc_morph_hmt_golay_e_3x3_c8_r180_bin(uint8_t *restrict dst, int dst_dim,
                                     const uint8_t *restrict src, int src_dim,
                                     int width, int height);

/**
 *  Hit-or-miss transform.
 *  3x3 HMT Golay letter E, 8-connectivity, 270 degrees.
 *  Miss = [[-1, 1], [-1, 0], [-1, -1], [0, 1],
 *          [0, -1], [1, 1]]
 */
RC_EXPORT void
rc_morph_hmt_golay_e_3x3_c8_r270_bin(uint8_t *restrict dst, int dst_dim,
                                     const uint8_t *restrict src, int src_dim,
                                     int width, int height);

/**
 *  Hit-or-miss transform.
 *  3x3 HMT Golay letter E, 8-connectivity, 45 degrees.
 *  Miss = [[-1, -1], [0, -1], [1, -1], [-1, 0],
 *          [-1, 1], [0, 1]]
 */
RC_EXPORT void
rc_morph_hmt_golay_e_3x3_c8_r45_bin(uint8_t *restrict dst, int dst_dim,
                                    const uint8_t *restrict src, int src_dim,
                                    int width, int height);

/**
 *  Hit-or-miss transform.
 *  3x3 HMT Golay letter E, 8-connectivity, 135 degrees.
 *  Miss = [[1, -1], [1, 0], [1, 1], [0, -1],
 *          [-1, -1], [-1, 0]]
 */
RC_EXPORT void
rc_morph_hmt_golay_e_3x3_c8_r135_bin(uint8_t *restrict dst, int dst_dim,
                                     const uint8_t *restrict src, int src_dim,
                                     int width, int height);

/**
 *  Hit-or-miss transform.
 *  3x3 HMT Golay letter E, 8-connectivity, 225 degrees.
 *  Miss = [[1, 1], [0, 1], [-1, 1], [1, 0],
 *          [1, -1], [0, -1]]
 */
RC_EXPORT void
rc_morph_hmt_golay_e_3x3_c8_r225_bin(uint8_t *restrict dst, int dst_dim,
                                     const uint8_t *restrict src, int src_dim,
                                     int width, int height);

/**
 *  Hit-or-miss transform.
 *  3x3 HMT Golay letter E, 8-connectivity, 315 degrees.
 *  Miss = [[-1, 1], [-1, 0], [-1, -1], [0, 1],
 *          [1, 1], [1, 0]]
 */
RC_EXPORT void
rc_morph_hmt_golay_e_3x3_c8_r315_bin(uint8_t *restrict dst, int dst_dim,
                                     const uint8_t *restrict src, int src_dim,
                                     int width, int height);

#endif /* RC_MORPH_BIN_H */
