-------------------------------------------------------------------
--           RAPID - RAPID ADA PORTABLE INTERFACE DESIGNER
--           TCL PEER FOR THE MCC TKI (ToolKit Interface) library
--           Copyright (C) 1999 Martin C. Carlisle.
--
-- RAPID is free software;  you can  redistribute it  and/or modify
-- it under terms of the  GNU General Public License as published
-- by the Free Software  Foundation;  either version 2,  or (at your
-- option) any later version.  RAPID is distributed in the hope that
-- it will be useful, but WITHOUT ANY WARRANTY;  without even the
-- implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
-- PURPOSE.  See the GNU General Public License for more details.
-- You should have  received  a copy of the GNU General Public License
-- distributed with RAPID; see file COPYING.  If not, write to the
-- Free Software Foundation,  59 Temple Place - Suite 330,  Boston,
-- MA 02111-1307, USA.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.  This exception does not apply to executables which
-- are GUI design tools, or that could act as a replacement
-- for RAPID.
------------------------------------------------------------------------------
with My_Expanding_Array;
with Ada.Unchecked_Conversion;
package body mcc.tki.Widget.Button.Radio is

   ------------------
   -- Add_To_Group --
   ------------------

   procedure Add_To_Group
     (Group  : in out Radio_Group;
      Button : in Radio_Pointer)
   is
   begin
      if Group.My_Peer.Lookup = 0 then
         Group.My_Peer                                         :=
            peer.Create_Peer;
         Group.My_Peer.Name.all (Group.My_Peer.Name.all'First) := 'g';  -- repl
                                                                        --ace
                                                                        --'.'
                                                                        --with
                                                                        --'g'
                                                                        --at
                                                                        --start
                                                                        -- of
                                                                        --group
                                                                        -- name
         Group.My_Peer.Lookup                                  := 1;
      end if;

      if Button.My_Peer.Lookup = 0 then
         My_Expanding_Array.Insert
           (Table    => My_Expanding_Array.Table,
            Element  => Sized_Object_Pointer (Button),
            Location => Button.My_Peer.Lookup);
      end if;

      peer.Eval
        (Button.My_Peer.Name.all & " configure " &
         " -variable " & Group.My_Peer.Name.all &
         " -value " & mcc.Img (Button.My_Peer.Lookup));
   end Add_To_Group;

   ------------
   -- Create --
   ------------

   procedure Create
     (Obj    : in out Radio_Button;
      Parent : in mcc.tki.Container.Container'Class;
      X      : in Integer;
      Y      : in Integer;
      Width  : in Natural;
      Height : in Natural;
      Text   : in String)
   is
      type Parent_Access is access constant mcc.tki.Container.Container'Class;
      function Convert is new Ada.Unchecked_Conversion (
         Parent_Access,
         mcc.tki.Container.Container_Pointer);
   begin
      Obj.My_Peer := peer.Create_Peer (mcc.tki.Container.Get_Peer (Parent));

      peer.Eval
        ("radiobutton " & Obj.My_Peer.Name.all &
         " -anchor w " &
         " -text " & '"' & peer.Fix_Quotes (Text) & '"');
      peer.Eval
        ("place " & Obj.My_Peer.Name.all &
         " -anchor nw" &
         " -x " & mcc.Img (X) &
         " -y " & mcc.Img (Y) &
         " -width " & mcc.Img (Width) &
         " -height " & mcc.Img (Height));
      Obj.Parent := Convert (Parent'Unchecked_Access);
   end Create;

   ------------------
   -- Get_Selected --
   ------------------

   function Get_Selected (Group : in Radio_Group) return Radio_Pointer is
      Lookup : Natural;
      Ptr    : mcc.tki.Sized_Object_Pointer;
   begin
      peer.Get_Value (Group.My_Peer.Name.all, Lookup);
      Ptr :=
         My_Expanding_Array.Retrieve
           (Table    => My_Expanding_Array.Table,
            Location => Lookup);
      return Radio_Pointer (Ptr);
   end Get_Selected;

   ------------------
   -- Select_Radio --
   ------------------

   procedure Select_Radio (Obj : in out Radio_Button) is
   begin
      peer.Eval (Obj.My_Peer.Name.all & " select");
   end Select_Radio;

end mcc.tki.Widget.Button.Radio;
