------------------------------------------------------------------------------
-- RAPID is free software;  you can  redistribute it  and/or modify
-- it under terms of the  GNU General Public License as published
-- by the Free Software  Foundation;  either version 2,  or (at your
-- option) any later version.  RAPID is distributed in the hope that
-- it will be useful, but WITHOUT ANY WARRANTY;  without even the
-- implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
-- PURPOSE.  See the GNU General Public License for more details.
-- You should have  received  a copy of the GNU General Public License
-- distributed with RAPID; see file COPYING.  If not, write to the
-- Free Software Foundation,  59 Temple Place - Suite 330,  Boston,
-- MA 02111-1307, USA.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.  This exception does not apply to executables which
-- are GUI design tools, or that could act as a replacement
-- for RAPID.
--
-- Copyright (C) 1999, Martin C. Carlisle <carlislem@acm.org>
------------------------------------------------------------------------------
with Ada.Command_Line;
with Ada.Strings.Fixed;
with Ada.Strings;       use Ada.Strings;
with Tcl.Ada;
with Mcc.Directory_Operations;

package body mcc.tki.Image is

   ------------
   -- Create --
   ------------

   procedure Create (Obj : out External_Image; Name : in String) is
      Changed_Name : String := Name;
   begin
      -- change to Tcl style file names
      for i in Changed_Name'Range loop
         if Changed_Name (i) = '\' then
            Changed_Name (i) := '/';
         end if;
      end loop;

      Obj.My_Peer                               := peer.Create_Peer;
      Obj.My_Peer.Name (Obj.My_Peer.Name'First) := 'p';
      -- get rid of beginning '.'

      peer.Eval
        ("image create photo " & Obj.My_Peer.Name.all & " -file " &
         Changed_Name);
   exception
      when Tcl.Ada.Tcl_Error_Exception =>
         peer.Eval
           ("image create photo " & Obj.My_Peer.Name.all & " -file """ &
            Mcc.Directory_Operations.Rapid_Root_Dir.all &
            Changed_Name & """");
   end Create;

end mcc.tki.Image;
