---------------------------------------------------------------
--
--  RAPID - Rapid Ada Portable Interface Designer
--
--  CARGV_HELPERS.ADB
--  Description : handles translation of Arguments to Ada
--    TASH procedures.
--
--  Copyright (C) 1999, Martin C. Carlisle <carlislem@acm.org>
--
-- RAPID is free software; you can redistribute it and/or
-- modify it without restriction.  However, we ask that you
-- please retain the original author information, and clearly
-- indicate if it has been modified.
--
-- RAPID is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.
---------------------------------------------------------------
with Interfaces.C.Strings;

package body Cargv_Helpers is
   use type Interfaces.C.Strings.chars_ptr;

   function Argument
     (Argv   : CArgv.Chars_Ptr_Ptr;
      Number : Integer)
      return   String
   is
      Ptr : CArgv.Chars_Ptr_Ptr := Argv;
   begin -- Argument
      for i in 1 .. Number loop
         if Ptr.all = Interfaces.C.Strings.Null_Ptr then
            raise Not_Enough_Arguments;
         end if;
         CArgv.Argv_Pointer.Increment (Ptr);
      end loop;
      if Ptr.all = Interfaces.C.Strings.Null_Ptr then
         raise Not_Enough_Arguments;
      end if;
      return Interfaces.C.Strings.Value (Ptr.all);
   end Argument;

   function Argument
     (Argv   : CArgv.Chars_Ptr_Ptr;
      Number : Integer)
      return   Integer
   is
      tempvar : Integer;
   begin -- Argument
      declare
         Arg : String := Argument (Argv, Number);
      begin
         tempvar := Integer'Value (Arg);
      end;
      return tempvar;
   exception
      when Not_Enough_Arguments =>
         raise;
      when others =>
         raise Invalid_Argument;
   end Argument;

end Cargv_Helpers;
