---------------------------------------------------------------
--
--  RAPID - Rapid Ada Portable Interface Designer
--
--  TOOLS_MENU.ADB
--  Description : Implements choices from the Tools menu
--
--  Copyright (C) 1999, Martin C. Carlisle <carlislem@acm.org>
--
-- RAPID is free software; you can redistribute it and/or
-- modify it without restriction.  However, we ask that you
-- please retain the original author information, and clearly
-- indicate if it has been modified.
--
-- RAPID is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.
---------------------------------------------------------------
with state;
with gui.Window; use type gui.Window.Window_Pointer;

package body Tools_Menu is
   --------------------------------------------------------------
   -- procedure Compile_Choice
   --
   -- If no window, do nothing
   -- Generate Tcl code
   -- Generate Ada code
   --------------------------------------------------------------
   procedure Compile_Choice
     (Obj : in out mcc.tki.Widget.Button.Button'Class)
   is
   begin
      Compile_Choice;
   end Compile_Choice;

   procedure Compile_Choice is

   begin -- Compile_Choice
      if state.Get_Current_Window = null then
         return;
      end if;

      if state.Get_Changed then
         null;
      end if;

      gui.Window.Generate_Window (Window => state.Get_Current_Window.all);

   end Compile_Choice;

end Tools_Menu;
