---------------------------------------------------------------
--
--  RAPID - Rapid Ada Portable Interface Designer
--
--  MENU_GENERATE.ADB
--  Description : Generate Ada code for Menu to file
--
--  Copyright (C) 1999, Martin C. Carlisle <carlislem@acm.org>
--
-- RAPID is free software; you can redistribute it and/or
-- modify it without restriction.  However, we ask that you
-- please retain the original author information, and clearly
-- indicate if it has been modified.
--
-- RAPID is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.
---------------------------------------------------------------
-- Change log:
-- 09/20/99 (mcc) : added Separator
-- 08/21/98 (mcc) : changed some Puts to Continuation_Puts to
--                  reduce generated line length
---------------------------------------------------------------
with gui, gui.Menu; use type gui.Menu.Menu_Pointer, gui.String_Pointer;
with mcc.tki.Menu;
--with Common_Dialogs; -- for debugging

package body Menu_Generate is
   Unrecognized_Type : exception;

   procedure Display_Menus
     (Menubar : in gui.Menu.Menu_Pointer;
      Menu    : in out mcc.tki.Menu.Menu'Class)
   is

      Position : gui.Menu.Menu_Position :=
         gui.Menu.Menu_List_Package.First (Menubar);
      Traverse : gui.Menu.Menu_Access;
   begin
      while not gui.Menu.Menu_List_Package.IsPastEnd (Menubar, Position) loop
         Traverse := gui.Menu.Menu_List_Package.Retrieve (Menubar, Position);
         if Traverse.all in gui.Menu.Menu_Item'Class then
            declare
               Item : mcc.tki.Menu.Choice;
            begin
               mcc.tki.Menu.Add_Choice
                 (Obj         => Item,
                  To_Menu     => Menu,
                  Text        => Traverse.all.Name.all,
                  Action      => null,
                  Underline   => Traverse.all.Underline_Position,
                  Accelerator =>
                    gui.Menu.Menu_Item (Traverse.all).Accelerator.all);
            exception
               when others =>
                  -- maybe a bad accelerator?
                  null; -- just do nothing
            end;
         elsif Traverse.all in gui.Menu.Submenu'Class then
            declare
               Submenu : mcc.tki.Menu.Submenu;
            begin
               mcc.tki.Menu.Add_Submenu
                 (Obj         => Submenu,
                  Text        => Traverse.all.Name.all,
                  Underline   => Traverse.all.Underline_Position,
                  Parent_Menu => Menu);
               Display_Menus
                 (Menubar => gui.Menu.Submenu (Traverse.all).Items,
                  Menu    => Submenu);
            end;
         elsif Traverse.all in gui.Menu.Separator'Class then
            declare
               Separator : mcc.tki.Menu.Separator;
            begin
               mcc.tki.Menu.Add_Separator (Obj => Separator, To_Menu => Menu);
            end;
         else
            raise Unrecognized_Type;
         end if;
         gui.Menu.Menu_List_Package.GoAhead (Menubar, Position);
      end loop;
   end Display_Menus;

   ---------------------------------------------------------------
   -- PROCEDURE Display_Menu_Code
   --
   -- outputs the menu to a window
   ---------------------------------------------------------------
   procedure Display_Menu_Code
     (Menubar   : in gui.Menu.Menu_Pointer;
      Window    : in out gui.Window.GUI_Window;
      Redisplay : in Boolean := False)
   is
   begin
      if Redisplay then
         mcc.tki.Destroy (mcc.tki.Object (Window.Menu_Display));
      end if;

      mcc.tki.Menu.Create
        (Obj    => Window.Menu_Display,
         Window => Window.Menu_Area);
      if not gui.Menu.Menu_List_Package.IsEmpty (Menubar) then
         Display_Menus (Menubar => Menubar, Menu => Window.Menu_Display);
      else
         declare
            No_Menu : mcc.tki.Menu.Submenu;
         begin
            mcc.tki.Menu.Add_Submenu
              (Obj         => No_Menu,
               Text        => "No menus",
               Underline   => 0,
               Parent_Menu => Window.Menu_Display);
         end;
      end if;

   end Display_Menu_Code;
end Menu_Generate;
