---------------------------------------------------------------
--
--  RAPID - Rapid Ada Portable Interface Designer
--
--  GUI_ENUM.ADS
--  Description : IO for GUI keywords
--
--  By: Martin Carlisle
--
-- RAPID is free software; you can redistribute it and/or
-- modify it without restriction.  However, we ask that you
-- please retain the original author information, and clearly
-- indicate if it has been modified.
--
-- RAPID is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.
---------------------------------------------------------------
-- Add something to this file every time you create a new widget
-- To create a new widget, you will then need to add something
-- to the gui-widget hierarchy.
---------------------------------------------------------------
-- Change log:
-- 09/20/99 (mcc) : added Separator
-- 02/16/99 (wbw) : added Scale
---------------------------------------------------------------

with gui.Widget;

package Gui_Enum is

   type Window_Kind_T is (Main_Window, Sub_Window, Frame_Child);

   type Accessibility_T is
     (Read_Write,  --  generate procedure Read_Window
      Read_Only);  --  do not generate procedure Read_Window

   type Snaptogrid_T is
     (S_Off, S_2, S_4, S_6, S_8, S_10, S_12, S_14, S_16, S_18, S_20,
      S_22, S_24, S_26, S_28, S_30, S_32, S_34, S_36, S_38, S_40);

   type Keyword is (
      Menubar,
      Menu,
      Item,
      Separator,
      EndOf,
      Window,
      Widgets,
      TextButton,
      PictureButton,
      Label,
      TextEntry,
      CheckButton,
      RadioButton,
      Picture,
      Listbox,
      Scale,
      Progress,
      Dropdown,
      Textbox,
      Frame);
   subtype Widget_Keyword is Keyword range TextButton .. Keyword'Last;

   function Img (Item : Keyword) return String;

   ----------------------------------------------------------
   -- Allocate widget
   --
   -- allocate a widget of the given type and return a pointer
   -- to it.  Does not fill in any fields of the widget
   ----------------------------------------------------------
   function Allocate_Widget
     (Widget_Type : in Widget_Keyword)
      return        gui.Widget.Widget_Access;

end Gui_Enum;
