---------------------------------------------------------------
--
--  RAPID - Rapid Ada Portable Interface Designer
--
--  GUI-WIDGET-TEXTBOX.ADS
--  Description : GUI Widget Textbox
--
--  By: Jonathan Busch and Martin Carlisle
--
-- RAPID is free software; you can redistribute it and/or
-- modify it without restriction.  However, we ask that you
-- please retain the original author information, and clearly
-- indicate if it has been modified.
--
-- RAPID is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.
--
-- Copyright (C) 2005, SA Griffin <stephen.griffin.external@eads.com>
-- Copyright (C) 2010, OM Kellogg <okellogg@users.sourceforge.net>
---------------------------------------------------------------------
with Gui.Widget.Typed_Object;
with mcc.text_entry_types;
with mcc.tki.Colors;
with mcc.tki.Container;
with mcc.tki.Widget.Button.Check;
with mcc.tki.Widget.Dropdown;

package gui.Widget.Textbox is

   type Textbox is new gui.Widget.Typed_Object.Object with record
      Base_Type : mcc.text_entry_types.String_Types :=
                  mcc.text_entry_types.Unbounded_String;
      Base_Type_Dropdown : mcc.tki.Widget.Dropdown.Dropdown_Pointer;
      Color     : mcc.tki.Colors.FG_BG_Color;
      HZ_Scroll : Boolean := False;
      VR_Scroll : Boolean := False;
      -- mcc gui components for entry
      HZ_Scroll_Check : mcc.tki.Widget.Button.Check.Check_Button_Pointer;
      VR_Scroll_Check : mcc.tki.Widget.Button.Check.Check_Button_Pointer;
   end record;

   -- reads information from file into Textbox,
   -- assumes keyword already read.
   procedure Read_Widget (Widget : in out Textbox);

   -- Writes information to file from Textbox
   procedure Write_Widget (Widget : in Textbox);

   -- SAG 08.07.2005
   procedure Generate_Action_Context_Clause
     (Widget : in Textbox);

   -- SAG 08.07.2005
   procedure Generate_Callback_Context_Clause
     (Widget     : in Textbox;
      Windowname : in String);

   function Has_Anything_To_Fill_Or_Read
     (Widget : in Textbox)
      return   Boolean;

   -- SAG 08.07.2005
   procedure Generate_Fill_Action
     (Widget : in Textbox);

   -- SAG 08.07.2005
   procedure Generate_Read_Action
     (Widget : in Textbox);

   -- wbw 6/6/99
   procedure Generate_Widget_Context_Clause
     (Widget : in Textbox);

   -- wbw 6/6/99
   procedure Generate_Widget_Declaration
     (Widget : in Textbox);

   -- display the widget to a window
   procedure Display_Widget
     (Widget    : in out Textbox;
      Container : in out mcc.tki.Container.Container'Class);

   procedure Generate_Widget_Creation
     (Widget      : in Textbox;
      Window_Name : in String);

   procedure Set_Properties (Widget : in out Textbox);

   procedure Apply_Properties (Widget : in out Textbox);
   procedure Check_Properties (Widget : in out Textbox; Ok : out Boolean);

end Gui.Widget.Textbox;
