---------------------------------------------------------------
--
--  RAPID - Rapid Ada Portable Interface Designer
--
--  GUI-WIDGET-LISTBOX.ADS
--  Description : GUI Widget Listbox
--
--  Copyright (C) 1999, Jonathan Busch and Martin Carlisle
--
-- RAPID is free software; you can redistribute it and/or
-- modify it without restriction.  However, we ask that you
-- please retain the original author information, and clearly
-- indicate if it has been modified.
--
-- RAPID is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.
---------------------------------------------------------------
with mcc.tki.Colors;
with mcc.tki.Container;
with mcc.tki.Widget.Button.Check;

package gui.Widget.Listbox is

   type Listbox is new GUI_Widget with record
      Color    : mcc.tki.Colors.FG_BG_Color;
      HZ_Scroll : Boolean := False;
      VR_Scroll : Boolean := False;
      -- mcc gui components for entry
      HZ_Scroll_Check : mcc.tki.Widget.Button.Check.Check_Button_Pointer;
      VR_Scroll_Check : mcc.tki.Widget.Button.Check.Check_Button_Pointer;
   end record;

   -- reads information from file into Listbox,
   -- assumes keyword already read.
   procedure Read_Widget (Widget : in out Listbox);

   -- Writes information to file from Listbox
   procedure Write_Widget (Widget : in Listbox);

   -- wbw 6/6/99
   procedure Generate_Widget_Context_Clause
     (Widget : in Listbox);

   -- wbw 6/6/99
   procedure Generate_Widget_Declaration
     (Widget : in Listbox);

   -- display the widget to a window
   procedure Display_Widget
     (Widget    : in out Listbox;
      Container : in out mcc.tki.Container.Container'Class);

   procedure Generate_Widget_Creation
     (Widget      : in Listbox;
      Window_Name : in String);

   procedure Set_Properties (Widget : in out Listbox);

   procedure Apply_Properties (Widget : in out Listbox);
   procedure Check_Properties (Widget : in out Listbox; Ok : out Boolean);

end Gui.Widget.Listbox;
