---------------------------------------------------------------
--
--  RAPID - Rapid Ada Portable Interface Designer
--
--  GUI-WIDGET-CHECK_BUTTON.ADS
--  Description : GUI Widget Check Button
--
--  Copyright (C) 2000, Martin Carlisle and Patrick Maes
--
-- RAPID is free software; you can redistribute it and/or
-- modify it without restriction.  However, we ask that you
-- please retain the original author information, and clearly
-- indicate if it has been modified.
--
-- RAPID is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.
---------------------------------------------------------------
with Gui.Widget.Typed_Object;
with mcc.tki.Container;
with mcc.tki.Widget.Text_Entry;

package gui.Widget.Check_Button is

   type Check_Button is new Gui.Widget.Typed_Object.Object with record
      Text : String_Pointer;
      Text_Entry : mcc.tki.Widget.Text_Entry.Text_Entry_Pointer;
   end record;

   -- reads information from file into GUI_Widget,
   -- assumes keyword already read.
   procedure Read_Widget (Widget : in out Check_Button);

   -- Writes information to file from GUI_Widget
   procedure Write_Widget (Widget : in Check_Button);

   -- mcc 05/23/00
   procedure Generate_Action_Context_Clause
     (Widget : in Check_Button);

   -- SAG 12.Jul.2001
   procedure Generate_Callback_Context_Clause
     (Widget     : in Check_Button;
      Windowname : in String);

   -- wbw 6/6/99
   procedure Generate_Widget_Context_Clause
     (Widget : in Check_Button);

   -- wbw 6/6/99
   procedure Generate_Widget_Declaration
     (Widget : in Check_Button);

   -- wbw 5/10/99
   procedure Generate_Widget_Creation
     (Widget      : in Check_Button;
      Window_Name : in String);

   function Has_Anything_To_Fill_Or_Read
     (Widget : in Check_Button)
      return   Boolean;

   procedure Generate_Fill_Action
     (Widget : in Check_Button);

   procedure Generate_Read_Action
     (Widget : in Check_Button);

   procedure Display_Widget
     (Widget    : in out Check_Button;
      Container : in out mcc.tki.Container.Container'Class);

   procedure Set_Properties (Widget : in out Check_Button);

   procedure Apply_Properties (Widget : in out Check_Button);

   procedure Check_Properties
     (Widget : in out Check_Button;
      Ok     : out Boolean);

end Gui.Widget.Check_Button;
