---------------------------------------------------------------
--
--  RAPID - Rapid Ada Portable Interface Designer
--
--  FONT_ACTIONS.ADS
--  Description : Actions while selecting a font
--
--  Copyright (C) 1999, Martin C. Carlisle <carlislem@acm.org>
--
-- RAPID is free software; you can redistribute it and/or
-- modify it without restriction.  However, we ask that you
-- please retain the original author information, and clearly
-- indicate if it has been modified.
--
-- RAPID is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.
---------------------------------------------------------------
with gui.Widget;
with mcc.tki.Widget.Button;
with mcc.tki.Container.Window;
package Font_Actions is
   -- called to start font selection dialog
   procedure Change_Font (The_Widget : in gui.Widget.Widget_Access);

   procedure Ok_Pressed (Obj : in out mcc.tki.Widget.Button.Button'Class);

   procedure Default_Font (Obj : in out mcc.tki.Widget.Button.Button'Class);

   procedure Cancel_Dialog
     (Obj : in out mcc.tki.Widget.Button.Button'Class);
   procedure Cancel_Dialog
     (Obj : in out mcc.tki.Container.Window.Window'Class);

   -- make a nice display of a string which is the result of
   -- using 'image on an enumeration type.
   -- This really shouldn't live here, but it is where I
   -- first used it.
   function Display_Enum (Item : in String) return String;
end Font_Actions;
