---------------------------------------------------------------
--
--  RAPID - Rapid Ada Portable Interface Designer
--
--  EDIT_MENU.ADS
--  Description : Implements choices from the Edit menu
--
--  Copyright (C) 1999, Martin C. Carlisle <carlislem@acm.org>
--
-- RAPID is free software; you can redistribute it and/or
-- modify it without restriction.  However, we ask that you
-- please retain the original author information, and clearly
-- indicate if it has been modified.
--
-- RAPID is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.
---------------------------------------------------------------
-- These are the procedures called when
-- something is chosen from the Edit menu.
---------------------------------------------------------------
with mcc.tki.Widget.Button;

package Edit_Menu is

   -- used to modify window properties (name/size)
   procedure Change_Window; -- Modify window choice
   procedure Delete_Choice
     (Obj : in out mcc.tki.Widget.Button.Button'Class);
   procedure Delete_Choice;
   procedure Duplicate_Choice
     (Obj : in out mcc.tki.Widget.Button.Button'Class);
   procedure Duplicate_Choice;

   -- These 3 are called from the window generated
   -- when you modify the window you are editing
   -- You can apply the changes, cancel them, or push
   -- OK to apply and close the modify window.
   procedure Change_Done;
   procedure Change_Done (Obj : in out mcc.tki.Widget.Button.Button'Class);
   procedure Apply_Changes;
   procedure Apply_Changes
     (Obj : in out mcc.tki.Widget.Button.Button'Class);
   procedure Cancel_Changes;
   procedure Cancel_Changes
     (Obj : in out mcc.tki.Widget.Button.Button'Class);

end Edit_Menu;
