with mcc.gui.container.window;
with ada.text_io;
with gdk.event;
with gtk.widget;
with mcc.gui.widget.label;
with mcc.gui.widget.button.picture;
with mcc.gui.image;
with mcc.gui.colors;

procedure window2 is
   Window  : aliased mcc.gui.container.window.main_window;
   label   : aliased mcc.gui.widget.label.label;
   button  : aliased mcc.gui.widget.button.picture.picture_button;
   image   : aliased mcc.gui.image.external_image;

   procedure Key_Listener (
      Obj   : in out mcc.gui.Sized_Object'Class;
      Event : in     mcc.gui.Key_Event) is
   begin
      ada.text_io.put_line("key " &
         mcc.gui.key_action_type'image(event.action) &
         mcc.gui.key_type'image(event.key));
   end Key_Listener;

   procedure Mouse_Listener (
      Obj   : in out mcc.gui.Sized_Object'Class;
      Event : in     mcc.gui.Mouse_Event) is
   begin
      ada.text_io.put_line(
         mcc.gui.mouse_action_type'image(event.action) & " " &
         mcc.gui.mouse_button'image(event.button) &
         natural'image(event.x) & natural'image(event.y));
   end Mouse_Listener;


   procedure resize_procedure(
      obj : in out mcc.gui.container.window.window'class;
      width : in integer;
      height :in integer) is
   begin
      if width /= 300 or else height /= 300 then
         ada.text_io.put_line(integer'image(width) &
            integer'image(height));
         mcc.gui.resize(mcc.gui.sized_object(obj),300,300);
      end if;
   end resize_procedure;

   procedure push_procedure(button : in out mcc.gui.widget.button.button'class) is
   begin
      ada.text_io.put_line("button pushed");
   end push_procedure;
begin
   -- test window functions
   mcc.gui.container.window.create(window,
      100,100,300,300);
   mcc.gui.container.window.set_title(window,"Fr""ed");

   mcc.gui.container.window.hide(window);
   delay 1.0;
   mcc.gui.container.window.show(window);
   mcc.gui.container.window.set_resize_handler(window'unchecked_access,
      resize_procedure'unrestricted_access);
   mcc.gui.container.window.to_top(window);
   Mcc.Gui.Widget.Label.Create
     (Obj     => Label,
      Parent  => Window,
      X       => 10,
      Y       => 10,
      Width   => 50,
      Height  => 20,
      Justify => Mcc.Gui.Widget.Label.Left,
      Text    => "First widget!");
   Mcc.Gui.Widget.Label.Set_Foreground_Color(
      Obj => Label,
      New_Color => Mcc.Gui.Colors.Named_Color(Mcc.Gui.Colors.Blue));
   Mcc.Gui.Widget.Label.Set_Background_Color(
      Obj => Label,
      New_Color => Mcc.Gui.Colors.Named_Color(Mcc.Gui.Colors.Green));
   mcc.gui.image.create(image,"magick.xpm");
   mcc.gui.widget.button.picture.create(button,window,
      100,14,134,130,mcc.gui.image.image(image));
   mcc.gui.set_mouse_listener(button'unchecked_access,
      mouse_listener'unrestricted_access);
   mcc.gui.set_key_listener(button'unchecked_access,
      key_listener'unrestricted_access);
   mcc.gui.widget.button.set_push_callback(button'unchecked_access,
      push_procedure'unrestricted_access);
   Mcc.Gui.Container.Window.Set_Background_Color(
      Obj => window,
      New_Color => Mcc.Gui.Colors.Named_Color(Mcc.Gui.Colors.Black));
   mcc.gui.widget.button.picture.set_tooltip_text(
      Obj => button,
      Text => "A tooltip!");
   --gdk.event.set_show_events;
   mcc.gui.container.window.event_loop;
end window2;
