-------------------------------------------------------------------
--           RAPID - RAPID ADA PORTABLE INTERFACE DESIGNER
--           MCC TKI (ToolKit Interface) library
--           Copyright (C) 1999 Martin C. Carlisle.
--
-- RAPID is free software;  you can  redistribute it  and/or modify
-- it under terms of the  GNU General Public License as published
-- by the Free Software  Foundation;  either version 2,  or (at your
-- option) any later version.  RAPID is distributed in the hope that
-- it will be useful, but WITHOUT ANY WARRANTY;  without even the
-- implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
-- PURPOSE.  See the GNU General Public License for more details.
-- You should have  received  a copy of the GNU General Public License
-- distributed with RAPID; see file COPYING.  If not, write to the
-- Free Software Foundation,  59 Temple Place - Suite 330,  Boston,
-- MA 02111-1307, USA.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.  This exception does not apply to executables which
-- are GUI design tools, or that could act as a replacement
-- for RAPID.
------------------------------------------------------------------------------
with mcc.Msg;
with Gtk.Window;
with Mcc.Directory_Operations;

package body peer.Image is

   ----------------
   -- Initialize --
   ----------------

   procedure Initialize
     (Image  : in out Mcc_Gtk_Image_Record;
      Widget : in Gtk.Widget.Gtk_Widget)
   is
      use type Gtk.Pixmap.Gtk_Pixmap;
      Toplevel : Gtk.Window.Gtk_Window :=
         Gtk.Window.Gtk_Window (Gtk.Widget.Get_Toplevel (Widget));
   begin
      if Image.Initialized then
         return;
      end if;
      if Mcc.Directory_Operations.Is_Regular_File (Image.Filename.all) then
         Image.Pixmap :=
            Gtk.Pixmap.Create_Pixmap
              (Filename => Image.Filename.all,
               Window   => Toplevel);
         Image.Initialized := True;
         Gtk.Pixmap.Show (Image.Pixmap);
      elsif Mcc.Directory_Operations.Is_Regular_File
              (Mcc.Directory_Operations.Rapid_Root_Dir.all &
               Image.Filename.all) then
         Image.Pixmap :=
            Gtk.Pixmap.Create_Pixmap
              (Filename => Mcc.Directory_Operations.Rapid_Root_Dir.all &
                           Image.Filename.all,
               Window   => Toplevel);
         Image.Initialized := True;
         Gtk.Pixmap.Show (Image.Pixmap);
      else
         mcc.Msg.Error
           ("Peer.Image.Initialize: " & Image.Filename.all & " not found");
      end if;
   end Initialize;

end Peer.Image;
