-------------------------------------------------------------------
--           RAPID - RAPID ADA PORTABLE INTERFACE DESIGNER
--           MCC TKI (ToolKit Interface) library
--           Copyright (C) 1999 Martin C. Carlisle.
--
-- RAPID is free software;  you can  redistribute it  and/or modify
-- it under terms of the  GNU General Public License as published
-- by the Free Software  Foundation;  either version 2,  or (at your
-- option) any later version.  RAPID is distributed in the hope that
-- it will be useful, but WITHOUT ANY WARRANTY;  without even the
-- implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
-- PURPOSE.  See the GNU General Public License for more details.
-- You should have  received  a copy of the GNU General Public License
-- distributed with RAPID; see file COPYING.  If not, write to the
-- Free Software Foundation,  59 Temple Place - Suite 330,  Boston,
-- MA 02111-1307, USA.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.  This exception does not apply to executables which
-- are GUI design tools, or that could act as a replacement
-- for RAPID.
------------------------------------------------------------------------------
with Glib;          use Glib;
with Gtk.List_Item;
with Gtk.Widget;
package body peer.Gtk_List is

   ---------------
   -- Add_Entry --
   ---------------

   procedure Add_Entry
     (Obj      : in Gtk.List.Gtk_List;
      Location : in Natural;
      Text     : in String)
   is
      New_Label : Gtk.List_Item.Gtk_List_Item;
      Temp_List : Gtk.Widget.Widget_List.Glist;
   begin
      --Create a new label
      Gtk.List_Item.Gtk_New (List_Item => New_Label, Label => Text);
      Gtk.List_Item.Show (New_Label);
      --Create Glist and add text widget
      Temp_List := Gtk.Widget.Widget_List.Null_List;
      Gtk.Widget.Widget_List.Append
        (List => Temp_List,
         Data => Gtk.Widget.Gtk_Widget (New_Label));
      Gtk.List.Insert_Items
        (List     => Obj,
         Items    => Temp_List,
         Position => Gint (Location));
      --Free Glist from memory / I assume that I need to do this since I
      --allocated it
      --gtk.widget.Widget_List.Free(List => Temp_List);
   end Add_Entry;

   -----------
   -- Clear --
   -----------

   procedure Clear (Obj : in Gtk.List.Gtk_List) is
   begin
      Gtk.List.Clear_Items (List => Obj, Start => 0, The_End => -1);
   end Clear;

   -----------
   -- Count --
   -----------

   function Count (Obj : in Gtk.List.Gtk_List) return Natural is
      Children : Gtk.Widget.Widget_List.Glist;
      Length   : Natural;
   begin
      Children := Gtk.List.Get_Children (Widget => Obj);
      Length   := Natural (Gtk.Widget.Widget_List.Length (List => Children));
      return Length;
   end Count;

   ------------------
   -- Delete_Entry --
   ------------------

   procedure Delete_Entry
     (Obj   : in Gtk.List.Gtk_List;
      Start : in Natural;
      Stop  : in Natural)
   is
   begin
      -- it kind of confuses me that stop isn't decremented by 1, but
      -- it seems to work this way
      Gtk.List.Clear_Items
        (List    => Obj,
         Start   => Gint (Start - 1),
         The_End => Gint (Stop));
   end Delete_Entry;

   ------------------
   -- Get_Selected --
   ------------------

   function Get_Selected (Obj : in Gtk.List.Gtk_List) return Natural is
      Position                  : Natural := 0;
      Full_List, Selection_List : Gtk.Widget.Widget_List.Glist;
      use type Gtk.Widget.Widget_List.Glist;
   begin
      Full_List      := Gtk.List.Get_Children (Widget => Obj);
      Selection_List := Gtk.List.Get_Selection (Widget => Obj);
      if Selection_List = Gtk.Widget.Widget_List.Null_List then
         return 0;
      end if;
      Position :=
        Natural (Gtk.Widget.Widget_List.Index
                    (List => Full_List,
                     Data =>
                        Gtk.Widget.Widget_List.Get_Data
                          (List =>
                              Gtk.Widget.Widget_List.First
                                (List => Selection_List))));
      return Position + 1;
   end Get_Selected;

   -----------------
   -- Select_Item --
   -----------------

   procedure Select_Item (Obj : in Gtk.List.Gtk_List; Number : in Natural) is
   begin
      Gtk.List.Select_Item (List => Obj, Item => Gint (Number - 1));
   end Select_Item;

end Peer.Gtk_List;
