-------------------------------------------------------------------
--           RAPID - RAPID ADA PORTABLE INTERFACE DESIGNER
--           TCL PEER FOR THE MCC TKI (ToolKit Interface) library
--           Copyright (C) 1999 Martin C. Carlisle.
--
-- RAPID is free software;  you can  redistribute it  and/or modify
-- it under terms of the  GNU General Public License as published
-- by the Free Software  Foundation;  either version 2,  or (at your
-- option) any later version.  RAPID is distributed in the hope that
-- it will be useful, but WITHOUT ANY WARRANTY;  without even the
-- implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
-- PURPOSE.  See the GNU General Public License for more details.
-- You should have  received  a copy of the GNU General Public License
-- distributed with RAPID; see file COPYING.  If not, write to the
-- Free Software Foundation,  59 Temple Place - Suite 330,  Boston,
-- MA 02111-1307, USA.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.  This exception does not apply to executables which
-- are GUI design tools, or that could act as a replacement
-- for RAPID.
------------------------------------------------------------------------------

with mcc.Msg;
with Ada.Unchecked_Conversion;
with Gtk.Object;
with Gtk.Text;
with mcc.tki.Widget.Peer;

package body mcc.tki.Widget.Textbox is

   Max_Text_Length : constant := 13680;

   Text : String (1 .. Max_Text_Length);

   ---------------
   -- Highlight --
   ---------------

   procedure Highlight
     (Obj   : in out Textbox;
      Start : in Natural;
      Stop  : in Natural)
   is
   begin
      null;  -- TODO
   end Highlight;

   procedure Highlight (Obj : in out Textbox) is
   begin

      null;  -- TODO

   exception

      when E : others =>
         mcc.Msg.Error (E, "mcc.tki.Widget.Textbox.Highlight.Obj");

   end Highlight;

   -----------
   -- Clear --
   -----------

   procedure Clear (Obj : in out Textbox) is
   begin

      null;  -- TODO

   exception

      when E : others =>
         mcc.Msg.Error (E, "mcc.tki.Widget.Textbox.Highlight.Clear");

   end Clear;

   procedure Create
     (Obj                  : in out Textbox;
      Parent               : in mcc.tki.Container.Container'Class;
      X                    : in Integer;
      Y                    : in Integer;
      Width                : in Natural;
      Height               : in Natural;
      Horizontal_Scrollbar : in Boolean;
      Vertical_Scrollbar   : in Boolean)
   is

      The_Peer : Gtk.Text.Gtk_Text;

      type Parent_Access is access constant mcc.tki.Container.Container'Class;
      function Convert is new Ada.Unchecked_Conversion (
         Parent_Access,
         mcc.tki.Container.Container_Pointer);
   begin

      Gtk.Text.Gtk_New (The_Peer);
      Obj.My_Peer := Gtk.Object.Gtk_Object (The_Peer);
      mcc.tki.Widget.Peer.Setup
        (Obj    => Obj,
         X      => X,
         Y      => Y,
         Width  => Width,
         Height => Height,
         Parent => Parent);
      Gtk.Text.Set_Word_Wrap (The_Peer, True);

      Obj.Parent := Convert (Parent'Unchecked_Access);

   exception

      when E : others =>
         mcc.Msg.Error (E, "mcc.tki.Widget.Textbox.Highlight.Create");

   end Create;

   procedure Set_Text (Obj : in out Textbox; Text : in String) is
   begin

      null;  -- TODO

   exception

      when E : others =>
         mcc.Msg.Error (E, "mcc.tki.Widget.Textbox.Highlight.Set_Text");

   end Set_Text;

   --------------
   -- Get Text --
   --------------

   function Get_Text (Obj : in Textbox) return String is
      Last : Natural;
   begin

      return " ";  -- TODO

   exception

      when E : others =>
         mcc.Msg.Error (E, "mcc.tki.Widget.Textbox.Highlight.Get_Text.String");
         return " ";

   end Get_Text;

   ---------------------
   -- Get_Text_Length --
   ---------------------

   function Get_Text_Length (Obj : in Textbox) return Natural is
      Result : String := Get_Text (Obj);

   begin

      return Result'Length;

   exception

      when E : others =>
         mcc.Msg.Error (E, "mcc.tki.Widget.Textbox.Highlight.Get_Text_Length");
         return 0;

   end Get_Text_Length;

end mcc.tki.Widget.Textbox;
