-------------------------------------------------------------------
--           RAPID - RAPID ADA PORTABLE INTERFACE DESIGNER
--           MCC TKI (ToolKit Interface) library
--           Copyright (C) 1999 Martin C. Carlisle.
--
-- RAPID is free software;  you can  redistribute it  and/or modify
-- it under terms of the  GNU General Public License as published
-- by the Free Software  Foundation;  either version 2,  or (at your
-- option) any later version.  RAPID is distributed in the hope that
-- it will be useful, but WITHOUT ANY WARRANTY;  without even the
-- implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
-- PURPOSE.  See the GNU General Public License for more details.
-- You should have  received  a copy of the GNU General Public License
-- distributed with RAPID; see file COPYING.  If not, write to the
-- Free Software Foundation,  59 Temple Place - Suite 330,  Boston,
-- MA 02111-1307, USA.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.  This exception does not apply to executables which
-- are GUI design tools, or that could act as a replacement
-- for RAPID.
------------------------------------------------------------------------------
with mcc.text_entry_types;
with mcc.tki.Widget.Peer;
with Gtk.Object;
with Gtk.GEntry;
with Gdk.Event;
with Glib;                 use Glib;
with Gtk.Widget;
with Gtk.Enums; -- 20030424ph
package body mcc.tki.Widget.Text_Entry is

   -----------
   -- Clear --
   -----------

   procedure Clear (Obj : in out Text_Entry) is
   begin
      Gtk.GEntry.Set_Text
        (The_Entry => Gtk.GEntry.Gtk_Entry (Obj.My_Peer),
         Text      => "");
   end Clear;

   ------------
   -- Create --
   ------------

   procedure Create
     (Obj    : in out Text_Entry;
      Parent : in mcc.tki.Container.Container'Class;
      X      : in Integer;
      Y      : in Integer;
      Width  : in Natural;
      Height : in Natural)
   is
      New_Entry : Gtk.GEntry.Gtk_Entry;
      use type Gdk.Event.Gdk_Event_Mask;
   begin
      Gtk.GEntry.Gtk_New (Widget => New_Entry);

      --Have Object point to Entry Widget
      Obj.My_Peer := Gtk.Object.Gtk_Object (New_Entry);
      Gtk.Widget.Add_Events
        (Widget => Gtk.Widget.Gtk_Widget (New_Entry),
         Events => Gdk.Event.Button_Motion_Mask +
                   Gdk.Event.Key_Release_Mask +
                   Gdk.Event.Key_Press_Mask +
                   Gdk.Event.Button_Press_Mask +
                   Gdk.Event.Button_Release_Mask +
                   Gdk.Event.Pointer_Motion_Mask);

      mcc.tki.Widget.Peer.Setup
        (Obj    => Obj,
         X      => X,
         Y      => Y,
         Width  => Width,
         Height => Height,
         Parent => Parent);
   end Create;

   procedure Disable (Obj : in out Text_Entry) is
   begin
      Gtk.Widget.Set_State
        (Gtk.Widget.Gtk_Widget (Obj.My_Peer),
         Gtk.Enums.State_Insensitive);
   end Disable;

   procedure Enable (Obj : in out Text_Entry) is
   begin
      Gtk.Widget.Set_State
        (Gtk.Widget.Gtk_Widget (Obj.My_Peer),
         Gtk.Enums.State_Normal);
   end Enable;

   --------------
   -- Get_Text --
   --------------

   function Get_Text (Obj : in Text_Entry) return String is
   begin
      return Gtk.GEntry.Get_Text (Gtk.GEntry.Gtk_Entry (Obj.My_Peer));
   end Get_Text;

   function Get_Text (Obj : in Text_Entry) return Interfaces.Unsigned_32 is
   begin
      return Interfaces.Unsigned_32'Value (Get_Text (Obj));
   end Get_Text;

   --------------
   -- Get_Text --
   --------------

   function Get_Text (Obj : in Text_Entry) return Integer is
   begin
      return Integer'Value
               (Gtk.GEntry.Get_Text (Gtk.GEntry.Gtk_Entry (Obj.My_Peer)));
   end Get_Text;

   --------------
   -- Get_Text --
   --------------

   function Get_Text (Obj : in Text_Entry) return Float is
   begin
      return Float'Value
               (Gtk.GEntry.Get_Text (Gtk.GEntry.Gtk_Entry (Obj.My_Peer)));
   end Get_Text;

   ---------------------
   -- Get_Text_Length --
   ---------------------

   function Get_Text_Length (Obj : in Text_Entry) return Natural is
   begin
      declare
         Temp : String := Get_Text (Obj);
      begin
         return Temp'Length;
      end;
   end Get_Text_Length;

   ---------------
   -- Highlight --
   ---------------

   procedure Highlight (Obj : in out Text_Entry) is
   begin
      Highlight (Obj => Obj, Start => 0, Stop => Get_Text_Length (Obj));
   end Highlight;

   ---------------
   -- Highlight --
   ---------------

   procedure Highlight
     (Obj   : in out Text_Entry;
      Start : in Natural;
      Stop  : in Natural)
   is
   begin--Highlight
      Gtk.GEntry.Select_Region
        (Editable => Gtk.GEntry.Gtk_Entry (Obj.My_Peer),
         Start    => Glib.Gint (Start),
         The_End  => Glib.Gint (Stop));
   end Highlight;

   --------------
   -- Set_Text --
   --------------

   procedure Set_Text (Obj : in out Text_Entry; Text : in String) is
   begin
      Gtk.GEntry.Set_Text
        (The_Entry => Gtk.GEntry.Gtk_Entry (Obj.My_Peer),
         Text      => Text);
   end Set_Text;

   ------------------------------------------------
   -- procedure Set_Text
   --
   -- Set text for a text entry using
   -- image of integer (w/o leading spaces)
   ------------------------------------------------
   procedure Set_Text (Obj : in out Text_Entry; Text : in Integer) is
   begin
      Set_Text (Obj, mcc.Img (Text));
   end Set_Text;

   procedure Set_Text
     (Obj  : in out Text_Entry;
      Text : in Interfaces.Unsigned_32)
   is
   begin
      Set_Text (Obj, mcc.text_entry_types.Image (Text));
   end Set_Text;

   ------------------------------------------------
   -- procedure Set_Text
   --
   -- Set text for a text entry using
   -- image of float (w/o leading spaces)
   ------------------------------------------------
   procedure Set_Text (Obj : in out Text_Entry; Text : in Float) is
      Txt : constant String := Float'Image (Text);
   begin
      if Txt (1) = ' ' then
         -- set image of float w/o leading space
         Set_Text (Obj, Txt (2 .. Txt'Last));
      else
         Set_Text (Obj, Txt);
      end if;
   end Set_Text;

end mcc.tki.Widget.Text_Entry;
