-------------------------------------------------------------------
--           RAPID - RAPID ADA PORTABLE INTERFACE DESIGNER
--           MCC TKI (ToolKit Interface) library
--           Copyright (C) 1999 Martin C. Carlisle.
--
-- RAPID is free software;  you can  redistribute it  and/or modify
-- it under terms of the  GNU General Public License as published
-- by the Free Software  Foundation;  either version 2,  or (at your
-- option) any later version.  RAPID is distributed in the hope that
-- it will be useful, but WITHOUT ANY WARRANTY;  without even the
-- implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
-- PURPOSE.  See the GNU General Public License for more details.
-- You should have  received  a copy of the GNU General Public License
-- distributed with RAPID; see file COPYING.  If not, write to the
-- Free Software Foundation,  59 Temple Place - Suite 330,  Boston,
-- MA 02111-1307, USA.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.  This exception does not apply to executables which
-- are GUI design tools, or that could act as a replacement
-- for RAPID.
------------------------------------------------------------------------------
with Glib;
with Gtk.Button;
with Gtk.Enums;
with Gtk.Object;
with Gtk.Widget;
with mcc.Gtk_Signals;
with peer.Style;
with System;
with mcc.Msg;

package body mcc.tki.Widget.Button is
   package Mcc_Object_Callback is new mcc.Gtk_Signals.Object_Callback_Void (
      Base_Type => Button,
      Widget_Type => Button_Pointer);

   procedure Mcc_Push_Callback (Glib_Obj : System.Address) is
      Obj : Button_Pointer := Mcc_Object_Callback.Find (Glib_Obj);
   begin
      if Obj = null then
         mcc.Msg.Debug
           ("mcc.tki.Widget.Button.Mcc_Push_Callback: Obj is null !");
      elsif Obj.Push_Handler = null then
         mcc.Msg.Debug
           ("mcc.tki.Widget.Button.Mcc_Push_Callback: Obj.Push_Handler is null"
);
      else
         mcc.Msg.Debug(
"mcc.tki.Widget.Button.Mcc_Push_Callback: invoking Obj.Push_Handler");
         Obj.Push_Handler.all (Obj.all);
      end if;
   end Mcc_Push_Callback;

   -------------
   -- Depress --
   -------------

   procedure Depress (Obj : in out Button) is
   begin
      Gtk.Button.Pressed (Gtk.Button.Gtk_Button (Obj.My_Peer));
      Gtk.Button.Set_Relief
        (Gtk.Button.Gtk_Button (Obj.My_Peer),
         Gtk.Enums.Relief_None);
   end Depress;

   -------------
   -- Disable --
   -------------

   procedure Disable (Obj : in out Button) is
   begin
      Gtk.Widget.Set_State
        (Gtk.Widget.Gtk_Widget (Obj.My_Peer),
         Gtk.Enums.State_Insensitive);
   end Disable;

   ------------
   -- Enable --
   ------------

   procedure Enable (Obj : in out Button) is
   begin
      Gtk.Widget.Set_State
        (Gtk.Widget.Gtk_Widget (Obj.My_Peer),
         Gtk.Enums.State_Normal);
   end Enable;

   -----------------------
   -- Get_Push_Callback --
   -----------------------

   function Get_Push_Callback (Obj : in Button'Class) return Push_Callback is
   begin
      return Obj.Push_Handler;
   end Get_Push_Callback;

   -------------
   -- Release --
   -------------

   procedure Release (Obj : in out Button) is
   begin
      Gtk.Button.Released (Gtk.Button.Gtk_Button (Obj.My_Peer));
      Gtk.Button.Set_Relief
        (Gtk.Button.Gtk_Button (Obj.My_Peer),
         Gtk.Enums.Relief_Normal);
   end Release;

   -----------------------
   -- Set_Push_Callback --
   -----------------------

   procedure Set_Push_Callback
     (Obj      : in Button_Pointer;
      Callback : in Push_Callback)
   is
      Cb_Id : Glib.Guint;
   begin
      if Obj.Push_Handler = null then
         Cb_Id :=
            Mcc_Object_Callback.Connect
              (Obj         => Gtk.Object.Gtk_Object (Obj.My_Peer),
               Name        => "clicked",
               Func        => Mcc_Push_Callback'Access,
               Slot_Object => Obj);
         mcc.Msg.Debug(
"mcc.tki.Widget.Button.Set_Push_Callback: Obj.Push_Handler is null, doing Mcc_Object_Callback.Connect"
);
      else
         mcc.Msg.Debug(
"mcc.tki.Widget.Button.Set_Push_Callback: Obj.Push_Handler is not null !");
      end if;
      Obj.Push_Handler := Callback;
   end Set_Push_Callback;

   --------------
   -- Set_Text --
   --------------

   procedure Set_Text (Obj : in out Labeled_Button; Text : in String) is
   begin
      peer.Style.Set_Text_Recursively
        (Widget => Gtk.Widget.Gtk_Widget (Obj.My_Peer),
         Text   => Text);
   end Set_Text;

end mcc.tki.Widget.Button;
