/*
 * 	Random Access Machine.
 * 	Header for the verbosity control module.
 *
 * 	Copyright (C) 2003  Dmitry Rutsky	<rutsky@school.ioffe.rssi.ru>
 * 	
 * 	This program is free software; you can redistribute it and/or modify
 * 	it under the terms of the GNU General Public License as published by
 * 	the Free Software Foundation; either version 2 of the License, or
 * 	(at your option) any later version.
 *
 * 	This program is distributed in the hope that it will be useful,
 * 	but WITHOUT ANY WARRANTY; without even the implied warranty of
 * 	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * 	GNU General Public License for more details.
 *
 * 	You should have received a copy of the GNU General Public License
 * 	along with this program; if not, write to the 
 * 	Free Software Foundation, Inc.,
 * 	59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef __verbosity_h
#define __verbosity_h

//
// The verbosity level indicates which comments the program will annoy you with.
//

typedef enum
{
   VERBOSITY_FATAL_ERRORS = -1,
   VERBOSITY_ERRORS,
   VERBOSITY_IMPORTANT_WARNINGS, // default
   VERBOSITY_WARNINGS,
   VERBOSITY_DEBUG,
   VERBOSITY_EXTENSIVE_DEBUG	// annoying
}
Verbosity;

inline int verbosity_get ();
inline int verbosity_set (const Verbosity);

inline int verbosity_is_enough (const Verbosity min);

inline int verbosity_increase ();
inline int verbosity_decrease ();

const char *verbosity_description_string (Verbosity level);

#endif /* __verbosity_h */
