/*
 * 	Random Access Machine.
 * 	Verbosity control.
 *
 * 	Copyright (C) 2003  Dmitry Rutsky	<rutsky@school.ioffe.rssi.ru>
 * 	
 * 	This program is free software; you can redistribute it and/or modify
 * 	it under the terms of the GNU General Public License as published by
 * 	the Free Software Foundation; either version 2 of the License, or
 * 	(at your option) any later version.
 *
 * 	This program is distributed in the hope that it will be useful,
 * 	but WITHOUT ANY WARRANTY; without even the implied warranty of
 * 	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * 	GNU General Public License for more details.
 *
 * 	You should have received a copy of the GNU General Public License
 * 	along with this program; if not, write to the 
 * 	Free Software Foundation, Inc.,
 * 	59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include "verbosity.h"

/* =======	Verbosity control	======== */

static Verbosity verbosity = VERBOSITY_IMPORTANT_WARNINGS;

inline int verbosity_get ()
{
   return verbosity;
}

inline int verbosity_set (const Verbosity level)
{
   int old_level = verbosity;

   verbosity = level;

   return old_level;
}

inline int verbosity_is_enough (const Verbosity min)
{
   return (verbosity >= min);
}

inline int verbosity_increase ()
{
   verbosity ++;

   return verbosity;
}

inline int verbosity_decrease ()
{
   verbosity --;

   return verbosity;
}

/* ========	Verbosity user-readable description	======== */

const char *verbosity_description_string (Verbosity level)
{
   const char *description_string [6] =
   {
      "fatal errors", "errors", "important warnings", "warnings", 
      "debug", "extensive debug"
   };

   if (level < VERBOSITY_FATAL_ERRORS)
      return "lower than fatal errors";

   if (level > VERBOSITY_EXTENSIVE_DEBUG)
      return "higher than extensive debug";

   return description_string [level - VERBOSITY_FATAL_ERRORS];
}
