/*
 * 	Random Access Machine.
 * 	Arbitrary length line reading module.
 *
 * 	Copyright (C) 2002, 2003  Dmitry Rutsky	<rutsky@school.ioffe.rssi.ru>
 * 	
 * 	
 * 	This program is free software; you can redistribute it and/or modify
 * 	it under the terms of the GNU General Public License as published by
 * 	the Free Software Foundation; either version 2 of the License, or
 * 	(at your option) any later version.
 *
 * 	This program is distributed in the hope that it will be useful,
 * 	but WITHOUT ANY WARRANTY; without even the implied warranty of
 * 	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * 	GNU General Public License for more details.
 *
 * 	You should have received a copy of the GNU General Public License
 * 	along with this program; if not, write to the 
 * 	Free Software Foundation, Inc.,
 * 	59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 	
 * 	
 * 	NOTE:  it works for files only, since it uses two pass reading (don't
 * 	blame me for it, this module is ancient).
 * 	
 * 	TODO:  replace this module with something more standard.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "str_read.h"
#include "error.h"

// TODO:  these functions could be tracing system errors during `fgetc' calls.

int is_same_as (FILE *f, int c_check)
{
   int c;
   
   c = fgetc (f);
   
   if (c != EOF)
      ungetc (c, f);
   
   return (c == c_check); 
}

int is_EOF (FILE *f)
{
   return is_same_as (f, EOF);
}

int string_in_file_length (FILE *f)
{
   int read = 0;
   int begin_pos;
   int length;

   if (is_EOF (f))
      return 0;

   begin_pos = ftell (f);

   for (length = 0; (read != '\n') && (read != EOF); length ++)
      read = fgetc (f);

   fseek (f, begin_pos, SEEK_SET);

   return length;      
}

void skip_line (FILE *f)
{
   int read;
   
   do
      read = fgetc (f);
   while ((read != EOF) && (read != '\n'));
}

/*
 * 	This function skips all the empty lines, and reads it into the buffer
 * 	of the exact length
 * 	in order to know it.  This way it makes two passes over the same data --
 * 	probably not very advanced way.
 */
char *read_line_and_return_it (FILE *f)
{
   char *line;
   int length;
   
   if (is_EOF (f))
      return NULL;
   
   length = string_in_file_length (f);
   if (! length)
      return NULL;

   line = (char *) malloc (length + 1);
   if (!line)
      err_fatal_perror ("malloc",
	"read_line_and_return_it: couldn't allocate memory for the line "
				"(%d bytes)", length + 1);
   
   fgets (line, length + 1, f);
   
   return line;
}

// TODO:  improve this inefficient code
char *read_noncomment_line_and_return_it (FILE *f)
{
   while (1)
   {
      char *l = read_line_and_return_it (f),
      	*c;
      
      if (!l)
	 return NULL;
      
      c = l;
      while (*c && isspace (*c))
	 c ++;

      if (*c == '\0')
	 err_programming
		 ("read_line_and_return_it returned blank line");

      if (!strncmp (c, "//", 2) || *c == '#')
	 free (l);
      else
	 return l;
   }
}

