%{
/*
 *	LEX specification for configuration file lexical analyzer.
 *
 * 	Copyright (C) 2003  Dmitry Rutsky	<rutsky@school.ioffe.rssi.ru>
 * 	
 * 	This program is free software; you can redistribute it and/or modify
 * 	it under the terms of the GNU General Public License as published by
 * 	the Free Software Foundation; either version 2 of the License, or
 * 	(at your option) any later version.
 *
 * 	This program is distributed in the hope that it will be useful,
 * 	but WITHOUT ANY WARRANTY; without even the implied warranty of
 * 	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * 	GNU General Public License for more details.
 *
 * 	You should have received a copy of the GNU General Public License
 * 	along with this program; if not, write to the 
 * 	Free Software Foundation, Inc.,
 * 	59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "configuration.h"
#include "error.h"

#define	YY_DECL	char *conf_lexan ()

%}

%option noyywrap

delim	[ \t\n]
ws	{delim}+

letter	[A-Za-z]
digit	[0-9]
punc	\.|\,|\?|\!|\`|\~|\@|\#|\$|\%|\^|\&|\*|\(|\)|\-|\_|\|\:|\;|\<|\>|\=|\+
c_sym	{letter}|{digit}|{punc}
quotation	\"
b_seq	\\n|\\t|\\\\|\\\|\\\ |\\\"|\\\t
s_seq_e	({c_sym}|{b_seq})
s_seq	{c_sym}+

string	{s_seq}
quoted_string	{quotation}{s_seq_e}{quotation}

cxx_comment	\/\/[^\n]*(\n)?
c_comment	\/\*([^*]|\*[^/])*\*\/

%%

{ws}|{c_comment}|{cxx_comment}	{ }
{string}	{ return conf_build_string (yytext); }
{quoted_string}	{ return conf_build_unquoted_string (yytext); }
.	{ err_error ("lexical error in the configuration file at line %d.",
		yylineno); }
