#
# spec file for quilt - patch management scripts
#

Name:		quilt
Summary:	Scripts for working with series of patches
License:	GPL
Group:		Productivity/Text/Utilities
Version:	0.40
Release:	1
Requires:	coreutils diffutils patch gzip bzip2 perl mktemp gettext
Autoreqprov:	off
Source:		quilt-%{version}.tar.gz
BuildRoot:	%{_tmppath}/%{name}-%{version}-build

%description
The scripts allow to manage a series of patches by keeping
track of the changes each patch makes. Patches can be
applied, un-applied, refreshed, etc.

The scripts are heavily based on Andrew Morton's patch scripts
found at http://www.zip.com.au/~akpm/linux/patches/.

Authors:
--------
    Andrew Morton <akpm@digeo.com>
    Andreas Gruenbacher <agruen@suse.de>

%prep
%setup

%build
./configure
make prefix=/usr BUILD_ROOT=$RPM_BUILD_ROOT

%install
rm -rf $RPM_BUILD_ROOT
make install prefix=/usr BUILD_ROOT=$RPM_BUILD_ROOT
%{find_lang} %{name}

%clean
rm -rf $RPM_BUILD_ROOT

%files -f %{name}.lang
%defattr(-, root, root)
/usr/bin/guards
/usr/bin/quilt
/usr/share/quilt/
/usr/lib/quilt/
/etc/bash_completion.d/quilt
%doc %{_mandir}/man1/guards.1.gz
%doc %{_mandir}/man1/quilt.1.gz
%doc %{_docdir}/%{name}-%{version}/README
%doc %{_docdir}/%{name}-%{version}/quilt.pdf

%changelog
* ven avr 29 2005 - agruen@suse.de
- Add trailing-whitespace check an --strip-trailing-whitespace
  option to the refresh command.
- Bump version to 0.40.
* mar avr 19 2005 - agruen@suse.de
- fork command help update (Jean Delvare <khali@linux-fr.org>).
* mer avr 13 2005 - agruen@suse.de
- Add --sort options to the diff and refresh commands which
  sorts files by filename. The default is to keep files in their
  original order whenever possible.
- refresh command: add new files in sort order instead of the
  filesystem order.
- diff command: output files in the order in which they show up
  in the patch instead of sorting them alphabetically.
- Add sort testcase.
* mer avr 13 2005 - agruen@suse.de
- Fix typos in introduction.
* mar avr 05 2005 - agruen@suse.de
- doc/quilt.1.in: Remove an unnecessary 8-bit character.
* jeu mar 10 2005 - agruen@suse.de
- Debian Bug #298785: Pass -p $opt_strip_level option to diffstat
  in refresh command.
* lun mar 07 2005 - agruen@suse.de
- Another Japanese translation update from Yasushi SHOJI.
* dim mar 06 2005 - agruen@suse.de
- Add `graph', `grep' and `mail' to QUILT_IN in po/Makefile.
- Fix typo and translation updates.
- Add a missing ``exit 1'' to quilt/fold.in when no patches are
  applied. (All except the German translation update from Yasushi
  SHOJI -- thanks.)
* jeu fv 24 2005 - mquinson@debian.org
- quilt add: Add check to ensure that no symlink will be added since we fail
  to backup them properly (see #295913 in Debian).
* ven fv 18 2005 - agruen@suse.de
- quilt add: Add check to ensure that no files below patches/
  or .pc/ will be added.
* jeu fv 10 2005 - agruen@suse.de
- quilt remove: Update restored file's timestamp. Also, some uses
  caused a subsequent ``quilt diff -z'' to fail: we must mark
  the patch as dirty after removing files.
- test/run: adjust to terminal width.
- Bump version to 0.39.
* dim fv 06 2005 - agruen@suse.de
- Update of the Japanese translation from Yasushi SHOJI
  <yashi@atmark-techno.com> -- thank you.
- Don't leak so many temporary files in the push command.
- Include command names in tempfile names to find leaks more easily.
* mer fv 02 2005 - agruen@suse.de
- Fix date calculation bug with some versions of GNU date.
* mer fv 02 2005 - agruen@suse.de
- Use color defaults so that QUILT_COLORS can be used to only
  override some colors.
- When checking for remaining changes (refresh forgotten), use
  $QUILT_PATCH_OPTS as in the push command to get identical
  results. Don't generate the actually diff; it doesn't get
  printed anyway. This should speed things up.
* jeu jan 27 2005 - agruen@suse.de
- lib/backup-files.c: Remove unused command line option and
  document the remaining options.
- quilt/pop.in: Colorize this as well:
  "Patch attempted to create file *, which already exists."
  "can't find file to patch at input line *"
  "* out of * hunk ignored"
* mar jan 25 2005 - agruen@suse.de
- Fix pop command for recent coreutils (cp dir dir2/ no longer
  works if dir2 doesn't yet exist).
* dim jan 23 2005 - agruen@suse.de
- Add color support for push command output and allow to customize
  colors via the QUILT_COLORS environment variable (for reverse
  video, etc.).
* dim jan 23 2005 - agruen@suse.de
- Add mail command, doc/README.MAIL and example ``mail'' command
  filter in quilt.quiltrc.
- Bump version to 0.38.
* ven jan 21 2005 - agruen@suse.de
- Add a missing find_patch call in the files command.
* jeu jan 20 2005 - mquinson@debian.org
- fix the bash completion file: 
  - does not complete on dir anymore, just files.
  - use string comparison when dealing with BASH_VERSION, it may contain
    letters.
* mar jan 11 2005 - agruen@suse.de
- Add a default /etc/quilt.quiltrc file that is sourced if no
  ~/.quiltrc file exists.
* ven nov 19 2004 - agruen@suse.de
- Push command: Write out output of patch process immediately
  instead of reading into a variable and then printing that
  variable. This helps to see what's happening with large patches.
* lun nov 15 2004 - agruen@suse.de
- Get rid of the apatch and rpatch helper scripts: Integrate them
  in the push and pop commands. This should bring a small
  performance improvement.
* lun nov 08 2004 - agruen@suse.de
- Fix extra trailing space in series file after quilt refresh
  (David Vrabel <dvrabel@arcom.com>).
- Missing quotation in bash_completion
  (Axel Grossklaus <ag@pre-secure.de>).
- Fix patches command (Brent Casavant <bcasavan@sgi.com>).
* dim oct 17 2004 - agruen@suse.de
- When applying a patch with -q and without -f no (individual)
  reject files are created, and the "patching file" comments
  are missing as well. In that case, we don't know wich files the
  "-- saving rejects to file /tmp/foo" comments belong to, and we
  can't fix them up. Remove them, instead.
- Pop command: Touch files after they are restored so that tools
  like make don't get confused.
- Add a missing print_patch call (cosmetic).
- Bump to version 0.37.
* mer sep 22 2004 - agruen@suse.de
- scripts/patchfns.in: set the dotglob option so that dot files
  will show up in file globs as well. Bug reported by James Rowe.
- Add a missing tab to the patch header of files that are removed.
  Bug reported by James Rowe.
- Push command: Without -f or --leave-rejects, when applying a
  patch failed, the *.rej files were not removed properly. Change
  the code so that they won't be created in the working tree in
  the first place in this case.
- test/run script: Oops, the previous commit was not the latest
  version.
- Fix the version check in bash_completion for bash 3.
- Bump version to 0.36.
* mar sep 21 2004 - agruen@suse.de
- Series command: add missing paths to patches if
  $QUILT_PATCHES_PREFIX is set.
- test/run script: Add export and unset statements.
* lun sep 13 2004 - agruen@suse.de
- bin/quilt.in: Add optional verbose modifier to --trace option
  by request of Dean Roehrich <roehrich@sgi.com>.
- Fix a message; took a while. Thanks Yasushi SHOJI
  <yashi@atmark-techno.com>.
* dim sep 12 2004 - agruen@suse.de
- scripts/inspect.in: Run the RPM %prep section in /var/tmp and
  not in /tmp: the sources can become large.
- The fork command at some point broke and did not insert the
  "serial number" in the right place in patch names anymore.
* mer ao 25 2004 - agruen@suse.de
- Refresh command: recognize and ignore header lines generated by
  ``cvs diff''.
- Add a missing print_patch call (cosmetic).
* sam ao 14 2004 - agruen@suse.de
- Add Japanese translation from
  Yasushi SHOJI <yashi@atmark-techno.com>. Thank you.
* ven ao 13 2004 - agruen@suse.de
- setup command: detect errors when running ``rpm -bp'' and
  improve the messages of ``quilt setup''.
* mer ao 11 2004 - agruen@suse.de
- Merge improvement to files command from Dean Roehrich: Allow to
  list all files modified, or all files modified by a range of
  patches.
- Fix pop command help.
* mer ao 11 2004 - agruen@suse.de
- Working in sub-directories: `quilt new' so far did always
  create patches in the current directory, even if the current
  directory appeared to be a sub-directory of the working tree.
  This was confusing for several people now. Make `quilt new'
  behave like all other commands, and thus allow it to be used
  from within sub-directories.
* sam ao 07 2004 - mquinson@fuxfamily.org
- Small fix by Yasushi SHOJI: display the name of the patch which
  is not applied in the error message.
* jeu jui 22 2004 - mquinson@tuxfamily.org
- repharse the output of rpatch when patch does not remove properly:
  refreshing the patch is another way to fix it
- sync french translation.
* jeu jui 15 2004 - mquinson@tuxfamily.org
- patch from Joe Green to "Complete options for a partial command
  as long as it's unique. quilt will accept such a partial command
  as valid."
* jeu jui 15 2004 - agruen@suse.de
- Add test case for permissions.
- Very minor translation updates.
- Convert timestamps in changes file into UTC when generating
  the RPM changelog: the changelog does not understand
  timestamps.
- Bump version to 0.35.
* mar jui 13 2004 - mquinson@tuxfamily.org
- Fix a typo (s/prinf/printf/) reported by Dean Roehrich.
- Track down two variable expensions in printf $"" constructs.
- update the french translation accordingly
* lun jui 12 2004 - agruen@suse.de
- refresh command: Fix --diffstat option; it did swap lines. Also
  remove stray dollar sign.
- Also set TEXTDOMAINDIR in the wrapper script (bin/quilt.in).
- Fix stripping of the path to $QUILT_PATCHES when working in
  sub-dirextories. (This could be fixed more flexibly later...)
* lun jui 12 2004 - mquinson@tuxfamily.org
- Sync french translation after the recent butchery ;)
- Commit patch from Joe Green to make the completion file usable on
  non-debian systems.
* lun jui 12 2004 - agruen@suse.de
- Some more QUILT_PATCHES_PREFIX fixes.
- Disable CDPATH within quilt (Joe Green writes: I've seen some
  cases where having CDPATH set results in the path being printed
  by cd, and I suppose it's possible that the wrong destination
  might be selected in some cases.)
* ven jui 09 2004 - agruen@suse.de
- Switch from echo to printf for all translations: This is more
  stable than having expansions in messages that might change
  independent of the message.
- Add print_patch function and always use it when printing patch
  names. Remove -n options from various scripts and use a global
  switch QUILT_PATCHES_PREFIX in .quiltrc to decide between patch
  names with and without directory prefix. Depending on user
  experience this switch may eventually go away.
- Add --diffstat option to refresh command: If given, this option
  inserts diffstat statistics at the end of the patch header, or
  refreshes the existing diffstat output. No special tags in the
  path file (%diffstat or the like) are needed.
- Minor fix inserting changelog into RPM specfile.
* mer jui 07 2004 - mquinson@tuxfamily.org
- Fix the bash_completion by not using quilt internals, but the
  external commands [Joe Green].
* dim jui 04 2004 - agruen@suse.de
- Add common GNU diff format options to diff and refresh commands:
  -u, -U num, -c, -C num. Rename old -c option (combine patches)
  of diff command to --combine.
- Extend the function that splits comments from patches and
  syntax coloring to handle combined diff format.
- Honor the LANG environment variable again; this got broken at
  some point.
- Set TEXTDOMAINDIR to where the translations are put so that
  Messages are found even when not installing into /usr.
* ven jui 02 2004 - agruen@suse.de
- Several Fixes from Joe Green <jgreen@mvista.com>:
  + Another sed \t\r problem, in Makefile.in
  + Bad error message on "quilt delete" of non-existent patch
  + "import" doesn't remove all leading components on patch file
  + Misspelling in "import" help text
- With using the GNU diff --label option, file timestamps
  disappeared. Specify the timestamps in --label by hand: This
  gives us added flexibility when generating patches; we may
  some day want to support diff styles other than unified.
  Also reported by Joe Green.
- Add --backup option to quilt refresh.
- Update documentation to QUILT_${COMMAND}_ARGS in .quiltrc.
  (The old settings still work but they are no longer documented.)
- Update German translation.
* jeu jui 01 2004 - agruen@suse.de
- Allow passing of default options to commands by defining
  QUILT_${COMMAND}_ARGS in .quiltrc. This should eventually get
  us rid of some of the mess in .quiltrc.
* mer jun 30 2004 - agruen@suse.de
- Quilt diff: add --color option for optionally colorizing the
  output.
* sam jun 26 2004 - agruen@suse.de
- Quilt import: when importing patches with their original file
  name, strip path prefixes from the patch names.
* sam jun 12 2004 - agruen@suse.de
- Fix another upgrade bug: The series file may optionally contain
  a strip level argument (-pN) which must be stripped off when
  determining the patch name.
- A minor correction in the doumentation; some whitespace fixes.
- Translation update.
* ven jun 11 2004 - mquinson@tuxfamily.org
- Fix the man page generation
- Add a --no-timestamps option to diff and refresh doing what
  QUILT_NO_DIFF_TIMESTAMPS does. This should make more visible a
  feature I was about reimplementing ;)
- Document all options from the pdf into the man page.
- update the bash completion stuff so that :
  - it does not kill the shell when completing in a tree not matching the
    meta data version.
  - it does not move the current directory around, seeking for patches/
  - it completes on the new commands (grep graph upgrade)
- Various output messages polishing (and translation fuzzying)
- French translation unfuzzying
* jeu jun 10 2004 - agruen@suse.de
- Add meta-data version check/upgrade code from Martin Quinson and
  me; new `quilt upgrade' command.
- Handle new/removed files correctly in generated patches: If the
  old or new file is missing, the file name in the patch should
  be /dev/null. Fix test suite accordingly, and add
  test/create-delete.diff. GNU patch recognizes this, and does
  additional file existance tests when a patch creates/deletes a
  file. Also use the --label option of GNU diff instead of
  hand-editing file name headers.
- Add test/Makefile for running the test suite. Note: The tests
  run against the installed version of quilt!
- Bump version to 0.34.
* dim jun 06 2004 - agruen@suse.de
- Preserve the order of files in patches in the diff and refresh
  commands. Files added to a patch appear at the end of a patch.
  The files command also lists the files in the order in which
  they appear in patches.
- Update to version 0.33.
* dim jun 06 2004 - agruen@suse.de
- dependency-graph: Fix for --lines option in patcher mode;
  restrict to applied patches.
* dim jun 06 2004 - agruen@suse.de
- import: Create patches/ and parent directories to patch to be
  imported. Insert the correct patch name in the series file.
* dim jun 06 2004 - agruen@suse.de
- backup-file.c: Add code to recursively search .pc directories.
  Add a "no-op" mode as default, and allow to just unlink files.
- apatch/rpatch: let backup-files search .pc directories instead
  of generating temporary file lists.
- rpatch/pop: unlink files of topmost patch after popping instead
  of unlinking at each step.
- If QUILTRC is set in the environment, use this as the
  configuration file.
* sam jun 05 2004 - agruen@suse.de
- Return exit status 2 when commands go beyond the series (top
  with no series, push/next when all patches are applied, pop/
  previous when no patches are applied).
- From  John Lenz <jelenz@students.wisc.edu>: Add compatibility
  code to the dependency-graph script for reading the meta-data
  of Holger Schurig's patcher tool,
  http://www.holgerschurig.de/patcher.html.
- Update German translation.
* mar jun 01 2004 - agruen@suse.de
- Fix from Dean Roehrich <roehrich@sgi.com>: Preserve file mode
  of original file when creating backup files.
* mar jun 01 2004 - mquinson@tuxfamily.org
- document common options to all scripts (--trace and --quiltrc)
- update french translation
* lun mai 31 2004 - agruen@suse.de
- Rewrite spec2series to return what the new `quilt setup' needs,
  and rename it to inspect.
- `quilt setup': Rewrite so that it supports multiple archives
  per spec file. Always make the patches directory a symlink to
  the original patch files instead of copying the patches.
- Update German translation.
* dim mai 16 2004 - agruen@suse.de
- Clarify help text of `quilt add' (thanks to  Tom Rini
  <trini@mvista.com>). Update translations.
* sam mai 15 2004 - agruen@suse.de
- Add `quilt grep': Grep over all files, recursively, skipping
  the $QUILT_PATCHES and $QUILT_PC directories.
* mar avr 27 2004 - agruen@suse.de
- Fix `quilt fork': It destroys .pc/applied patches; that bug got
  introduced when reverting it to its previous semantics.
* mer avr 21 2004 - agruen@suse.de
- Replace two occurrences of \t in sed regular expressions
  with bash $'\t': Some older versions of sed don't understand
  \t. Thanks to Randy Dunlap <rddunlap@osdl.org> and Greg Edwards
  <edwardsg@sgi.com> for reporting.
* sam mar 20 2004 - agruen@suse.de
- Fix an algorithmic bug in `quilt graph --lines': Edges were
  sometimes lost.
- A few minor cleanups.
* dim mar 14 2004 - agruen@suse.de
- Extend `quilt graph' to also support checking for overlapping
  changes in patches.
- Export QUILT_PATCHES QUILT_PC SUBDIR SERIES DB for use in
  non-shell components of quilt.
* sam mar 13 2004 - agruen@suse.de
- Change `quilt import' to allow importing multiple patches
  at once.
- Fix a bug in backup-files.c (introduced just before).
- Update to version 0.32.
* sam mar 13 2004 - agruen@suse.de
- Add `quilt graph' command for generating a dependency graph
  between patches. This requires the graphviz package for
  removing transitive edges (optional) and for rendering the
  graph. Please note that the graph command itself is minimal,
  while the underlying scripts/dependency-graph is more flexible.
- Complete one more detail in scripts/dependency-graph.
- Revert `quilt fork' to how it originally worked: fork the
  *topmost* patch, not the next unapplied patch. Adapt the
  test suite accordingly.
- Add flag to backup-files.c to make sure that files in the
  working tree have a link count of at most one. Use this where
  appropriate.
- Fix a bug in `quilt snapshot': Taking snapshots caused files
  to get link counts bigger than one, so modifying them could
  cause multiple files to get modified. Speed up the command,
  too.
- Update the documentation. Add example1.test from the
  documentation.
* mer mar 10 2004 - agruen@suse.de
- Quilt push/pop: exit with a non-zero status when beyond series.
- Ignore empty lines in series file.
- Add man page to tarball and to spec file; add make dependencies.
- Sort the commands in the man page command reference.
* mar mar 09 2004 - agruen@suse.de
- Make files writeable in `quilt add' (and `quilt edit') for
  working with read-only trees.
* mer fv 25 2004 - martin.quinson@tuxfamily.org
- Add completion to the edit command in bash
* dim fv 22 2004 - martin.quinson@tuxfamily.org
- Add a man page (generated automatically from -h)
* sam fv 21 2004 - agruen@suse.de
- Sub-directory support: `quilt setup' could get confused, too.
* ven fv 20 2004 - agruen@suse.de
- Sub-directory support:
  + Fix another bug that triggers when /patches exists.
  + Working in sub-directories: Force `quilt new' to always create
    the new patch in the current working directory even if there
    is a patches/ sub-directory further up the directory tree. 
    This should restore the behavior from before Jan 28 very well.
- quilt files, diff, refresh: Sort the files in the patch
  alphabetically.
* dim fv 15 2004 - agruen@suse.de
- Never fail when patching temporary files in `quilt diff -z',
  only warn.
* jeu fv 05 2004 - agruen@suse.de
- Add some fixes from Manuel Estrada Sainz <ranty@debian.org>.
- Add QUILT_SERIES setting: Override the location of the series
  file to use.
- Don't print an empty line for `quilt top' if no patches are
  applied.
* mar fv 03 2004 - agruen@suse.de
- Add --quiltrc={rcfile|-} option. Remove some superfluous quoting
  from quilt wrapper.
- Extra tests in `quilt refresh' did not check if the old patch
  was missing.
* lun fv 02 2004 - agruen@suse.de
- Fix test for bash in configure.ac.
- Add `--trace' option to quilt wrapper (runs commands with -x,
  which prints an execution trace).
- Add QUILT_BACKUP setting in .quiltrc (creates backup copies
  when refreshing patches).
- Fix `quilt next'.
* sam jan 31 2004 - agruen@suse.de
- Also fix `quilt import' after patch name mangling removal.
* sam jan 31 2004 - agruen@suse.de
- No longer remove common extensions (.dif, .diff, .patch, .gz,
  .bz2) from patch names. This allows patches in the same series
  that only differ by extension, and cleans up the scripts a
  little. Also don't remove extensions when printing patch names.
- Remove unused diffstat code.
- Fix generating doc/README after subdirectory support broke it.
- Remove excessive newlines in -h messages.
* mer jan 28 2004 - agruen@suse.de
- Fix bugs introduced while merging Chris's patch.
- Add more test cases for subdirectory support.
- Fix `make dist': Some files in debian/ did not exist.
- Update to version 0.30.
* mer jan 28 2004 - agruen@suse.de
- Patch from Chris Mason <mason@suse.de>: Add support for working
  in subdirectories of the base directory that contains patches/
  and .pc/. In the unlikely case that quilt shall operate in the
  sub-directory itself, it is sufficient to create a patches/
  directory there.
- Add a small testcase for subdirectory support.
* sam jan 24 2004 - agruen@suse.de
- Add QUILT_NO_DIFF_TIMESTAMPS option in .quiltrc.
- Add QUILT_PATCH_OPTS setting to allow passing options to
  GNU patch.
- Fix help for `quilt diff'.
* jeu jan 08 2004 - agruen@suse.de
- Also accept `quilt diff -z ./file' (ignore the ./ prefix that
  is often produced by find etc.)
* jeu nov 27 2003 - agruen@suse.de
- `quilt fold' did not create directories for additional files,
  and the code for recovering from failures was wrong.
* mar nov 25 2003 - agruen@suse.de
- Update quilt paper.
* lun nov 24 2003 - agruen@suse.de
- Error check for `quilt diff -z filelist' was too strict; relax.
* lun nov 17 2003 - agruen@suse.de
- Add new command `quilt fold' to fold one patch into another.
- Fix bug in `quilt files': Files that are neither present in the
  working directory and have an empty backup copy sometimes were
  still listed.
- Some minor cleanups in apatch.
- Add test/fold.test, and fix a now-useless check in one.test.
* sam nov 15 2003 - agruen@suse.de
- Merge some changes from wangdi:
  + Use -f (force) option of GNU patch in `quilt diff -z'.
  + Build source and binary RPMs in `make rpm' target.
  + Simplify sed expression in Makefile.in.
* mer nov 12 2003 - agruen@suse.de
- Add introductory paper to CVS repository.
- Remove obsolete documentation.
- Bump version number to 0.29 (cvs tag VER_0_29).
* mar nov 04 2003 - agruen@suse.de
- Add failpop.test that checks if modified patches are recognized.
- Fix the check for modified patches: That broke with the .pc file
  removal.
- `quilt setup' sometimes forgot to create the patches sub-dir.
- Fix the timestamp check in scripts/rpatch.in for missing files.
* ven oct 31 2003 - agruen@suse.de
- Bump version number to 0.28 (cvs tag VER_0_28).
* ven oct 31 2003 - agruen@suse.de
- No longer verify if patches remove cleanly by reverse applying
  them: This doesn't always succeed, and the  the equivalent of
  `quilt diff -z' should suffice, anyway.
- Add `touch .pc/$patch' after successful refresh: Speeds up
  `quilt pop' after a refresh.
- Update test suite.
- apatch was printing a spurious newline.
* mer oct 29 2003 - agruen@suse.de
- If a patch does not apply cleanly and `quilt push' removes
  rejects files it GNU patch left behind, change the output from
  ``saving rejects to file x.rej'' to ``rejects in file x''.
* mar oct 28 2003 - agruen@suse.de
- Remove .pc/*/.pc files, and adjust various scripts accordingly.
- Run test/one.test inside sub-directory.
- Bump version number to 0.27 (cvs tag VER_0_27).
* mar oct 28 2003 - agruen@suse.de
- Change name and semantics of PATCHSCRIPTS variable: Before, if
  PATCHSCRIPTS was set, the patches were in $PATCHSCRIPTS/patches.
  Now, if QUILT_PATCHES is set, the patches are in $QUILT_PATCHES.
  QUILT_PATCHES defaults to "patches", like before.
* dim oct 26 2003 - agruen@suse.de
- Get rid of patches_per cache_in `quilt patches'. Remove
  patches_per_file and associated functions. `quilt patches'
  now is a bit slow for unapplied patches.
* dim oct 26 2003 - agruen@suse.de
- Rename snapshot directory from ".snap0" to ".snap".
- `quilt diff: Speed up file list generation in `quilt diff'.
  Don't use modified_files anymore. Instead, add first_modified_by
  function. I want to get rid of the patches_per_file cache;
  it sometimes was not brought up to date. Some cleanups.
- Add test/snapshot.test.
- Fix two errors in the date format in quilt.changes.
* jeu oct 23 2003 - agruen@suse.de
- `quilt add': Return exit code 2 when a file has already been
  added.
- Add `quilt edit' command: Does a `quilt add' and then invokes
  $EDITOR (fallback is `vi'). Files that don't exist after editing
  are again removed from the patch.
* mar oct 21 2003 - agruen@suse.de
- `Quilt fork' should better fork the next patch instead of the
  topmost one. Also fix a bug in updating the series file when
  forking. The rename_in_db() function is no longer needed.
* mar oct 21 2003 - agruen@suse.de
- Add `quilt fork' command.
- Add `quilt snapshot' command and `quilt diff --snapshot' option.
- Bump the version number to 0.26.
* mar sep 09 2003 - martin.quinson@tuxfamily.org
- fix LC_ALL to C during building the reference so that the 
  documentation comes to english and not to french when build 
  on my box.
- Update the french translation
- Bump the version number to 0.25
* mar sep 02 2003 - agruen@suse.de
- Pipe rpmbuild output to /dev/null in spec2series (seems to be
  necessary since rpm4).
* dim jui 27 2003 - agruen@suse.de
- Use %{find_lang} macro in spec file.
* sam jui 26 2003 - agruen@suse.de
- Pushing is only possible if the topmost file is found in the
  series file. Fix from Tom Wang <wangdi@clusterfs.com>.
* sam jui 26 2003 - agruen@suse.de
- When popping files, go through the list of applied patches
  instead of looking at the series file: The series file may
  have changed.
* sam jui 26 2003 - agruen@suse.de
- Install package documentation into $RPM_DOC_DIR if this
  environment variable is set.  On RedHat 9 $RPM_DOC_DIR points to
  /usr/share/doc/packages, but documentation lives in
  /usr/share/doc.  This is a bug in RedHat's RPM configuration;
  working around it would break other distributions.
* mer jui 23 2003 - agruen@suse.de
- Add Autoconf test for rpmbuild vs. rpm (needed for `make rpm').
- Update spec2series accordingly.
* sam jui 19 2003 - agruen@suse.de
- lib/backup-files.c: Copy files if hard linking is not possible,
  e.g., because the backups go to a ram disc, etc.
* jeu jun 26 2003 - martin.quinson@tuxfamily.org
- Add what needed to have inteligent bash completion when using quilt
- Bump version to 0.24
* mer jun 25 2003 - martin.quinson@tuxfamily.org
- Make clean before dist to avoid to put cruft in tarballs
- remove po/*mo on make clean
- update fr.po
- Fix a typo in push.in help message about --interactive
* mar mai 20 2003 - agruen@suse.de
- Preserve permissions of files added with `quilt add'.
* dim mai 18 2003 - agruen@suse.de
- Do not add the whole /usr/share/locale directory to the RPM
  file list, but only the quilt message catalogs: Otherwise RPM
  complains when uninstalling.
* ven mai 16 2003 - agruen@suse.de
- Rename DIFF_OPTS environment variable to QUILT_DIFF_OPTS
- Add ~/.quiltrc resource file (this file is sourced from
  the patchfsn file, which is used by all commands).
* ven avr 11 2003 - agruen@suse.de
- Apply patches with `patch -f' by default. Add --interactive
  option top `quilt push' to allow applying patches without
  `patch -f'.
* mer avr 09 2003 - agruen@suse.de
- Remove awk hacks in Makefile.in with shell loop and sed hack:
  The awk hack(s) didn't work for Martin Quinson.
* mer avr 09 2003 - agruen@suse.de
- Never reorder files in patches. (Previously the file list
  was run through (sort | uniq) to remove duplicate entries.)
- Update test script to new format, and add regression test
  cases.
* mer avr 09 2003 - agruen@suse.de
- The change from Mar 24 caused empty lines to be removed in
  patch descriptions.
* lun avr 07 2003 - agruen@suse.de
- `head -1' and `tail -1' is non-standard and deprecated, and
  does not work with coreutils-5.0 any longer.
* sam avr 05 2003 - agruen@suse.de
- Improve error checking of `quilt diff'.
* lun mar 24 2003 - agruen@suse.de
- Update patch_description function used in `quilt refresh' to
  recognize `====' lines. Without that, quilt thinks these
  lines are part of the comments before the actual patch starts,
  so those lines will accumulate.
* dim mar 23 2003 - agruen@suse.de
- Update test script to reflect recent patch format changes.
* sam mar 22 2003 - agruen@suse.de
- Also substitute @SED@ and @AWK@.
- Some versions of sed don't like '\t'. Expand those in the
  shell instead.
* ven mar 21 2003 - agruen@suse.de
- Bump version number to 0.23 (CVS tag VER_0_23).
* ven fv 14 2003 - agruen@suse.de
- A couple more I18N fixes, minor cleanups in status messages.
- Remove "quilt guidiff" (obsolete).
* ven fv 14 2003 - martin.quinson@tuxfamily.org
- Implement i18n, along with the french l10n.
- It was long enough that we didn't release, so bump the version number.
* sam fv 08 2003 - agruen@suse.de
- Merge James Rowe <Jay@jnrowe.uklinux.net>'s quilt-help.diff
  patch that fixes several help messages.
* jeu fv 06 2003 - agruen@suse.de
- Quilt refresh: Create sub-directories in patches directory
  so that new patches in sub-directories can be added easily.
* mer fv 05 2003 - agruen@suse.de
- Quilt diff: If a patch has been force applied, quilt diff -z
  will also have failures when generating the temporary files.
  Ignore these failures in this case.
- Add -R option to quilt diff to generate a a reverse patch.
- Fix deleting the temporary directory (by using an absolute
  instead of a relative path).
* dim fv 02 2003 - agruen@suse.de
- Make quilt setup recognize the "# Sourcedir:" directive.
- Fix bug with spurious `Index:' lines in diff/refresh output.
- Add --diff option to quilt diff that allows to specify a
  different utility that diff to run files through. (That utility
  is only called for files that contain differences, not for
  files that are in a patches' file list but jave not been
  changed.)
* sam fv 01 2003 - agruen@suse.de
- Integrate James Rowe's Autoconf setup (with a comple of
  additional changes/fixes).
- Add some messages in configure.ac.
- Make distclean removes autoconf garbage. The configure script is
  no source file. Add rule to create it when necessary.
- Invoke configure in the RPM spec file.
- Merge James Rowe's guidiff.
* ven jan 31 2003 - agruen@suse.de
- Add syntax highlighting tags for emacs and vim.
- Move all scripts from lib/ to scripts/. Install lib/backup-files
  in /usr/lib/quilt/, and install the scripts in
  /usr/share/quilt/scripts/, so that no binaries are installed
  under /usr/share.
- Fix quoting strings for inclusion in regular expressions.
- Change literal '@SUBST@' strings in Makefile to '@SUBST''@',
  so that Autoconf won't mess them up later.
* ven jan 31 2003 - Martin.Quinson@ens-lyon.fr
- Change '#!@BASH@' to '#! @BASH@'. It can look a bit stupid, but
  it's needed for maximal portability.
* ven jan 31 2003 - Martin.Quinson@ens-lyon.fr
- Fight lintian warnings (lintian is a tool to check debian
  packages):
- Remove the dependencies on essential packages diff, gzip,
  debianutils
- Format the copyright file properly
- Remove the #! /bin/bash header from patchfns, since it's not an
  executable script, but a stuff to be sourced by others.
* jeu jan 30 2003 - agruen@suse.de
- Also substitute @MKTEMP@.
- For improved scripting support, add -n option to scripts that
  print patch names prints the patch file name instead. This
  is useful for selecting which patches to grep, etc.
* jeu jan 30 2003 - agruen@suse.de
- Allow a file list to be diffed to be passed to quilt diff. Add
  -P option for specifying a patch different from the topmost
  patch,
* jeu jan 30 2003 -  Martin.Quinson@ens-lyon.fr
- Remove useless oldies. Missing functionnalities needs to be
  reimplemented almost from the scratch due to the bunch of
  changes to the core since those scripts were written.
* jeu jan 30 2003 - agruen@suse.de
- Fix some regex quoting; use grep -E because we quote for extended
  regexps. Filenames with "+^$" in it did not work in some places. 
- Prepare for GNU Autoconf: substitute @PERL@, @BASH@, @DIFF@,
  @PATCH@ in scripts.
- Some cleanups in Makefile.
- Move documentation to doc/.
- Forgot to mention that the patches produced now contain
  `Index: dir/filename' just before the diff output for each file.
  This is required by POSIX, and is also used by diffstat.
- Adjust patch_description documentation extraction function to
  check for Index: lines.
- Quilt refresh looses text before actual patch due to but in
  patch_description function.
* mar jan 28 2003 - agruen@suse.de
- Add --leave-rejects option to quilt push and apatch, to
  leave reject files around for inspection even if a patch
  does not apply.
* mar jan 28 2003 - agruen@suse.de
- Restart change log at quilt-0.21. Let orderly development
  begin :)

