#
# spec file for quilt - patch management scripts
#

Name:		quilt
Summary:	Scripts for working with series of patches
License:	GPL
Group:		Productivity/Text/Utilities
Version:	0.34
Release:	1
Requires:	coreutils diffutils patch gzip bzip2 perl mktemp gettext
Autoreqprov:	off
Source:		quilt-%{version}.tar.gz
BuildRoot:	%{_tmppath}/%{name}-%{version}-build

%description
The scripts allow to manage a series of patches by keeping
track of the changes each patch makes. Patches can be
applied, un-applied, refreshed, etc.

The scripts are heavily based on Andrew Morton's patch scripts
found at http://www.zip.com.au/~akpm/linux/patches/.

Authors:
--------
    Andrew Morton <akpm@digeo.com>
    Andreas Gruenbacher <agruen@suse.de>

%prep
%setup

%build
./configure
make prefix=/usr BUILD_ROOT=$RPM_BUILD_ROOT

%install
rm -rf $RPM_BUILD_ROOT
make install prefix=/usr BUILD_ROOT=$RPM_BUILD_ROOT
%{find_lang} %{name}

%clean
rm -rf $RPM_BUILD_ROOT

%files -f %{name}.lang
%defattr(-, root, root)
/usr/bin/guards
/usr/bin/quilt
/usr/share/quilt/
/usr/lib/quilt/
/etc/bash_completion.d/quilt
%doc %{_mandir}/man1/guards.1.gz
%doc %{_mandir}/man1/quilt.1.gz
%doc %{_docdir}/%{name}-%{version}/README
%doc %{_docdir}/%{name}-%{version}/quilt.pdf

%changelog
* Thu Jun 10 2004 - agruen@suse.de
- Add meta-data version check/upgrade code from Martin Quinson and
  me; new `quilt upgrade' command.
- Handle new/removed files correctly in generated patches: If the
  old or new file is missing, the file name in the patch should
  be /dev/null. Fix test suite accordingly, and add
  test/create-delete.diff. GNU patch recognizes this, and does
  additional file existance tests when a patch creates/deletes a
  file. Also use the --label option of GNU diff instead of
  hand-editing file name headers.
- Add test/Makefile for running the test suite. Note: The tests
  run against the installed version of quilt!
- Bump version to 0.34.
* Sun Jun  6 2004 - agruen@suse.de
- Preserve the order of files in patches in the diff and refresh
  commands. Files added to a patch appear at the end of a patch.
  The files command also lists the files in the order in which
  they appear in patches.
- Update to version 0.33.
* Sun Jun  6 2004 - agruen@suse.de
- dependency-graph: Fix for --lines option in patcher mode;
  restrict to applied patches.
* Sun Jun  6 2004 - agruen@suse.de
- import: Create patches/ and parent directories to patch to be
  imported. Insert the correct patch name in the series file.
* Sun Jun  6 2004 - agruen@suse.de
- backup-file.c: Add code to recursively search .pc directories.
  Add a "no-op" mode as default, and allow to just unlink files.
- apatch/rpatch: let backup-files search .pc directories instead
  of generating temporary file lists.
- rpatch/pop: unlink files of topmost patch after popping instead
  of unlinking at each step.
- If QUILTRC is set in the environment, use this as the
  configuration file.
* Sat Jun  5 2004 - agruen@suse.de
- Return exit status 2 when commands go beyond the series (top
  with no series, push/next when all patches are applied, pop/
  previous when no patches are applied).
- From  John Lenz <jelenz@students.wisc.edu>: Add compatibility
  code to the dependency-graph script for reading the meta-data
  of Holger Schurig's patcher tool,
  http://www.holgerschurig.de/patcher.html.
- Update German translation.
* Tue Jun  1 2004 - agruen@suse.de
- Fix from Dean Roehrich <roehrich@sgi.com>: Preserve file mode
  of original file when creating backup files.
* Tue Jun  1 2004 - mquinson@tuxfamily.org
- document common options to all scripts (--trace and --quiltrc)
- update french translation
* Mon May 31 2004 - agruen@suse.de
- Rewrite spec2series to return what the new `quilt setup' needs,
  and rename it to inspect.
- `quilt setup': Rewrite so that it supports multiple archives
  per spec file. Always make the patches directory a symlink to
  the original patch files instead of copying the patches.
- Update German translation.
* Sun May 16 2004 - agruen@suse.de
- Clarify help text of `quilt add' (thanks to  Tom Rini
  <trini@mvista.com>). Update translations.
* Sun May 16 2004 - agruen@suse.de
- Add `quilt grep': Grep over all files, recursively, skipping
  the $QUILT_PATCHES and $QUILT_PC directories.
* Wed Apr 28 2004 - agruen@suse.de
- Fix `quilt fork': It destroys .pc/applied patches; that bug got
  introduced when reverting it to its previous semantics.
* Wed Apr 21 2004 - agruen@suse.de
- Replace two occurrences of \t in sed regular expressions
  with bash $'\t': Some older versions of sed don't understand
  \t. Thanks to Randy Dunlap <rddunlap@osdl.org> and Greg Edwards
  <edwardsg@sgi.com> for reporting.
* Sat Mar 20 2004 - agruen@suse.de
- Fix an algorithmic bug in `quilt graph --lines': Edges were
  sometimes lost.
- A few minor cleanups.
* Mon Mar 15 2004 - agruen@suse.de
- Extend `quilt graph' to also support checking for overlapping
  changes in patches.
- Export QUILT_PATCHES QUILT_PC SUBDIR SERIES DB for use in
  non-shell components of quilt.
* Sun Mar 14 2004 - agruen@suse.de
- Change `quilt import' to allow importing multiple patches
  at once.
- Fix a bug in backup-files.c (introduced just before).
- Update to version 0.32.
* Sun Mar 14 2004 - agruen@suse.de
- Add `quilt graph' command for generating a dependency graph
  between patches. This requires the graphviz package for
  removing transitive edges (optional) and for rendering the
  graph. Please note that the graph command itself is minimal,
  while the underlying scripts/dependency-graph is more flexible.
- Complete one more detail in scripts/dependency-graph.
- Revert `quilt fork' to how it originally worked: fork the
  *topmost* patch, not the next unapplied patch. Adapt the
  test suite accordingly.
- Add flag to backup-files.c to make sure that files in the
  working tree have a link count of at most one. Use this where
  appropriate.
- Fix a bug in `quilt snapshot': Taking snapshots caused files
  to get link counts bigger than one, so modifying them could
  cause multiple files to get modified. Speed up the command,
  too.
- Update the documentation. Add example1.test from the
  documentation.
* Wed Mar 10 2004 - agruen@suse.de
- Quilt push/pop: exit with a non-zero status when beyond series.
- Ignore empty lines in series file.
- Add man page to tarball and to spec file; add make dependencies.
- Sort the commands in the man page command reference.
* Tue Mar  9 2004 - agruen@suse.de
- Make files writeable in `quilt add' (and `quilt edit') for
  working with read-only trees.
* Wed Feb 25 2004 - martin.quinson@tuxfamily.org
- Add completion to the edit command in bash
* Sun Feb 22 2004 - martin.quinson@tuxfamily.org
- Add a man page (generated automatically from -h)
* Sat Feb 21 2004 - agruen@suse.de
- Sub-directory support: `quilt setup' could get confused, too.
* Fri Feb 20 2004 - agruen@suse.de
- Sub-directory support:
  + Fix another bug that triggers when /patches exists.
  + Working in sub-directories: Force `quilt new' to always create

